/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.text.ClipboardManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import de.greenrobot.event.EventBus;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.RongActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.adapter.MultiItemViewListAdapter;
import io.rong.imkit.common.IVoiceHandler;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.data.DBHelper;
import io.rong.imkit.fragment.ActionBaseFragment;
import io.rong.imkit.fragment.BaseConversationFragment;
import io.rong.imkit.fragment.ShowDownloadImageFragment;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.utils.Util;
import io.rong.imkit.view.ConversationMessageBar;
import io.rong.imkit.view.CoverFrameLayout;
import io.rong.imkit.view.LoadingDialog;
import io.rong.imkit.view.PullDownRefreshListView;
import io.rong.imkit.view.SelectDialog;
import io.rong.imkit.view.VoiceCoverView;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.util.ArrayList;
import java.util.List;

public class ConversationFragment
extends BaseConversationFragment
implements PullDownRefreshListView.OnRefreshListener,
ConversationMessageBar.ConversationMessageBarListener,
View.OnTouchListener,
ConversationMessageBar.OnRichIconTextViewClickListener,
BaseViewProvider.OnMessageItemClickListener,
CoverFrameLayout.OnTriggeredTouchListener,
BaseViewProvider.OnGetDataListener {
    public static final String TAG = "ConversationFragment";
    public static final int GET_SQLITE_DATA_DEFALUT_COUNT = 10;
    private static final int HANDLE_NOTIFY_LOAD_DATA = 1101;
    private static final int HANDLE_GET_DISCUSSION_INFO = 1103;
    private static final int HANDLE_GET_USERINFO_FOR_TITLE = 1104;
    private static final int HANDLER_CREATE_SUCCESS = 1105;
    private static final int HANDLER_CREATE_FAIL = 1106;
    private static final int HANDLER_RELOAD_DATA = 1107;
    private static final int HANDLER_NOTIFICATION_MESSAGE = 1108;
    private static final int HANDLE_SHOW_MESSAGE = 1109;
    private LoadingDialog mDialog;
    private PullDownRefreshListView mListView;
    private ConversationMessageBar mConversationMessageBar;
    private TextView mConnectStateTextView;
    private CoverFrameLayout mFrameLayout;
    private VoiceCoverView mCoverView;
    private IVoiceHandler mVoiceHandler;
    private View mHideCover;
    private MultiItemViewListAdapter mConversationAdapter;
    private UIConversation mConversation;
    private boolean mIsHaveDBMessage = true;
    private int mUnReadMessageCount = 0;
    private int mLastSelectMsgId;
    private boolean mIsSendingMessage = false;
    private ImageView settingView;
    private View.OnKeyListener mOnKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 0) {
                if (ConversationFragment.this.mConversationMessageBar.isShowRichOrExpressionView()) {
                    ConversationFragment.this.mConversationMessageBar.setRichOrExpressionViewVisibility();
                    ConversationFragment.this.mConversationMessageBar.setExpressionImageViewDefault();
                    return true;
                }
                if (RCloudContext.getInstance() == null || DBHelper.getInstance() == null || RCloudContext.getInstance().getRongIMClient() == null) {
                    RongToast.toast((Context)ConversationFragment.this.getActivity(), Res.getInstance((Context)ConversationFragment.this.getActivity()).string("re_start_app"));
                    ConversationFragment.this.getActivity().finish();
                    return false;
                }
                ConversationFragment.this.getActivity().finish();
                return false;
            }
            return false;
        }
    };
    Handler mVoipHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.obj == null) {
                return;
            }
            final UIUserInfo peerUser = (UIUserInfo)msg.obj;
            final String mySelfId = ConversationFragment.this.getCurrentUserInfo() != null ? ConversationFragment.this.getCurrentUserInfo().getUserId() : "";
            final String mySelfName = ConversationFragment.this.mConversationAdapter.getUserInfo(mySelfId) == null ? "\u672a\u77e5" : ConversationFragment.this.mConversationAdapter.getUserInfo(mySelfId).getName();
            Log.i((String)"aff", (String)("===========onVoipRichTextClick==================mySelfId=" + mySelfId + "====peerUId=" + peerUser.getUserId() + "===" + peerUser.getName() + "===" + mySelfName + "===" + peerUser.getPortraitUri()));
            if (mySelfId.equals(peerUser.getUserId())) {
                Toast.makeText((Context)ConversationFragment.this.getActivity(), (CharSequence)"\u4e0d\u652f\u6301\u81ea\u5df1\u7ed9\u81ea\u5df1\u8bed\u97f3\u901a\u8bdd\uff01", (int)1).show();
                return;
            }
            ConnectivityManager connManager = (ConnectivityManager)ConversationFragment.this.getActivity().getSystemService("connectivity");
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            if (null == networkInfo) {
                Toast.makeText((Context)ConversationFragment.this.getActivity(), (CharSequence)"\u5f53\u524d\u7684\u7f51\u7edc\u8fde\u63a5\u4e0d\u53ef\u7528", (int)0).show();
            } else {
                boolean available = networkInfo.isAvailable();
                if (available) {
                    NetworkInfo.State state = connManager.getNetworkInfo(1).getState();
                    if (NetworkInfo.State.CONNECTED == state) {
                        Log.d((String)"\u901a\u77e5", (String)"=========WIFI\u7f51\u7edc\u5df2\u8fde\u63a5================");
                        Intent videoChatInt = null;
                        try {
                            videoChatInt = new Intent((Context)ConversationFragment.this.getActivity(), Class.forName("io.rong.voipkit.activity.CallSideActivity"));
                            videoChatInt.putExtra("appId", RCloudContext.getInstance() != null ? RCloudContext.getInstance().getAppKey() : "");
                            videoChatInt.putExtra("token", ConversationFragment.this.getActivity().getSharedPreferences("RONG_SDK", 0).getString("token_value", ""));
                            videoChatInt.putExtra("mySelfId", mySelfId);
                            videoChatInt.putExtra("myselfName", mySelfName);
                            videoChatInt.putExtra("peerUId", peerUser.getUserId());
                            videoChatInt.putExtra("peerUserName", peerUser.getName());
                            videoChatInt.putExtra("peerUserPhoteUri", peerUser.getPortraitUri());
                            ConversationFragment.this.startActivity(videoChatInt);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    state = connManager.getNetworkInfo(0).getState();
                    if (NetworkInfo.State.CONNECTED == state) {
                        Log.i((String)"\u901a\u77e5", (String)"===========GPRS\u7f51\u7edc\u5df2\u8fde\u63a5================");
                        new AlertDialog.Builder((Context)ConversationFragment.this.getActivity()).setTitle((CharSequence)"\u5f53\u524d\u662f3G\u7f51\u7edc\uff0c\u662f\u5426\u7ee7\u7eed\uff1f").setMessage((CharSequence)"\u786e\u5b9a\u5417\uff1f").setPositiveButton((CharSequence)"\u662f", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                Intent videoChatInt = null;
                                try {
                                    videoChatInt = new Intent((Context)ConversationFragment.this.getActivity(), Class.forName("io.rong.voipkit.activity.CallSideActivity"));
                                    videoChatInt.putExtra("appId", RCloudContext.getInstance() != null ? RCloudContext.getInstance().getAppKey() : "");
                                    videoChatInt.putExtra("token", ConversationFragment.this.getActivity().getSharedPreferences("RONG_SDK", 0).getString("token_value", ""));
                                    videoChatInt.putExtra("mySelfId", mySelfId);
                                    videoChatInt.putExtra("myselfName", mySelfName);
                                    videoChatInt.putExtra("peerUId", peerUser.getUserId());
                                    videoChatInt.putExtra("peerUserName", peerUser.getName());
                                    videoChatInt.putExtra("peerUserPhoteUri", peerUser.getPortraitUri());
                                    ConversationFragment.this.startActivity(videoChatInt);
                                }
                                catch (ClassNotFoundException e) {
                                    e.printStackTrace();
                                }
                            }
                        }).setNegativeButton((CharSequence)"\u5426", null).show();
                    }
                } else {
                    Log.i((String)"\u901a\u77e5", (String)"\u5f53\u524d\u7684\u7f51\u7edc\u8fde\u63a5\u4e0d\u53ef\u7528");
                    Toast.makeText((Context)ConversationFragment.this.getActivity(), (CharSequence)"\u5f53\u524d\u7684\u7f51\u7edc\u8fde\u63a5\u4e0d\u53ef\u7528", (int)0).show();
                }
            }
        }
    };

    public void onResume() {
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().getRongIMClient();
            RongIMClient.clearNotifications();
            RCloudContext.getInstance().setNotificationNewMessageCount(0);
            RCloudContext.getInstance().clearNotificationUserIdList();
            RCloudContext.getInstance().setConnectionStatusListener(new RCloudContext.ConnectionStatusListener(){

                @Override
                public void onChanged(int code) {
                    ConversationFragment.this.setNetStatus(code);
                }
            });
        }
        if (this.mConversation != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getTargetId())) {
            this.setCurrentConversationTargetId(this.mConversation.getTargetId());
        }
        super.onResume();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EventBus.getDefault().register(this);
        this.mVoiceHandler = new IVoiceHandler.VoiceHandler((Context)this.getActivity(), this.getActivity().getCacheDir());
        Intent intent = this.getActivity().getIntent();
        if (intent != null) {
            if (intent.getData() != null && intent.getData().getScheme().equals("rong")) {
                this.parserIntent(intent);
            } else {
                this.mConversation = (UIConversation)intent.getParcelableExtra("extra_conversation");
            }
            if (this.mConversation != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getTargetId())) {
                this.setCurrentConversationTargetId(this.mConversation.getTargetId());
            }
        }
    }

    private final void parserIntent(Intent intent) {
        this.mConversation = new UIConversation();
        String targetId = intent.getData().getQueryParameter("targetId");
        String targetIds = intent.getData().getQueryParameter("targetIds");
        String delimiter = intent.getData().getQueryParameter("delimiter");
        this.mConversation.setConversationTitle(intent.getData().getQueryParameter("title"));
        RongIMClient.ConversationType conversationType = RongIMClient.ConversationType.valueOf(intent.getData().getLastPathSegment().toUpperCase());
        if (conversationType != null && conversationType == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
            this.mConversation.setConversationTitle(this.getString(Res.getInstance((Context)this.getActivity()).string("notification_custom_service")));
        }
        if (conversationType == null) {
            conversationType = RongIMClient.ConversationType.PRIVATE;
        }
        this.mConversation.setConversationType(conversationType);
        if (!TextUtils.isEmpty((CharSequence)targetId)) {
            this.mConversation.setTargetId(targetId);
            if (conversationType == RongIMClient.ConversationType.CHATROOM) {
                this.enterChatroom(targetId);
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)targetIds) || TextUtils.isEmpty((CharSequence)delimiter) || conversationType != RongIMClient.ConversationType.DISCUSSION) {
                return;
            }
            this.createDiscussion(targetIds.split(delimiter));
        }
        if (this.mConversation != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getTargetId())) {
            this.setCurrentConversationTargetId(this.mConversation.getTargetId());
        }
    }

    private void enterChatroom(final String id2) {
        if (RongIM.getInstance() == null) {
            return;
        }
        this.mDialog = new LoadingDialog((Context)this.getActivity());
        this.mDialog.setText(this.getString(Res.getInstance((Context)this.getActivity()).string("rc_create_chatroom_notice")));
        this.mDialog.show();
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                RongIM.getInstance().joinChatRoom(id2, 0, new RongIM.OperationCallback(){

                    @Override
                    public void onSuccess() {
                        ConversationFragment.this.getHandler().obtainMessage(1105).sendToTarget();
                    }

                    @Override
                    public void onError(RongIM.OperationCallback.ErrorCode errorCode) {
                        ConversationFragment.this.getHandler().obtainMessage(1106).sendToTarget();
                    }
                });
            }
        }, 1000L);
    }

    private void quitChatroom(String id2) {
        if (RongIM.getInstance() == null) {
            return;
        }
        RongIM.getInstance().quitChatRoom(id2, null);
    }

    private void createDiscussion(String[] userIds) {
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_CREATE);
        ArrayList<String> ids = new ArrayList<String>();
        for (String item : userIds) {
            ids.add(item);
        }
        intent.putStringArrayListExtra("multi_talk_id_array", ids);
        intent.putExtra("multi_talk_name", this.mConversation.getConversationTitle());
        this.mDialog = new LoadingDialog((Context)this.getActivity());
        this.mDialog.setText(this.getString(Res.getInstance((Context)this.getActivity()).string("discussion_create_loading_title")));
        this.mDialog.show();
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intentArg) {
                boolean isSuccess = intentArg.getBooleanExtra("intent_api_operation_status", false);
                if (isSuccess) {
                    String targetId = intentArg.getStringExtra("multi_talk_id");
                    String discusstionName = intentArg.getStringExtra("multi_talk_name");
                    if (!TextUtils.isEmpty((CharSequence)targetId)) {
                        ConversationFragment.this.setCurrentConversationTargetId(targetId);
                    }
                    ConversationFragment.this.mConversation.setTargetId(targetId);
                    ConversationFragment.this.getHandler().obtainMessage(1105).sendToTarget();
                } else {
                    ConversationFragment.this.getHandler().obtainMessage(1106).sendToTarget();
                }
            }
        });
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        String displayInput;
        View view = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_fragment_conversation"), null);
        this.mListView = (PullDownRefreshListView)((Object)this.getViewById(view, 16908298));
        this.mConversationMessageBar = (ConversationMessageBar)this.getViewById(view, "conversation_message_bar");
        this.mConnectStateTextView = (TextView)this.getViewById(view, "connect_state");
        this.mConversationMessageBar.setConversationMessageBarListener(this);
        if (this.getActivity() != null && this.getActivity().getIntent() != null && this.getActivity().getIntent().getData() != null && !TextUtils.isEmpty((CharSequence)(displayInput = this.getActivity().getIntent().getData().getQueryParameter("displayInput")))) {
            if ("false".equals(displayInput) || "0".equals(displayInput)) {
                this.mConversationMessageBar.setVisibility(8);
            } else {
                this.mConversationMessageBar.setVisibility(0);
            }
        }
        if (RongIMClient.ConversationType.SYSTEM == this.mConversation.getConversationType()) {
            this.mConversationMessageBar.setVisibility(8);
        }
        this.mFrameLayout = (CoverFrameLayout)((Object)this.getViewById(view, "rong_cover_layout"));
        this.mCoverView = (VoiceCoverView)this.getViewById(view, "rong_voice_cover");
        this.mHideCover = this.getViewById(view, 16908311);
        this.mHideCover.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        if (this.getActionBar() != null) {
            if (RongIMClient.ConversationType.CUSTOMER_SERVICE != this.mConversation.getConversationType() && this.mConversation.getConversationType() != RongIMClient.ConversationType.CHATROOM && this.mConversation.getConversationType() != RongIMClient.ConversationType.SYSTEM) {
                View view1 = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_action_bar_conversation_settings"), (ViewGroup)this.getActionBar(), false);
                this.settingView = (ImageView)this.getViewById(view1, "rc_conversation_settings_image");
                this.settingView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        RongIM.getInstance().startConversationSetting((Context)ConversationFragment.this.getActivity(), ConversationFragment.this.mConversation.getConversationType(), ConversationFragment.this.mConversation.getTargetId());
                    }
                });
                this.getActionBar().addView((View)this.settingView);
            }
            this.getActionBar().setOnBackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationFragment.this.getActivity().finish();
                }
            });
            if (!TextUtils.isEmpty((CharSequence)this.mConversation.getConversationTitle())) {
                this.getActionBar().getTitleTextView().setText((CharSequence)this.mConversation.getConversationTitle());
            }
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.setOnKeyListener(this.mOnKeyListener);
        this.mConversationMessageBar.getMessageBar().getMessageEditText().setOnKeyListener(this.mOnKeyListener);
        this.mConversationMessageBar.getMessageBar().getExpressionImageView().setOnKeyListener(this.mOnKeyListener);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        String draft;
        super.onViewCreated(view, savedInstanceState);
        if (this.mConversation.getTargetId() == null) {
            return;
        }
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null && !TextUtils.isEmpty((CharSequence)(draft = RCloudContext.getInstance().getRongIMClient().getTextMessageDraft(this.mConversation.getConversationType(), this.mConversation.getTargetId())))) {
            this.mConversationMessageBar.setMessageEditText((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(draft))));
        }
        this.initListView();
        this.mListView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && ConversationFragment.this.mConversationMessageBar.isShowRichOrExpressionView()) {
                    ConversationFragment.this.mConversationMessageBar.setRichOrExpressionViewVisibility();
                    return true;
                }
                return false;
            }
        });
    }

    private void resetData() {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ConversationFragment.this.mConversation != null && ConversationFragment.this.mConversationAdapter != null && ConversationFragment.this.mConversation.getConversationType() != RongIMClient.ConversationType.CHATROOM) {
                    ArrayList<UIMessage> messages;
                    DBHelper.getInstance().clearUnReadMessage(ConversationFragment.this.mConversation.getConversationType(), ConversationFragment.this.mConversation.getTargetId());
                    ConversationFragment.this.mUnReadMessageCount = DBHelper.getInstance().getTotalUnreadCount();
                    ArrayList<UIMessage> list = null;
                    if (ConversationFragment.this.mConversation != null) {
                        list = DBHelper.getInstance().getLasetMessageList(ConversationFragment.this.mConversation.getConversationType(), ConversationFragment.this.mConversation.getTargetId(), 10);
                    }
                    if (list == null || list.size() < 10) {
                        ConversationFragment.this.mIsHaveDBMessage = false;
                    }
                    if ((messages = list) != null) {
                        ConversationFragment.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                RongIMClient.DiscussionNotificationMessage discussionNotificationMessage;
                                UIMessage uiMessage;
                                if (ConversationFragment.this.mUnReadMessageCount > 0) {
                                    ConversationFragment.this.showNewMessage(ConversationFragment.this.mUnReadMessageCount);
                                }
                                if (messages != null && messages.size() > 0 && (uiMessage = (UIMessage)messages.get(0)) != null && uiMessage.getContent() instanceof RongIMClient.DiscussionNotificationMessage && (discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)uiMessage.getContent()).getType() == 4 && discussionNotificationMessage.getExtension().indexOf(",") == -1) {
                                    String userId = discussionNotificationMessage.getExtension();
                                    if (ConversationFragment.this.getCurrentUserInfo() != null && userId.equals(ConversationFragment.this.getCurrentUserInfo().getUserId()) && ConversationFragment.this.settingView != null) {
                                        ConversationFragment.this.settingView.setVisibility(8);
                                    }
                                }
                                if (ConversationFragment.this.mConversationAdapter.getCount() > 0) {
                                    ConversationFragment.this.mConversationAdapter.removeAll();
                                    ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                                }
                                ConversationFragment.this.mConversationAdapter.addData(ConversationFragment.this.reverseList(messages));
                                ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                                ConversationFragment.this.mListView.setSelection(ConversationFragment.this.mConversationAdapter.getCount() + ConversationFragment.this.mListView.getHeaderViewsCount());
                            }
                        });
                    }
                }
            }
        });
    }

    private void initListView() {
        this.mConversationAdapter = new MultiItemViewListAdapter(new MessageContext((Context)this.getActivity(), this.mVoiceHandler));
        this.mListView.setAdapter((ListAdapter)this.mConversationAdapter);
        this.mListView.setonRefreshListener(this);
        this.mListView.setOnTouchListener(this);
        this.mFrameLayout.setOnTriggeredTouchListener(this);
        this.mConversationMessageBar.setOnRichIconTextViewClickListener(this);
        this.mConversationAdapter.setOnMessageItemClickListener(this);
        this.mConversationAdapter.setOnGetDataListener(this);
        this.resetData();
        if (TextUtils.isEmpty((CharSequence)this.mConversation.getConversationTitle())) {
            if (this.mConversation.getConversationType() == RongIMClient.ConversationType.PRIVATE || this.mConversation.getConversationType() == RongIMClient.ConversationType.SYSTEM) {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.getUserInfo(ConversationFragment.this.mConversation.getTargetId(), new ActionBaseFragment.GetUserInfoCallback(){

                            @Override
                            public void onSuccess(UIUserInfo user) {
                                ConversationFragment.this.getHandler().obtainMessage(1104, (Object)user).sendToTarget();
                            }

                            @Override
                            public void onExist(Object object) {
                            }

                            @Override
                            public void onError() {
                            }
                        });
                    }
                });
            } else if (RongIMClient.ConversationType.GROUP == this.mConversation.getConversationType()) {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        RongIMClient.Group group;
                        if (Looper.myLooper() == Looper.getMainLooper()) {
                            Log.d((String)ConversationFragment.TAG, (String)"*************Looper.myLooper() ==Looper.getMainLooper()**********");
                        }
                        RongIM.GetGroupInfoProvider provider = null;
                        if (RCloudContext.getInstance() != null) {
                            provider = RCloudContext.getInstance().getGetGroupInfoProvider();
                        }
                        if (provider != null && (group = provider.getGroupInfo(ConversationFragment.this.mConversation.getTargetId())) != null && !TextUtils.isEmpty((CharSequence)group.getName())) {
                            ConversationFragment.this.mConversation.setConversationTitle(group.getName());
                            if (ConversationFragment.this.getActionBar() != null) {
                                ConversationFragment.this.getActionBar().getTitleTextView().setText((CharSequence)ConversationFragment.this.mConversation.getConversationTitle());
                            }
                        }
                    }
                });
            }
        }
        if (this.mConversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
            this.getDiscussionInfo(0, this.mConversation.getTargetId());
        }
        this.mCoverView.setVoiceHandler(this.mVoiceHandler);
        this.mVoiceHandler.setRecListener(new IVoiceHandler.OnRecListener(){

            @Override
            public void onRec() {
                if (ConversationFragment.this.mConversationAdapter != null) {
                    ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                }
            }

            @Override
            public void onCover(boolean limited) {
                if (limited) {
                    if (ConversationFragment.this.mHideCover != null && ConversationFragment.this.mHideCover.getVisibility() == 8) {
                        ConversationFragment.this.mHideCover.setVisibility(0);
                    }
                } else if (ConversationFragment.this.mHideCover != null && ConversationFragment.this.mHideCover.getVisibility() == 0) {
                    ConversationFragment.this.mHideCover.setVisibility(8);
                }
            }

            @Override
            public void onCompleted(Uri uri) {
                if (ConversationFragment.this.mHideCover.getVisibility() == 0) {
                    ConversationFragment.this.mHideCover.setVisibility(8);
                }
                ConversationFragment.this.publishVoice(uri, ConversationFragment.this.mCoverView.getLastVoiceLength());
            }
        });
        this.mVoiceHandler.setPlayListener(new IVoiceHandler.OnPlayListener(){

            @Override
            public void onPlay() {
                ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
            }

            @Override
            public void onCover(boolean limited) {
                if (limited) {
                    if (ConversationFragment.this.mHideCover.getVisibility() == 8) {
                        ConversationFragment.this.mHideCover.setVisibility(0);
                    }
                } else if (ConversationFragment.this.mHideCover.getVisibility() == 0) {
                    ConversationFragment.this.mHideCover.setVisibility(8);
                }
            }

            @Override
            public void onStop() {
                ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                if (ConversationFragment.this.mHideCover.getVisibility() == 0) {
                    ConversationFragment.this.mHideCover.setVisibility(8);
                }
            }
        });
        if (this.mConversation.getConversationType() == RongIMClient.ConversationType.PRIVATE) {
            if (this.mConversationMessageBar.getVOIPRichIconTextView().getVisibility() != 8) {
                try {
                    Class.forName("io.rong.voipkit.message.VoIPCallMessage");
                    this.mConversationMessageBar.getVOIPRichIconTextView().setVisibility(0);
                }
                catch (ClassNotFoundException e) {
                    this.mConversationMessageBar.getVOIPRichIconTextView().setVisibility(8);
                }
            }
        } else {
            this.mConversationMessageBar.getVOIPRichIconTextView().setVisibility(8);
        }
    }

    private final List<UIMessage> reverseList(List<UIMessage> list) {
        ArrayList<UIMessage> messags = new ArrayList<UIMessage>();
        for (int i = list.size() - 1; i >= 0; --i) {
            messags.add(list.get(i));
        }
        if (messags != null && messags.size() > 0) {
            this.mLastSelectMsgId = ((UIMessage)messags.get(0)).getMessageId();
        }
        return messags;
    }

    @Override
    public void toggleInputMethod(boolean isOpen, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (isOpen) {
            inputMethodManager.showSoftInput(view, 1);
            this.isVisibility();
        } else if (inputMethodManager.isActive()) {
            inputMethodManager.hideSoftInputFromWindow(view.getApplicationWindowToken(), 2);
        }
    }

    @Override
    public void sendMessage(String msgContent) {
        UIMessage message = this.messageWrap();
        TextMessage textMessage = new TextMessage(msgContent);
        message.setContent(textMessage);
        this.sendMessage(message);
    }

    private final UIMessage messageWrap() {
        UIMessage message = new UIMessage();
        message.setTargetId(this.mConversation.getTargetId());
        message.setMessageDirection(RongIMClient.MessageDirection.SEND);
        message.setSending(true);
        RongIMClient.UserInfo uerInfo = this.getCurrentUserInfo();
        if (uerInfo != null) {
            message.setSenderUserId(uerInfo.getUserId());
        }
        message.setSentTime(System.currentTimeMillis());
        message.setSentStatus(RongIMClient.SentStatus.SENDING);
        message.setConversationType(this.mConversation.getConversationType());
        return message;
    }

    public void sendMessage(UIMessage message) {
        Intent intent = new Intent();
        intent.setAction(RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND);
        intent.putExtra("message_obj", (Parcelable)message);
        this.mIsSendingMessage = true;
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intent) {
                if (intent != null) {
                    boolean sendState = intent.getBooleanExtra("send_message_state", false);
                    boolean isComplete = intent.getBooleanExtra("intent_is_complete", false);
                    int progress = intent.getIntExtra("intent_message_file_download_progress", -1);
                    int msgId = intent.getIntExtra("message_id_send_message_return", -1);
                    Log.d((String)"SEND_MESSAGE", (String)("SEND_STATUS:" + sendState + " COMPLETE:" + isComplete + " PROGRESS:" + progress + " ID:" + msgId));
                    if (isComplete) {
                        int position = ConversationFragment.this.getMessagePosition(msgId);
                        if (position == -1) {
                            return;
                        }
                        UIMessage message = (UIMessage)ConversationFragment.this.mConversationAdapter.getItem(position);
                        if (sendState) {
                            UIMessage result = (UIMessage)intent.getParcelableExtra("message_OBJ_send_message_return");
                            message.setSentTime(System.currentTimeMillis());
                            message.setSending(false);
                            message.setSentStatus(RongIMClient.SentStatus.SENT);
                            message.setContent(result.getContent());
                            ConversationFragment.this.getHandler().obtainMessage(101).sendToTarget();
                            ConversationFragment.this.mIsSendingMessage = false;
                        } else {
                            int errorCode = intent.getIntExtra("send_message_return_error", -1);
                            if (RongIMClient.SendMessageCallback.ErrorCode.REJECTED_BY_BLACKLIST.getValue() == errorCode || 406 == errorCode && message.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
                                ConversationFragment.this.getHandler().obtainMessage(10900, (Object)errorCode).sendToTarget();
                                message.setSentStatus(RongIMClient.SentStatus.SENT);
                            } else {
                                message.setSentStatus(RongIMClient.SentStatus.FAILED);
                            }
                            message.setSending(false);
                            ConversationFragment.this.getHandler().obtainMessage(101).sendToTarget();
                            ConversationFragment.this.mIsSendingMessage = false;
                        }
                    } else {
                        UIMessage message = null;
                        message = (UIMessage)intent.getParcelableExtra("message_OBJ_send_message_return");
                        if (progress < 100) {
                            message.setSending(true);
                        } else {
                            message.setSending(false);
                        }
                        if (message != null && progress < 0) {
                            message.setSentStatus(RongIMClient.SentStatus.SENDING);
                            ConversationFragment.this.mConversationAdapter.addData(message);
                            ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                            ConversationFragment.this.mListView.setSelection(ConversationFragment.this.mConversationAdapter.getCount() + ConversationFragment.this.mListView.getHeaderViewsCount());
                            Log.d((String)"conversationActivity--sendmessage", (String)("messageId:" + message.getMessageId() + " position:" + (ConversationFragment.this.mConversationAdapter.getCount() - 1)));
                        } else {
                            int position = ConversationFragment.this.getMessagePosition(msgId);
                            if (position >= 0) {
                                message = (UIMessage)ConversationFragment.this.mConversationAdapter.getItem(position);
                            }
                            if (progress > 0 && message != null && message.getContent() instanceof ImageMessage) {
                                message.setProgressText(progress);
                                ConversationFragment.this.getHandler().obtainMessage(101).sendToTarget();
                            }
                            if (progress > 0 && message != null && message.getContent() instanceof LocationMessage) {
                                message.setProgressText(progress);
                                ConversationFragment.this.getHandler().obtainMessage(101).sendToTarget();
                            }
                        }
                    }
                }
            }
        });
    }

    private final int getMessagePosition(int id2) {
        int position = -1;
        int i = this.mConversationAdapter.getCount();
        while (i > 0) {
            if (i <= 0 || ((UIMessage)this.mConversationAdapter.getItem(--i)).getMessageId() != id2) continue;
            position = i;
            break;
        }
        return position;
    }

    @Override
    public void onRefresh() {
        if (this.mConversationAdapter != null && this.mConversationAdapter.getCount() < 10 || !this.mIsHaveDBMessage) {
            this.mListView.onRefreshComplete();
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<UIMessage> list = DBHelper.getInstance().getMessageList(ConversationFragment.this.mConversation.getConversationType(), ConversationFragment.this.mConversation.getTargetId(), ConversationFragment.this.mLastSelectMsgId, 10);
                if (list == null || list.size() == 0) {
                    ConversationFragment.this.mIsHaveDBMessage = false;
                    return;
                }
                final ArrayList<UIMessage> messages = list;
                ConversationFragment.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (messages != null) {
                            ConversationFragment.this.mConversationAdapter.addData(0, ConversationFragment.this.reverseList(messages));
                            ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                        }
                        ConversationFragment.this.mListView.onRefreshComplete();
                        if (messages != null && messages.size() > 0) {
                            ConversationFragment.this.mListView.setSelection(messages.size());
                        }
                    }
                }, 2000L);
            }
        });
    }

    @Override
    public void receiveData(Intent intent) {
        super.receiveData(intent);
        String action = intent.getAction();
        if (RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE.equals(action) || RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE.equals(action) || RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE.equals(action) || RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE.equals(action) || RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE.equals(action) || RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE.equals(action)) {
            int leftMessageCount = intent.getIntExtra("left_message_count", 0);
            int messageCount = intent.getIntExtra("message_count", 0);
            if (messageCount > 10 && leftMessageCount == 0) {
                this.getHandler().obtainMessage(1107).sendToTarget();
                return;
            }
            UIMessage message = (UIMessage)intent.getParcelableExtra("message_obj");
            if (message != null && message.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                this.getHandler().obtainMessage(1108, (Object)message).sendToTarget();
            }
            if (this.mConversationAdapter != null && this.mConversation != null && this.mConversation.getTargetId().equals(message.getTargetId())) {
                this.getHandler().obtainMessage(102, (Object)message).sendToTarget();
            } else if (message != null && !(message.getContent() instanceof RongIMClient.DiscussionNotificationMessage)) {
                ++this.mUnReadMessageCount;
                this.getHandler().obtainMessage(1109, (Object)this.mUnReadMessageCount).sendToTarget();
            }
        }
    }

    @Override
    public void receivePageIntent(Intent intent) {
        String action = intent.getAction();
        if (action.equals(RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION) && this.mConversationAdapter != null) {
            this.mConversationAdapter.removeAll();
            this.mConversationAdapter.notifyDataSetChanged();
            return;
        }
        if (RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION.equals(action)) {
            this.resetData();
            return;
        }
        if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING.equals(action) && intent != null) {
            boolean isQuitDiscussion = false;
            boolean isClearMessages = false;
            String createDiscussion = null;
            if (intent != null) {
                if (intent.hasExtra("intent_quit_discussion_close_page")) {
                    isQuitDiscussion = intent.getBooleanExtra("intent_quit_discussion_close_page", false);
                }
                if (intent.hasExtra("intent_clear_message_success")) {
                    isClearMessages = intent.getBooleanExtra("intent_clear_message_success", false);
                }
                if (intent.hasExtra("intent_create_discussion_success")) {
                    createDiscussion = intent.getStringExtra("intent_create_discussion_success");
                }
            }
            if (!TextUtils.isEmpty(createDiscussion)) {
                this.getActivity().finish();
            }
            if (isQuitDiscussion) {
                this.getActivity().finish();
            }
            if (isClearMessages) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.mConversationAdapter.removeAll();
                        ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                    }
                });
            }
        }
        super.receivePageIntent(intent);
    }

    private final void setNetStatus(final int status) {
        if (this.getActivity() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                switch (status) {
                    case -9: {
                        ConversationFragment.this.mConnectStateTextView.setText(Res.getInstance((Context)ConversationFragment.this.getActivity()).string("conntect_state_prompt_disconnect"));
                        ConversationFragment.this.mConnectStateTextView.setVisibility(0);
                        break;
                    }
                    case 0: {
                        ConversationFragment.this.mConnectStateTextView.setVisibility(8);
                        break;
                    }
                    case 6: {
                        ConversationFragment.this.mConnectStateTextView.setText(Res.getInstance((Context)ConversationFragment.this.getActivity()).string("conntect_state_prompt_other_device_login"));
                        ConversationFragment.this.mConnectStateTextView.setVisibility(0);
                        break;
                    }
                    case -1: {
                        ConversationFragment.this.mConnectStateTextView.setText(Res.getInstance((Context)ConversationFragment.this.getActivity()).string("conntect_state_prompt_unknow_error"));
                        ConversationFragment.this.mConnectStateTextView.setVisibility(0);
                        break;
                    }
                    case 1: {
                        ConversationFragment.this.mConnectStateTextView.setText(Res.getInstance((Context)ConversationFragment.this.getActivity()).string("conntect_state_prompt_network_unavailable"));
                        ConversationFragment.this.mConnectStateTextView.setVisibility(0);
                    }
                }
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.mHandler.post(runnable);
        }
    }

    private final void showNewMessage(int messageCount) {
        if (this.getActionBar() != null && messageCount > 0) {
            if (this.getActionBar().getNewMessageView() != null) {
                String moreMsgFlag = null;
                moreMsgFlag = messageCount > 99 ? this.getString(Res.getInstance((Context)this.getActivity()).string("new_message_more")) : String.valueOf(messageCount);
                this.getActionBar().getNewMessageView().setText((CharSequence)moreMsgFlag);
                this.getActionBar().getNewMessageView().setVisibility(0);
            }
        } else if (this.getActionBar() != null && this.getActionBar().getNewMessageView() != null) {
            this.getActionBar().getNewMessageView().setVisibility(8);
        }
    }

    @Override
    public void registerActions(List<String> actions) {
        actions.add(RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE);
        super.registerActions(actions);
    }

    @Override
    public void registerBundleActions(List<String> actions) {
        actions.add(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING);
        actions.add(RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION);
        actions.add(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION);
        super.registerBundleActions(actions);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (v.getId()) {
            case 16908298: {
                this.toggleInputMethod(false, v);
                if (!this.mConversationMessageBar.isShowRichOrExpressionView()) break;
                this.mConversationMessageBar.setHiddenRichAndExpressionView();
                break;
            }
        }
        return false;
    }

    @Override
    protected void rongHandleMessage(Message msg) {
        if (msg != null) {
            switch (msg.what) {
                case 102: {
                    UIMessage uiMessage = (UIMessage)msg.obj;
                    RongIMClient.Message oldMessage = null;
                    if (this.mConversationAdapter.getCount() >= 1) {
                        oldMessage = (UIMessage)this.mConversationAdapter.getItem(this.mConversationAdapter.getCount() - 1);
                    }
                    if (oldMessage != null && oldMessage.getMessageId() >= uiMessage.getMessageId()) {
                        return;
                    }
                    this.mConversationAdapter.addData(uiMessage);
                    this.mConversationAdapter.notifyDataSetChanged();
                    if (this.mConversationAdapter.getCount() <= 1 || this.mListView.getLastVisiblePosition() != this.mConversationAdapter.getCount() - 1) break;
                    this.mListView.setSelection(this.mConversationAdapter.getCount() + this.mListView.getHeaderViewsCount());
                    break;
                }
                case 101: {
                    this.mConversationAdapter.notifyDataSetChanged();
                    break;
                }
                case 1101: {
                    this.initListView();
                    if (this.mDialog == null) break;
                    this.mDialog.dismiss();
                    break;
                }
                case 990001: {
                    if (msg.obj instanceof UIUserInfo) {
                        UIUserInfo uiUserInfo = (UIUserInfo)msg.obj;
                        int count = this.mConversationAdapter.getCount();
                        for (int i = 0; i < count; ++i) {
                            UIMessage uiMessage1 = (UIMessage)this.mConversationAdapter.getItem(i);
                            if (uiMessage1 == null) continue;
                            if (!TextUtils.isEmpty((CharSequence)uiMessage1.getSenderUserId()) && uiUserInfo.getUserId().equals(uiMessage1.getSenderUserId())) {
                                uiMessage1.setUserInfo(uiUserInfo);
                            }
                            if (!(uiMessage1.getContent() instanceof RongIMClient.DiscussionNotificationMessage)) continue;
                            RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)uiMessage1.getContent();
                            if (discussionNotificationMessage.getOperator().equals(uiUserInfo.getUserId())) {
                                uiMessage1.setOperator(uiUserInfo);
                                continue;
                            }
                            if (discussionNotificationMessage.getExtension().indexOf(",") != -1 || !discussionNotificationMessage.getExtension().equals(uiUserInfo.getUserId())) continue;
                            uiMessage1.setOperatored(uiUserInfo);
                        }
                    }
                    this.mConversationAdapter.notifyDataSetChanged();
                    break;
                }
                case 1103: {
                    UIDiscussion discussion = (UIDiscussion)msg.obj;
                    if (discussion != null && !TextUtils.isEmpty((CharSequence)discussion.getName())) {
                        String userId;
                        this.mConversation.setConversationTitle(discussion.getName());
                        this.mConversation.setUiDiscussion(discussion);
                        String string2 = userId = this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "";
                        if (!discussion.getUserIds().contains(userId) && this.getActionBar() != null && this.settingView != null) {
                            this.settingView.setVisibility(8);
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)this.mConversation.getConversationTitle()) || this.getActionBar() == null || this.getActionBar() == null) break;
                    this.getActionBar().getTitleTextView().setText((CharSequence)this.mConversation.getConversationTitle());
                    break;
                }
                case 1104: {
                    UIUserInfo userInfo = (UIUserInfo)msg.obj;
                    if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.getName())) {
                        this.mConversation.setConversationTitle(userInfo.getName());
                        this.mConversation.setUserInfo(userInfo);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.mConversation.getConversationTitle()) || this.getActionBar() == null || this.getActionBar() == null) break;
                    this.getActionBar().getTitleTextView().setText((CharSequence)this.mConversation.getConversationTitle());
                    break;
                }
                case 1107: {
                    this.resetData();
                    break;
                }
                case 1106: {
                    if (this.mDialog != null && this.mDialog.isShowing()) {
                        this.mDialog.dismiss();
                    }
                    if (this.mConversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
                        RongToast.makeText((Context)this.getActivity(), this.getString(Res.getInstance((Context)this.getActivity()).string("discussion_create_failure"))).show();
                        break;
                    }
                    if (this.mConversation.getConversationType() != RongIMClient.ConversationType.CHATROOM) break;
                    RongToast.makeText((Context)this.getActivity(), this.getString(Res.getInstance((Context)this.getActivity()).string("rc_create_chatroom_fail"))).show();
                    break;
                }
                case 1105: {
                    if (this.mDialog != null && this.mDialog.isShowing()) {
                        this.mDialog.dismiss();
                    }
                    this.initListView();
                    break;
                }
                case 1108: {
                    UIMessage message = (UIMessage)msg.obj;
                    RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)message.getContent();
                    if (discussionNotificationMessage.getType() == 3 && this.mConversation != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getTargetId()) && message.getTargetId().equals(this.mConversation.getTargetId())) {
                        if (this.getActionBar() == null) break;
                        this.getActionBar().getTitleTextView().setText((CharSequence)discussionNotificationMessage.getExtension());
                        break;
                    }
                    if (discussionNotificationMessage.getType() == 4 && discussionNotificationMessage.getExtension().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "")) {
                        if (this.settingView == null) break;
                        this.settingView.setVisibility(8);
                        break;
                    }
                    if (discussionNotificationMessage.getType() != 1 || !discussionNotificationMessage.getExtension().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "") || this.settingView == null) break;
                    this.settingView.setVisibility(0);
                    break;
                }
                case 1109: {
                    this.showNewMessage(this.mUnReadMessageCount);
                    break;
                }
                case 10900: {
                    int errorCode = (Integer)msg.obj;
                    if (RongIMClient.SendMessageCallback.ErrorCode.REJECTED_BY_BLACKLIST.getValue() == errorCode) {
                        InformationNotificationMessage informationNotificationMessage = InformationNotificationMessage.obtain(this.getActivity().getResources().getString(Res.getInstance((Context)this.getActivity()).string("rc_rejected_by_blacklist_prompt")));
                        RCloudContext.getInstance().getRongIMClient().insertMessage(RongIMClient.ConversationType.PRIVATE, this.mConversation.getTargetId(), this.mConversation.getTargetId(), informationNotificationMessage);
                        break;
                    }
                    if (406 != errorCode) break;
                    String selfUserId = this.getCurrentUserInfo() == null ? "" : this.getCurrentUserInfo().getUserId();
                    RongIMClient.DiscussionNotificationMessage discussionNotificationMessage1 = RongIMClient.DiscussionNotificationMessage.obtain(4, selfUserId, "-1");
                    RCloudContext.getInstance().getRongIMClient().insertMessage(RongIMClient.ConversationType.DISCUSSION, this.mConversation.getTargetId(), this.mConversation.getTargetId(), discussionNotificationMessage1);
                    break;
                }
            }
        }
    }

    @Override
    public void onImageRichTextClick() {
        this.gotoSysPic();
    }

    @Override
    public void onCameraRichTextClick() {
        this.gotoSysCamera();
    }

    @Override
    public void onVoipRichTextClick() {
        if (!Build.CPU_ABI.contains("arm")) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"\u53ea\u652f\u6301arm\u67b6\u6784\u7684\u624b\u673a\uff01", (int)1).show();
            return;
        }
        this.getUserInfo(true, this.mConversation.getTargetId(), new ActionBaseFragment.GetUserInfoCallback(){

            @Override
            public void onSuccess(UIUserInfo user) {
                Message msg = ConversationFragment.this.mVoipHandler.obtainMessage();
                msg.obj = user;
                ConversationFragment.this.mVoipHandler.sendMessage(msg);
            }

            @Override
            public void onExist(Object object) {
            }

            @Override
            public void onError() {
            }
        });
    }

    @Override
    public void onAddRichTextClick() {
    }

    @Override
    public void isVisibility() {
        if (this.mListView != null && this.mConversationAdapter != null) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    ConversationFragment.this.mListView.setSelection(ConversationFragment.this.mConversationAdapter.getCount() + ConversationFragment.this.mListView.getHeaderViewsCount());
                }
            });
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConversationFragment.this.mListView.setSelection(ConversationFragment.this.mConversationAdapter.getCount() + ConversationFragment.this.mListView.getHeaderViewsCount());
                }
            }, 500L);
        }
    }

    @Override
    public void publishBitmap(final Uri uri) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (uri == null || TextUtils.isEmpty((CharSequence)uri.toString())) {
                    RongToast.makeText((Context)ConversationFragment.this.getActivity(), "\u9009\u62e9\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01").show();
                }
            }
        });
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                ImageMessage imageMessage = ImageMessage.obtain(uri, uri);
                UIMessage uiMessage = ConversationFragment.this.messageWrap();
                uiMessage.setContent(imageMessage);
                Log.d((String)"MESSAGE_SEND", (String)"SEND UI MESSAGE");
                ConversationFragment.this.sendMessage(uiMessage);
            }
        });
    }

    @Override
    public void onMessageClick(UIMessage message, View view) {
        if (message != null) {
            if (message.getContent() instanceof ImageMessage) {
                ImageMessage imageMessage = null;
                Uri uri = null;
                imageMessage = (ImageMessage)message.getContent();
                if (imageMessage != null && (uri = imageMessage.getLocalUri() != null ? imageMessage.getLocalUri() : imageMessage.getRemoteUri()) != null) {
                    Intent intent = new Intent((Context)this.getActivity(), RongActivity.class);
                    intent.putExtra("extra_fragment_content", ShowDownloadImageFragment.class.getCanonicalName());
                    intent.putExtra("target_id", this.mConversation.getTargetId());
                    intent.putExtra("message_image_key", (Parcelable)uri);
                    this.startActivity(intent);
                }
            } else if (message.getContent() instanceof VoiceMessage) {
                VoiceMessage voiceMessage = (VoiceMessage)message.getContent();
                ImageView imageView = null;
                if (view != null && view instanceof ImageView) {
                    imageView = (ImageView)view;
                }
                if (voiceMessage != null) {
                    AnimationDrawable drawable2;
                    if (RongIMClient.MessageDirection.SEND == message.getMessageDirection()) {
                        drawable2 = (AnimationDrawable)this.getResources().getDrawable(Res.getInstance((Context)this.getActivity()).drawable("rc_send_voice_anim"));
                        imageView.setImageDrawable((Drawable)drawable2);
                    } else {
                        drawable2 = (AnimationDrawable)this.getResources().getDrawable(Res.getInstance((Context)this.getActivity()).drawable("rc_receive_voice_anim"));
                        imageView.setImageDrawable((Drawable)drawable2);
                    }
                    if (message.getReceivedStatus() != null && !message.getReceivedStatus().isListened()) {
                        message.getReceivedStatus().setListened();
                    }
                    final ImageView temImageView = imageView;
                    temImageView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (temImageView.getDrawable() instanceof AnimationDrawable) {
                                ((AnimationDrawable)temImageView.getDrawable()).start();
                            }
                        }
                    });
                    try {
                        if (voiceMessage.getUri().equals((Object)this.mVoiceHandler.getCurrentPlayUri())) {
                            this.mVoiceHandler.stop();
                        } else {
                            this.mVoiceHandler.stop();
                            this.mVoiceHandler.play(voiceMessage.getUri());
                        }
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void onMessageLongClick(UIMessage message) {
        UIUserInfo userInfo;
        final SelectDialog mSelectDialog = new SelectDialog((Context)this.getActivity());
        final UIMessage fmessage = message;
        String username = null;
        if (fmessage.getUserInfo() != null) {
            username = fmessage.getUserInfo().getName();
        }
        if (TextUtils.isEmpty(username) && (userInfo = this.mConversationAdapter.getUserInfo(fmessage.getSenderUserId())) != null) {
            username = userInfo.getName();
        }
        mSelectDialog.setTitle(username);
        if (fmessage.getContent() instanceof TextMessage) {
            mSelectDialog.setFristLineContent("dialog_converastion_cope_message");
            mSelectDialog.setSecondLineContent("dialog_converastion_delete_message");
        } else {
            mSelectDialog.setDiaogLayoutFirstGone();
            mSelectDialog.setSecondLineContent("dialog_converastion_delete_message");
        }
        mSelectDialog.setOnDialogItemViewListener(new SelectDialog.OnDialogItemViewListener(){

            @Override
            public void OnDialogItemViewClick(View view, int position) {
                Log.d((String)"onItemLongClick---", (String)("position:   " + position));
                if (position == 0) {
                    ClipboardManager clipboard = (ClipboardManager)ConversationFragment.this.getActivity().getSystemService("clipboard");
                    clipboard.setText((CharSequence)fmessage.getTextMessageContent());
                } else if (position == 1) {
                    int id2 = fmessage.getMessageId();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    ids.add(id2);
                    DBHelper.getInstance().deleteMessage(ids);
                    ConversationFragment.this.mConversationAdapter.remove(fmessage.getPositionInList());
                    ConversationFragment.this.mConversationAdapter.notifyDataSetChanged();
                }
                mSelectDialog.dismiss();
            }
        });
        mSelectDialog.show();
    }

    @Override
    public void onMessageDoubleClick(UIMessage message) {
    }

    public void publishVoice(Uri uri, long voiceLength) {
        if (voiceLength <= 1000L) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(Res.getInstance((Context)this.getActivity()).string("voice_dialog_time_short")), (int)0).show();
            return;
        }
        byte[] voiceData = Util.getByteFromUri((Context)this.getActivity(), uri);
        if (voiceData == null || voiceData.length == 0) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(Res.getInstance((Context)this.getActivity()).string("rc_voice_unauthorized")), (int)0).show();
            Log.d((String)TAG, (String)"publishVoice-- voiceData is  null");
            return;
        }
        UIMessage message = this.messageWrap();
        VoiceMessage voiceMessage = VoiceMessage.obtain(Uri.parse((String)uri.getPath()), (int)(voiceLength / 1000L));
        message.setContent(voiceMessage);
        this.sendMessage(message);
    }

    @Override
    public void onPause() {
        this.mVoiceHandler.stopRec(false);
        this.mVoiceHandler.stop();
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setConnectionStatusListener(null);
        }
        this.setConversationResult();
        super.onPause();
    }

    @Override
    public void onResendMessage(UIMessage message, int position) {
        if (this.mIsSendingMessage || this.mConnectStateTextView.getVisibility() == 0) {
            return;
        }
        if (message != null) {
            ArrayList<Integer> messageIds = new ArrayList<Integer>();
            messageIds.add(message.getMessageId());
            DBHelper.getInstance().deleteMessage(messageIds);
            this.mConversationAdapter.remove(position);
            message.setSentStatus(RongIMClient.SentStatus.SENDING);
            message.setSending(true);
            this.sendMessage(message);
        }
    }

    @Override
    public void OnTriggeredTouchEvent(MotionEvent event, CoverFrameLayout coverFrameLayout) {
        int length;
        ConversationMessageBar temp1 = this.mConversationMessageBar;
        int offsetBarY = 0;
        while (temp1.getParent() != this.mFrameLayout && temp1.getParent() instanceof View) {
            temp1 = (View)temp1.getParent();
            offsetBarY += temp1.getTop();
        }
        VoiceCoverView temp2 = this.mCoverView;
        int offsetCoverY = 0;
        while (temp2.getParent() != this.mFrameLayout && temp2.getParent() instanceof View) {
            temp2 = (View)temp2.getParent();
            offsetCoverY += temp2.getTop();
        }
        int offset = Math.round(event.getY()) - (this.mConversationMessageBar.getTop() + offsetBarY);
        if (offset > (length = this.mCoverView.getBottom() + offsetCoverY - (this.mConversationMessageBar.getTop() + offsetBarY)) / 2) {
            this.mCoverView.setStatus(131072);
        } else {
            this.mCoverView.setStatus(131073);
        }
    }

    private final void setConversationResult() {
        if (this.mConversation.getTargetId() == null) {
            return;
        }
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION);
        DBHelper.getInstance().clearUnReadMessage(this.mConversation.getConversationType(), this.mConversation.getTargetId());
        intent.putExtra("extra_conversation", (Parcelable)this.mConversation);
        String draft = this.mConversationMessageBar.getMessageEditString();
        if (draft != null && RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getRongIMClient().saveTextMessageDraft(this.mConversation.getConversationType(), this.mConversation.getTargetId(), draft.trim());
        }
        this.getActivity().sendBroadcast(intent);
    }

    @Override
    public boolean onBackPressed() {
        Log.d((String)TAG, (String)"----------onBackPressed----------");
        if (this.mConversationMessageBar.isShowRichOrExpressionView()) {
            this.mConversationMessageBar.setRichOrExpressionViewVisibility();
            return true;
        }
        if (RCloudContext.getInstance() == null || DBHelper.getInstance() == null || RCloudContext.getInstance().getRongIMClient() == null) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("re_start_app"));
            this.getActivity().finish();
            return false;
        }
        this.setConversationResult();
        this.getActivity().finish();
        return false;
    }

    @Override
    public void getDiscussionInfo(int position, final String discusstionId) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    Log.d((String)ConversationFragment.TAG, (String)"*************Looper.myLooper() ==Looper.getMainLooper()*******getDiscussionInfo***");
                }
                Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET);
                intent.putExtra("multi_talk_id", discusstionId);
                ConversationFragment.this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

                    @Override
                    public void callback(Intent intent) {
                        boolean isSuccess = intent.getBooleanExtra("intent_api_operation_status", false);
                        if (isSuccess) {
                            UIDiscussion discussion = (UIDiscussion)intent.getParcelableExtra("discussion_object");
                            ConversationFragment.this.getHandler().obtainMessage(1103, (Object)discussion).sendToTarget();
                        }
                    }
                });
            }
        });
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public void onDestroy() {
        this.setCurrentConversationTargetId(null);
        if (this.mConversation != null && this.mConversation.getConversationType() == RongIMClient.ConversationType.CHATROOM) {
            this.quitChatroom(this.mConversation.getTargetId());
        }
        EventBus.getDefault().unregister(this);
        super.onDestroy();
    }

    @Override
    public void onLocationRichTextClick() {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getLocationProvider().onStartLocation((Context)this.getActivity(), new LocationCallback());
        }
    }

    public void onEventMainThread(RongIMClient.UserInfo userInfo) {
        if (this.mConversationAdapter != null) {
            this.mConversationAdapter.notifyDataSetChanged();
        }
    }

    class LocationCallback
    implements RongIM.LocationProvider.LocationCallback {
        LocationCallback() {
        }

        @Override
        public void onSuccess(LocationMessage message) {
            UIMessage uiMessage = ConversationFragment.this.messageWrap();
            uiMessage.setContent(message);
            ConversationFragment.this.sendMessage(uiMessage);
        }

        @Override
        public void onFailure(String msg) {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                RongToast.toast((Context)ConversationFragment.this.getActivity(), msg);
            }
            if (ConversationFragment.this.mDialog != null && ConversationFragment.this.mDialog.isShowing()) {
                ConversationFragment.this.mDialog.dismiss();
            }
        }
    }
}

