/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.fragment.BaseFragment;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.Util;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ActionBaseFragment
extends BaseFragment {
    private BroadcastReceiver mBroadcastReceiver;
    private IntentFilter mIntentFilter;
    private Map<String, List<ActionCallback>> mActionCallbackMap;
    private boolean isRegister = false;
    private ArrayList<String> customActions = new ArrayList();
    private ArrayList<String> bundleActions = new ArrayList();
    private ConcurrentHashMap<String, Object> mCacheTargetIds = new ConcurrentHashMap();
    protected static final int HANDLE_GET_USER_INFO_WHAT = 990001;
    protected static final int HANDLE_GET_GROUP_INFO_WHAT = 990003;
    protected Handler mHandler;
    private Integer integer = new Integer(1);
    protected Handler mWorkHandler;
    private Looper mLooper;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getActivity() != null) {
            Util.initBroadcastPackage(this.getActivity().getPackageName());
        }
        this.mIntentFilter = new IntentFilter();
        this.mBroadcastReceiver = new BaseReceiver();
        this.mActionCallbackMap = new HashMap<String, List<ActionCallback>>();
        this.registerActions(this.customActions);
        this.registerBundleActions(this.bundleActions);
        this.mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                ActionBaseFragment.this.rongHandleMessage(msg);
                return false;
            }
        });
        this.mCacheTargetIds.clear();
        HandlerThread handlerThread = new HandlerThread("ActionBaseFragment" + System.currentTimeMillis());
        handlerThread.start();
        this.mLooper = handlerThread.getLooper();
        this.mWorkHandler = new Handler(this.mLooper);
    }

    protected void rongHandleMessage(Message msg) {
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void onPause() {
        super.onPause();
        this.mCacheTargetIds.clear();
    }

    public void sendAction(Intent intent, ActionCallback actionCallback) {
        String action = intent.getAction();
        if (!this.mIntentFilter.hasAction(action)) {
            this.mIntentFilter.addAction(action);
            this.getActivity().registerReceiver(this.mBroadcastReceiver, this.mIntentFilter);
            this.isRegister = true;
        }
        if (!this.mActionCallbackMap.containsKey(action)) {
            this.mActionCallbackMap.put(action, Collections.synchronizedList(new ArrayList()));
        }
        this.mActionCallbackMap.get(action).add(actionCallback);
        intent.putExtra("io.rong.imkit.service.RongIMService.EXTRA_ACTION_HASHCODE", actionCallback.hashCode());
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().sendAction(intent);
        }
    }

    public void receiveData(Intent intent) {
    }

    public void receivePageIntent(Intent intent) {
    }

    public void onDestroy() {
        if (this.isRegister && this.getActivity() != null && this.mBroadcastReceiver != null) {
            this.getActivity().unregisterReceiver(this.mBroadcastReceiver);
        }
        if (this.mLooper != null) {
            this.mLooper.quit();
        }
        super.onDestroy();
    }

    public void registerActions(List<String> actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (String action : actions) {
            if (this.mIntentFilter == null || this.mIntentFilter.hasAction(action) || this.mBroadcastReceiver == null || this.getActivity() == null) continue;
            this.mIntentFilter.addAction(action);
            this.getActivity().registerReceiver(this.mBroadcastReceiver, this.mIntentFilter);
            this.isRegister = true;
        }
    }

    public void registerBundleActions(List<String> actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (String action : actions) {
            if (this.mIntentFilter.hasAction(action)) continue;
            this.mIntentFilter.addAction(action);
            this.getActivity().registerReceiver(this.mBroadcastReceiver, this.mIntentFilter);
            this.isRegister = true;
        }
    }

    public void setCurrentConversationTargetId(String mCurrentTargetId) {
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setCurrentTargetId(mCurrentTargetId);
        }
    }

    protected void getUserInfo(String userId, GetUserInfoCallback getUserInfoCallback) {
        this.getUserInfo(false, userId, getUserInfoCallback);
    }

    protected void getUserInfo(boolean isDirect, final String userId, final GetUserInfoCallback getUserInfoCallback) {
        if (getUserInfoCallback == null || userId == null || TextUtils.isEmpty((CharSequence)userId.trim())) {
            return;
        }
        if (!isDirect && this.mCacheTargetIds.containsKey(userId)) {
            getUserInfoCallback.onExist(this.mCacheTargetIds.get(userId));
            return;
        }
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getGetUserInfoProvider() != null) {
            RongIMClient.UserInfo userInfo = RCloudContext.getInstance().getGetUserInfoProvider().getUserInfo(userId);
            if (userInfo != null) {
                UIUserInfo uiUserInfo = new UIUserInfo(userInfo);
                getUserInfoCallback.onSuccess(uiUserInfo);
                this.mCacheTargetIds.put(userId, uiUserInfo);
            } else {
                RongIMClient.UserInfo currentUserInfo = null;
                if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                    currentUserInfo = RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo();
                }
                if (currentUserInfo != null && userId.equals(currentUserInfo.getUserId())) {
                    UIUserInfo uiUserInfo = new UIUserInfo(currentUserInfo);
                    this.mCacheTargetIds.put(userId, uiUserInfo);
                    getUserInfoCallback.onSuccess(uiUserInfo);
                    return;
                }
                if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                    RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                        @Override
                        public void onSuccess(RongIMClient.UserInfo user) {
                            UIUserInfo uiUserInfo;
                            if (user != null && !TextUtils.isEmpty((CharSequence)(uiUserInfo = new UIUserInfo(user)).getName())) {
                                ActionBaseFragment.this.mCacheTargetIds.put(userId, uiUserInfo);
                                getUserInfoCallback.onSuccess(uiUserInfo);
                            }
                        }

                        @Override
                        public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                            ActionBaseFragment.this.mCacheTargetIds.remove(userId);
                            getUserInfoCallback.onError();
                        }
                    });
                }
            }
        } else {
            RongIMClient.UserInfo userInfo = null;
            if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                userInfo = RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo();
            }
            if (userInfo != null && userId.equals(userInfo.getUserId())) {
                UIUserInfo uiUserInfo = new UIUserInfo(userInfo);
                this.mCacheTargetIds.put(userId, uiUserInfo);
                getUserInfoCallback.onSuccess(uiUserInfo);
                return;
            }
            if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                    @Override
                    public void onSuccess(RongIMClient.UserInfo user) {
                        UIUserInfo uiUserInfo = new UIUserInfo(user);
                        if (!TextUtils.isEmpty((CharSequence)uiUserInfo.getName())) {
                            ActionBaseFragment.this.mCacheTargetIds.put(userId, uiUserInfo);
                        }
                        getUserInfoCallback.onSuccess(uiUserInfo);
                    }

                    @Override
                    public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                        if (errorCode != null) {
                            Log.d((String)"ActionBaseFragment", (String)("----getUserInfo-----ErrorCode:" + errorCode.getValue() + "userId:" + userId));
                        }
                        getUserInfoCallback.onError();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDiscussionInfo(String discussionId, final GetDiscussionInfoCallback discussionInfoCallback) {
        if (discussionInfoCallback == null || discussionId == null || TextUtils.isEmpty((CharSequence)discussionId.trim())) {
            return;
        }
        final String key = discussionId;
        Integer n = this.integer;
        synchronized (n) {
            if (this.mCacheTargetIds.containsKey(key)) {
                return;
            }
            this.mCacheTargetIds.put(key, discussionId);
        }
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET);
        intent.putExtra("multi_talk_id", discussionId);
        this.sendAction(intent, new ActionCallback(){

            @Override
            public void callback(Intent intent) {
                boolean isSuccess = intent.getBooleanExtra("intent_api_operation_status", false);
                if (isSuccess) {
                    UIDiscussion discussion = (UIDiscussion)intent.getParcelableExtra("discussion_object");
                    if (discussionInfoCallback != null) {
                        discussionInfoCallback.onSuccess(discussion);
                    }
                } else if (discussionInfoCallback != null) {
                    ActionBaseFragment.this.mCacheTargetIds.remove(key);
                    discussionInfoCallback.onError();
                }
            }
        });
    }

    protected void clearListCache() {
        this.mCacheTargetIds.clear();
    }

    protected RongIMClient.UserInfo getCurrentUserInfo() {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null && RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo() != null) {
            return RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo();
        }
        return null;
    }

    public static interface GetDiscussionInfoCallback {
        public void onSuccess(UIDiscussion var1);

        public void onError();
    }

    public static interface GetUserInfoCallback {
        public void onSuccess(UIUserInfo var1);

        public void onExist(Object var1);

        public void onError();
    }

    public static interface ActionCallback {
        public void callback(Intent var1);
    }

    private class BaseReceiver
    extends BroadcastReceiver {
        private BaseReceiver() {
        }

        public void onReceive(Context context, final Intent intent) {
            String action = intent.getAction();
            if (ActionBaseFragment.this.bundleActions.contains(action)) {
                ActionBaseFragment.this.receivePageIntent(intent);
                return;
            }
            if (ActionBaseFragment.this.customActions.contains(action)) {
                ActionBaseFragment.this.mWorkHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ActionBaseFragment.this.receiveData(intent);
                    }
                });
                if ("client_connected_to_sdk".equals(action)) {
                    Toast.makeText((Context)ActionBaseFragment.this.getActivity(), (CharSequence)"connected", (int)1).show();
                } else if ("client_disconnect_to_sdk".equals(action)) {
                    Toast.makeText((Context)ActionBaseFragment.this.getActivity(), (CharSequence)"disconnect", (int)1).show();
                }
                return;
            }
            if (ActionBaseFragment.this.mActionCallbackMap != null && ActionBaseFragment.this.mActionCallbackMap.containsKey(action)) {
                int hashCode = intent.getIntExtra("io.rong.imkit.service.RongIMService.EXTRA_ACTION_HASHCODE", -1);
                intent.removeExtra("io.rong.imkit.service.RongIMService.EXTRA_ACTION_HASHCODE");
                List list = (List)ActionBaseFragment.this.mActionCallbackMap.get(action);
                if (list != null) {
                    int listIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        if (hashCode != ((ActionCallback)list.get(i)).hashCode()) continue;
                        listIndex = i;
                        break;
                    }
                    if (listIndex >= 0) {
                        boolean isComplete = intent.getBooleanExtra("intent_is_complete", false);
                        if (isComplete) {
                            ((ActionCallback)list.remove(listIndex)).callback(intent);
                        } else {
                            ((ActionCallback)list.get(listIndex)).callback(intent);
                        }
                    } else {
                        Log.d((String)"ActionBaseFragment---", (String)("actionCall is null" + action));
                    }
                    if (list.isEmpty()) {
                        ActionBaseFragment.this.mActionCallbackMap.remove(action);
                    }
                }
            }
        }
    }
}

