/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.data;

import android.text.TextUtils;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIMessage;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.HandshakeMessage;
import java.util.ArrayList;
import java.util.List;

public class DBHelper {
    public static final String TAG = "DBHelper";
    public static DBHelper dbHelper = null;

    public static DBHelper getInstance() {
        if (dbHelper == null) {
            dbHelper = new DBHelper();
        }
        return dbHelper;
    }

    public ArrayList<UIConversation> getConversationList() {
        List<RongIMClient.Conversation> conversations = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            conversations = RCloudContext.getInstance().getRongIMClient().getConversationList();
        }
        ArrayList<UIConversation> uiConversations = new ArrayList<UIConversation>();
        if (conversations != null) {
            for (RongIMClient.Conversation conversation : conversations) {
                uiConversations.add(new UIConversation(conversation));
            }
        }
        return uiConversations;
    }

    public ArrayList<UIConversation> getConversationGroupList() {
        List<RongIMClient.Conversation> conversations = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            conversations = RCloudContext.getInstance().getRongIMClient().getGroupConversationList();
        }
        ArrayList<UIConversation> uiConversations = new ArrayList<UIConversation>();
        if (conversations != null) {
            for (RongIMClient.Conversation conversation : conversations) {
                conversation.setConversationTitle("");
                String objectName = conversation.getObjectName();
                if (!TextUtils.isEmpty((CharSequence)objectName)) {
                    if (!RCloudContext.isExitMessageType(objectName)) continue;
                    uiConversations.add(new UIConversation(conversation));
                    continue;
                }
                uiConversations.add(new UIConversation(conversation));
            }
        }
        return uiConversations;
    }

    public ArrayList<UIMessage> getMessageList(RongIMClient.ConversationType conversationType, String conversationId, int beginId, int count) {
        ArrayList<UIMessage> uiMessages = new ArrayList<UIMessage>();
        List<RongIMClient.Message> messages = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            messages = RCloudContext.getInstance().getRongIMClient().getHistoryMessages(conversationType, conversationId, beginId, count);
        }
        if (messages != null) {
            for (RongIMClient.Message message : messages) {
                if (message.getContent() == null) continue;
                MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (message.getContent() instanceof HandshakeMessage || msgTag == null || !RCloudContext.isExitMessageType(msgTag.value())) continue;
                UIMessage uiMessage = new UIMessage(message);
                if (message.getSentStatus() == RongIMClient.SentStatus.SENDING) {
                    uiMessage.setProgressText(-2);
                }
                uiMessages.add(uiMessage);
            }
        }
        return uiMessages;
    }

    public ArrayList<UIMessage> getLasetMessageList(RongIMClient.ConversationType conversationType, String targetId, int count) {
        ArrayList<UIMessage> uiMessages = new ArrayList<UIMessage>();
        List<RongIMClient.Message> messages = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            messages = RCloudContext.getInstance().getRongIMClient().getLatestMessages(conversationType, targetId, count);
        }
        if (messages != null) {
            for (RongIMClient.Message message : messages) {
                Log.d((String)"getLasetMessageList", (String)message.getSentStatus().name());
                if (message.getContent() == null) continue;
                MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
                if (message.getContent() instanceof HandshakeMessage || msgTag == null || !RCloudContext.isExitMessageType(msgTag.value())) continue;
                UIMessage uiMessage = new UIMessage(message);
                if (message.getSentStatus() == RongIMClient.SentStatus.SENDING) {
                    uiMessage.setProgressText(-2);
                }
                uiMessages.add(uiMessage);
            }
        }
        return uiMessages;
    }

    public void deleteMessage(ArrayList<Integer> ids) {
        int[] messageIds = null;
        int i = 0;
        if (ids != null && ids.size() > 0) {
            messageIds = new int[ids.size()];
            for (Integer id2 : ids) {
                messageIds[i] = id2;
                ++i;
            }
        }
        if (messageIds != null && RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getRongIMClient().deleteMessages(messageIds);
        }
    }

    public void clearMessages(RongIMClient.ConversationType conversationType, String targetId) {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getRongIMClient().clearMessages(conversationType, targetId);
        }
    }

    public void setTop(RongIMClient.ConversationType conversationType, String targetId, boolean isTop) {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getRongIMClient().setConversationToTop(conversationType, targetId, isTop);
        }
    }

    public void clearUnReadMessage(RongIMClient.ConversationType conversationType, String targetId) {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            RCloudContext.getInstance().getRongIMClient().clearMessagesUnreadStatus(conversationType, targetId);
        }
    }

    public int getTotalUnreadCount() {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            return RCloudContext.getInstance().getRongIMClient().getTotalUnreadCount();
        }
        return -1;
    }

    public boolean removeConversation(RongIMClient.ConversationType conversationType, String targetId) {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            return RCloudContext.getInstance().getRongIMClient().removeConversation(conversationType, targetId);
        }
        return false;
    }

    public UIConversation getConversation(RongIMClient.ConversationType conversationType, String targetId) {
        RongIMClient.Conversation conversation = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
            conversation = RCloudContext.getInstance().getRongIMClient().getConversation(conversationType, targetId);
        }
        if (conversation != null) {
            return new UIConversation(conversation);
        }
        return null;
    }
}

