/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.common;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.PowerManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public interface IVoiceHandler {
    public void setPlayListener(OnPlayListener var1);

    public void setRecListener(OnRecListener var1);

    public void play(Uri ... var1) throws VoiceException;

    public void stop();

    public Uri getCurrentPlayUri();

    public void startRec() throws VoiceException;

    public Uri stopRec(boolean var1);

    public int getCurrentDb();

    public static class VoiceHandler
    implements IVoiceHandler,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    SensorEventListener {
        private AudioManager mAudioManager;
        private SensorManager mSensorManager;
        private PowerManager mPowerManager;
        private MediaPlayer mMediaPlayer;
        private MediaRecorder mMediaRecorder;
        private Sensor mSensor;
        private Context mContext;
        private PowerManager.WakeLock mLock;
        private Uri mCurrentRecUri;
        private List<Uri> mUriCollections;
        private OnPlayListener mPlayListener;
        private OnRecListener mRecListener;
        float mLastEventValue = Float.MIN_VALUE;

        public VoiceHandler(Context context, File recRoot) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
            this.mPowerManager = (PowerManager)context.getSystemService("power");
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mContext = context;
            this.mSensor = this.mSensorManager.getDefaultSensor(8);
            this.mLock = this.mPowerManager.newWakeLock(0x2000000A, "VoiceHandler");
        }

        @Override
        public void setPlayListener(OnPlayListener listener) {
            this.mPlayListener = listener;
        }

        @Override
        public void setRecListener(OnRecListener listener) {
            this.mRecListener = listener;
        }

        private void play(Uri uri) throws VoiceException {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    mp.start();
                    VoiceHandler.this.mLock.acquire((long)mp.getDuration());
                    if (VoiceHandler.this.mPlayListener != null) {
                        VoiceHandler.this.mPlayListener.onPlay();
                    }
                    if (VoiceHandler.this.mSensor != null) {
                        VoiceHandler.this.mSensorManager.registerListener((SensorEventListener)VoiceHandler.this, VoiceHandler.this.mSensor, 3);
                        VoiceHandler.this.mAudioManager.setMode(0);
                    }
                }
            });
            try {
                this.mMediaPlayer.setDataSource(this.mContext, uri);
                this.mMediaPlayer.prepare();
            }
            catch (IllegalArgumentException e) {
                throw new VoiceException(e);
            }
            catch (SecurityException e) {
                throw new VoiceException(e);
            }
            catch (IllegalStateException e) {
                throw new VoiceException(e);
            }
            catch (IOException e) {
                throw new VoiceException(e);
            }
        }

        @Override
        public void play(Uri ... uris) {
            if (uris == null || uris.length == 0) {
                return;
            }
            this.mUriCollections = new LinkedList<Uri>(Arrays.asList(uris));
            this.play(this.mUriCollections.get(0));
        }

        @Override
        public void stop() {
            if (this.mMediaPlayer == null) {
                return;
            }
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mUriCollections = null;
            if (this.mPlayListener != null) {
                this.mPlayListener.onStop();
            }
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }

        private void completePlay() {
            if (this.mMediaPlayer == null) {
                return;
            }
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (this.mPlayListener != null) {
                this.mPlayListener.onStop();
            }
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }

        @Override
        public Uri getCurrentPlayUri() {
            if (this.mUriCollections == null || this.mUriCollections.size() == 0) {
                return null;
            }
            return this.mUriCollections.get(0);
        }

        @Override
        public void startRec() throws VoiceException {
            if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
                this.stop();
            }
            this.mAudioManager.setMode(0);
            this.mMediaRecorder = new MediaRecorder();
            this.mMediaRecorder.setAudioSource(1);
            this.mMediaRecorder.setOutputFormat(3);
            this.mMediaRecorder.setAudioEncoder(1);
            this.mCurrentRecUri = Uri.fromFile((File)new File(this.mContext.getCacheDir(), "temp.voice"));
            this.mMediaRecorder.setOutputFile(this.mCurrentRecUri.getPath());
            try {
                this.mMediaRecorder.prepare();
            }
            catch (IOException e) {
                this.mMediaRecorder.reset();
                this.mMediaRecorder.release();
                throw new VoiceException(e);
            }
            try {
                this.mMediaRecorder.start();
            }
            catch (RuntimeException ex) {
                this.mMediaRecorder.reset();
                this.mMediaRecorder.release();
                throw new VoiceException(ex);
            }
            this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
            if (this.mRecListener != null) {
                this.mRecListener.onRec();
            }
            this.mLock.acquire();
        }

        @Override
        public Uri stopRec(boolean save) throws VoiceException {
            File file;
            if (this.mMediaRecorder == null) {
                return null;
            }
            try {
                this.mMediaRecorder.stop();
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
            }
            catch (RuntimeException e) {
                throw new VoiceException(e);
            }
            Uri temp = this.mCurrentRecUri;
            this.mCurrentRecUri = null;
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            if (this.mRecListener != null && save) {
                this.mRecListener.onCompleted(temp);
            }
            if (!save && (file = new File(temp.getPath())).exists()) {
                file.delete();
            }
            try {
                this.mLock.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return temp;
        }

        @Override
        public int getCurrentDb() {
            if (this.mMediaRecorder == null) {
                return 0;
            }
            return this.mMediaRecorder.getMaxAmplitude() / 600;
        }

        public void onCompletion(MediaPlayer mp) {
            this.completePlay();
            if (this.mPlayListener != null) {
                this.mPlayListener.onStop();
            }
            if (this.mUriCollections != null && this.mUriCollections.size() > 0) {
                this.mUriCollections.remove(0);
            }
            if (this.mUriCollections == null || this.mUriCollections.size() == 0) {
                return;
            }
            this.play(this.mUriCollections.get(0));
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            this.mMediaPlayer.reset();
            return false;
        }

        public void onSensorChanged(SensorEvent event) {
            float value = event.values[0];
            if (this.mLastEventValue == Float.MIN_VALUE) {
                this.mLastEventValue = value;
            }
            if (value > this.mLastEventValue) {
                this.mLastEventValue = value;
            }
            if (value >= this.mLastEventValue) {
                if (this.mAudioManager.getMode() != 0) {
                    this.mAudioManager.setMode(0);
                }
                if (this.mPlayListener != null) {
                    this.mPlayListener.onCover(false);
                }
                if (this.mRecListener != null) {
                    this.mRecListener.onCover(false);
                }
            } else {
                if (this.mAudioManager.getMode() != 2) {
                    this.mAudioManager.setMode(2);
                }
                if (this.mPlayListener != null) {
                    this.mPlayListener.onCover(true);
                }
                if (this.mRecListener != null) {
                    this.mRecListener.onCover(true);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public static interface OnRecListener {
        public void onRec();

        public void onCover(boolean var1);

        public void onCompleted(Uri var1);
    }

    public static interface OnPlayListener {
        public void onPlay();

        public void onCover(boolean var1);

        public void onStop();
    }

    public static class VoiceException
    extends RuntimeException {
        public VoiceException(Throwable e) {
            super(e);
        }
    }
}

