/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.model.VOIPCallBackObject;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SendMessageBroadcast
extends BroadcastReceiver {
    public void onReceive(Context contex, Intent intent) {
        RongIMClient.MessageContent mc = (RongIMClient.MessageContent)intent.getParcelableExtra("messageContent");
        MessageTag msgTag = mc.getClass().getAnnotation(MessageTag.class);
        final String objectName = msgTag.value();
        try {
            String targetId = null;
            if (mc.getClass().getName().equals("io.rong.voipkit.message.VoIPCallMessage")) {
                Class<?> cls = Class.forName("io.rong.voipkit.message.VoIPCallMessage");
                Method method = cls.getMethod("getToId", new Class[0]);
                targetId = (String)method.invoke((Object)mc, new Object[0]);
            } else if (mc.getClass().getName().equals("io.rong.voipkit.message.VoIPAcceptMessage")) {
                Class<?> cls = Class.forName("io.rong.voipkit.message.VoIPAcceptMessage");
                Method method = cls.getMethod("getToId", new Class[0]);
                targetId = (String)method.invoke((Object)mc, new Object[0]);
            } else if (mc.getClass().getName().equals("io.rong.voipkit.message.VoIPFinishMessage")) {
                Class<?> cls = Class.forName("io.rong.voipkit.message.VoIPFinishMessage");
                Method method = cls.getMethod("getToId", new Class[0]);
                targetId = (String)method.invoke((Object)mc, new Object[0]);
            }
            if (targetId == null) {
                return;
            }
            RCloudContext.getInstance().getRongIMClient().sendMessage(RongIMClient.ConversationType.PRIVATE, targetId, mc, new RongIMClient.SendMessageCallback(){

                @Override
                public void onSuccess(int messageId) {
                }

                @Override
                public void onError(int messageId, RongIMClient.SendMessageCallback.ErrorCode errorCode) {
                    Log.d((String)"SendMessageBroadcast", (String)("---------ErrorCode--" + errorCode.getValue()));
                    VOIPCallBackObject voipCallBackObject = new VOIPCallBackObject();
                    voipCallBackObject.setSuccess(false);
                    voipCallBackObject.setObjectName(objectName);
                    voipCallBackObject.setObject((Object)errorCode);
                    RCloudContext.getInstance().getEventBus().post(voipCallBackObject);
                }

                @Override
                public void onProgress(int messageId, int percent) {
                }
            });
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

