/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.RCDateUtils;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;
import io.rong.message.VoiceMessage;
import java.util.Date;
import java.util.List;

public class VoiceItemViewProvider
extends BaseViewProvider {
    private UIUserInfo mUserInfo = null;

    public VoiceItemViewProvider(MessageContext context) {
        super(context);
    }

    @Override
    public int setItemLayoutRes() {
        return Res.getInstance((Context)this.mContext).layout("rc_item_voice_conversation");
    }

    @Override
    public View getItemView(View convertView, BaseViewProvider.ViewHolder holder, RCloudType data, final int position, List datas) {
        String voiceLengthFormat;
        TextView messageTimeTV = (TextView)holder.obtainView(convertView, "conversation_message_time_tv");
        AsyncImageView otherPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_other_portrait");
        TextView userNameRightTextView = (TextView)holder.obtainView(convertView, "conversation_message_username_right_tv");
        ImageView sendFailedImageView = (ImageView)holder.obtainView(convertView, "conversation_message_send_failed");
        ProgressBar progressBar = (ProgressBar)holder.obtainView(convertView, "conversation_message_progressbar");
        AsyncImageView selfPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_self_portrait");
        LinearLayout textRightLayout = (LinearLayout)holder.obtainView(convertView, "text_right_layout_layout");
        LinearLayout textLeftLayout = (LinearLayout)holder.obtainView(convertView, "text_left_layout_layout");
        final ImageView messageLeftContent = (ImageView)holder.obtainView(convertView, "conversation_message_voice_left");
        final ImageView messageRightContent = (ImageView)holder.obtainView(convertView, "conversation_message_voice_right");
        TextView userNameLeftTextView = (TextView)holder.obtainView(convertView, "conversation_message_username_left_tv");
        TextView messageRightLength = (TextView)holder.obtainView(convertView, "conversation_message_right_voice_length");
        TextView messageLeftLength = (TextView)holder.obtainView(convertView, "conversation_message_left_voice_length");
        FrameLayout messageLeftBubble = (FrameLayout)holder.obtainView(convertView, "left_message_bubble_layout");
        FrameLayout messageRightBubble = (FrameLayout)holder.obtainView(convertView, "right_message_bubble_layout");
        ImageView voiceStateView = (ImageView)holder.obtainView(convertView, "conversation_message_left_voice_unread");
        final UIMessage message = (UIMessage)data;
        message.setPositionInList(position);
        long currentTime = 0L;
        VoiceMessage voiceMessage = (VoiceMessage)message.getContent();
        currentTime = message.getSentTime();
        if (position > 0) {
            UIMessage messageTemp = (UIMessage)datas.get(position - 1);
            long preTime = 0L;
            preTime = messageTemp.getSentTime();
            if (RCDateUtils.isShowChatTime(currentTime, preTime)) {
                messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentTime)));
                messageTimeTV.setVisibility(0);
            } else {
                messageTimeTV.setVisibility(8);
            }
        } else {
            messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentTime)));
            messageTimeTV.setVisibility(0);
        }
        selfPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VoiceItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo());
            }
        });
        otherPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.getUserInfo() != null) {
                    VoiceItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, message.getUserInfo());
                }
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.SEND) {
            UIUserInfo userInfoSend;
            Resource resource = null;
            if (this.mUserInfo != null && message.getUserInfo() == null) {
                message.setUserInfo(this.mUserInfo);
            }
            if ((userInfoSend = message.getUserInfo()) == null || TextUtils.isEmpty((CharSequence)userInfoSend.getName())) {
                userInfoSend = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoSend != null) {
                message.setUserInfo(userInfoSend);
                resource = userInfoSend.getPortraitResource();
                message.setUserInfo(userInfoSend);
            }
            if (resource != null) {
                selfPortrait.setResource(resource);
            }
            if (voiceMessage.getUri().equals((Object)this.mContext.getVoiceHandler().getCurrentPlayUri())) {
                AnimationDrawable drawable2 = (AnimationDrawable)this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_send_voice_anim"));
                messageRightContent.setImageDrawable((Drawable)drawable2);
                messageRightContent.post(new Runnable(){

                    @Override
                    public void run() {
                        if (messageRightContent.getDrawable() instanceof AnimationDrawable) {
                            ((AnimationDrawable)messageRightContent.getDrawable()).start();
                        }
                    }
                });
            } else {
                messageRightContent.setImageDrawable(this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_voice_icon_right")));
            }
        } else if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            if (message.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
                otherPortrait.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_custom_service_default_portrait")));
            }
            if (RongIMClient.ConversationType.PRIVATE != message.getConversationType() && RongIMClient.ConversationType.CUSTOMER_SERVICE != message.getConversationType()) {
                userNameLeftTextView.setVisibility(0);
            }
            UIUserInfo userInfoTarget = message.getUserInfo();
            Resource resource = null;
            if (userInfoTarget == null || TextUtils.isEmpty((CharSequence)userInfoTarget.getName())) {
                userInfoTarget = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoTarget != null) {
                resource = userInfoTarget.getPortraitResource();
                userNameLeftTextView.setText((CharSequence)userInfoTarget.getName());
                message.setUserInfo(userInfoTarget);
            }
            if (resource != null) {
                otherPortrait.setResource(resource);
            }
            if (voiceMessage.getUri().equals((Object)this.mContext.getVoiceHandler().getCurrentPlayUri())) {
                AnimationDrawable drawable3 = (AnimationDrawable)this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_receive_voice_anim"));
                messageLeftContent.setImageDrawable((Drawable)drawable3);
                messageLeftBubble.post(new Runnable(){

                    @Override
                    public void run() {
                        if (messageLeftContent.getDrawable() instanceof AnimationDrawable) {
                            ((AnimationDrawable)messageLeftContent.getDrawable()).start();
                        }
                    }
                });
            } else {
                messageLeftContent.setImageDrawable(this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_voice_icon_left")));
            }
        }
        messageRightBubble.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VoiceItemViewProvider.this.onMessageClick(message) && VoiceItemViewProvider.this.mOnMessageItemClickListener != null) {
                    VoiceItemViewProvider.this.mOnMessageItemClickListener.onMessageClick(message, (View)messageRightContent);
                }
            }
        });
        messageRightBubble.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (VoiceItemViewProvider.this.mOnMessageItemClickListener != null) {
                    VoiceItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        messageLeftBubble.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VoiceItemViewProvider.this.onMessageClick(message) && VoiceItemViewProvider.this.mOnMessageItemClickListener != null) {
                    VoiceItemViewProvider.this.mOnMessageItemClickListener.onMessageClick(message, (View)messageLeftContent);
                }
            }
        });
        messageLeftBubble.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (VoiceItemViewProvider.this.mOnMessageItemClickListener != null) {
                    VoiceItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        sendFailedImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VoiceItemViewProvider.this.mOnMessageItemClickListener != null) {
                    VoiceItemViewProvider.this.mOnMessageItemClickListener.onResendMessage(message, position);
                }
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            textRightLayout.setVisibility(8);
            textLeftLayout.setVisibility(0);
            sendFailedImageView.setVisibility(8);
            progressBar.setVisibility(4);
            userNameRightTextView.setVisibility(8);
            otherPortrait.setVisibility(0);
            selfPortrait.setVisibility(4);
            voiceLengthFormat = this.mContext.getString(Res.getInstance((Context)this.mContext).string("voice_length"));
            if (message.getContent() instanceof VoiceMessage) {
                int width;
                messageLeftLength.setText((CharSequence)String.format(voiceLengthFormat, voiceMessage.getDuration()));
                messageLeftBubble.getLayoutParams().width = width = (int)this.mContext.getResources().getDimension(Res.getInstance((Context)this.mContext).dimen(this.getDimenStr(voiceMessage.getDuration())));
            }
            if (message.getReceivedStatus().isListened()) {
                voiceStateView.setVisibility(8);
            } else {
                voiceStateView.setVisibility(0);
            }
        } else if (message.getMessageDirection() == RongIMClient.MessageDirection.SEND) {
            textRightLayout.setVisibility(0);
            textLeftLayout.setVisibility(8);
            userNameLeftTextView.setVisibility(8);
            selfPortrait.setVisibility(0);
            otherPortrait.setVisibility(4);
            if (RongIMClient.SentStatus.SENT == message.getSentStatus()) {
                sendFailedImageView.setVisibility(8);
                progressBar.setVisibility(4);
            } else if (RongIMClient.SentStatus.FAILED == message.getSentStatus()) {
                sendFailedImageView.setVisibility(0);
                progressBar.setVisibility(4);
            } else if (RongIMClient.SentStatus.SENDING == message.getSentStatus()) {
                if (message.isSending()) {
                    progressBar.setVisibility(0);
                    sendFailedImageView.setVisibility(8);
                } else {
                    progressBar.setVisibility(8);
                    sendFailedImageView.setVisibility(0);
                }
            }
            voiceLengthFormat = this.mContext.getString(Res.getInstance((Context)this.mContext).string("voice_length"));
            if (message.getContent() instanceof VoiceMessage) {
                int width;
                messageRightLength.setText((CharSequence)String.format(voiceLengthFormat, voiceMessage.getDuration()));
                messageRightBubble.getLayoutParams().width = width = (int)this.mContext.getResources().getDimension(Res.getInstance((Context)this.mContext).dimen(this.getDimenStr(voiceMessage.getDuration())));
            }
        }
        return convertView;
    }

    private final String getDimenStr(long voiceLength) {
        int baseLength = 120;
        int totalLength = 400;
        int realTotalLength = totalLength - baseLength;
        int length = (int)voiceLength * (realTotalLength / 60);
        if (baseLength + length > totalLength) {
            return String.format("px_to_dip_%1$s", totalLength);
        }
        return String.format("px_to_dip_%1$s", baseLength + length);
    }
}

