/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.RCDateUtils;
import io.rong.imkit.utils.Util;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;
import io.rong.message.TextMessage;
import java.util.Date;
import java.util.List;

public class TextItemViewProvider
extends BaseViewProvider {
    private UIUserInfo mUserInfo = null;

    public TextItemViewProvider(MessageContext context) {
        super(context);
    }

    @Override
    public int setItemLayoutRes() {
        return Res.getInstance((Context)this.mContext).layout("rc_item_text_conversation");
    }

    @Override
    public View getItemView(View convertView, BaseViewProvider.ViewHolder holder, RCloudType data, final int position, List datas) {
        TextMessage textMessage;
        TextView messageTimeTV = (TextView)holder.obtainView(convertView, "conversation_message_time_tv");
        AsyncImageView otherPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_other_portrait");
        ImageView sendFailedImageView = (ImageView)holder.obtainView(convertView, "conversation_message_send_failed");
        TextView messageRightContent = (TextView)holder.obtainView(convertView, "conversation_message_content_right_tv");
        ProgressBar progressBar = (ProgressBar)holder.obtainView(convertView, "conversation_message_progressbar");
        AsyncImageView selfPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_self_portrait");
        LinearLayout textRightLayout = (LinearLayout)holder.obtainView(convertView, "text_right_layout_layout");
        LinearLayout textLeftLayout = (LinearLayout)holder.obtainView(convertView, "text_left_layout_layout");
        TextView userNameLeftTextView = (TextView)holder.obtainView(convertView, "conversation_message_username_left_tv");
        TextView messageLeftContent = (TextView)holder.obtainView(convertView, "conversation_message_content_left_tv");
        messageRightContent.setMovementMethod(LinkMovementMethod.getInstance());
        messageLeftContent.setMovementMethod(LinkMovementMethod.getInstance());
        messageRightContent.setText((CharSequence)"");
        messageLeftContent.setText((CharSequence)"");
        otherPortrait.clean();
        selfPortrait.clean();
        final UIMessage message = (UIMessage)data;
        message.setPositionInList(position);
        long currentMessageTime = 0L;
        currentMessageTime = message.getSentTime();
        if (position > 0) {
            UIMessage messageTemp = (UIMessage)datas.get(position - 1);
            long preTime = 0L;
            preTime = messageTemp.getSentTime();
            if (RCDateUtils.isShowChatTime(currentMessageTime, preTime)) {
                messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentMessageTime)));
                messageTimeTV.setVisibility(0);
            } else {
                messageTimeTV.setVisibility(8);
            }
        } else {
            messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentMessageTime)));
            messageTimeTV.setVisibility(0);
        }
        selfPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TextItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo());
            }
        });
        otherPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.getUserInfo() != null) {
                    TextItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, message.getUserInfo());
                }
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.SEND) {
            UIUserInfo userInfoSend;
            Resource resource = null;
            if (this.mUserInfo != null && message.getUserInfo() == null) {
                message.setUserInfo(this.mUserInfo);
            }
            if ((userInfoSend = message.getUserInfo()) == null || TextUtils.isEmpty((CharSequence)userInfoSend.getName())) {
                userInfoSend = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoSend != null && userInfoSend.getPortraitResource() != null) {
                message.setUserInfo(userInfoSend);
                resource = userInfoSend.getPortraitResource();
            }
            if (resource != null) {
                selfPortrait.setResource(resource);
            }
        } else if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            if (message.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
                otherPortrait.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_custom_service_default_portrait")));
            }
            UIUserInfo userInfoTarget = message.getUserInfo();
            Resource resource = null;
            if (RongIMClient.ConversationType.PRIVATE != message.getConversationType() && RongIMClient.ConversationType.CUSTOMER_SERVICE != message.getConversationType()) {
                userNameLeftTextView.setVisibility(0);
            }
            if (userInfoTarget == null || TextUtils.isEmpty((CharSequence)userInfoTarget.getName())) {
                userInfoTarget = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoTarget != null && !TextUtils.isEmpty((CharSequence)userInfoTarget.getName())) {
                resource = userInfoTarget.getPortraitResource();
                userNameLeftTextView.setText((CharSequence)userInfoTarget.getName());
                message.setUserInfo(userInfoTarget);
            }
            if (resource != null) {
                otherPortrait.setResource(resource);
            }
        }
        messageRightContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TextItemViewProvider.this.onMessageClick(message);
            }
        });
        messageRightContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (TextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    TextItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        messageLeftContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TextItemViewProvider.this.onMessageClick(message);
            }
        });
        messageLeftContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (TextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    TextItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        sendFailedImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    TextItemViewProvider.this.mOnMessageItemClickListener.onResendMessage(message, position);
                }
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            textRightLayout.setVisibility(8);
            textLeftLayout.setVisibility(0);
            textMessage = null;
            if (message.getContent() instanceof TextMessage && !TextUtils.isEmpty((CharSequence)(textMessage = (TextMessage)message.getContent()).getContent())) {
                messageLeftContent.append((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(textMessage.getContent()))));
            }
            sendFailedImageView.setVisibility(8);
            progressBar.setVisibility(8);
            otherPortrait.setVisibility(0);
            selfPortrait.setVisibility(8);
        } else {
            textRightLayout.setVisibility(0);
            textLeftLayout.setVisibility(8);
            if (message.getContent() instanceof TextMessage && !TextUtils.isEmpty((CharSequence)(textMessage = (TextMessage)message.getContent()).getContent())) {
                messageRightContent.append((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(textMessage.getContent()))));
            }
            selfPortrait.setVisibility(0);
            otherPortrait.setVisibility(4);
            sendFailedImageView.setVisibility(8);
            progressBar.setVisibility(8);
            if (message.isSending()) {
                sendFailedImageView.setVisibility(8);
                progressBar.setVisibility(0);
            } else if (RongIMClient.SentStatus.FAILED == message.getSentStatus()) {
                sendFailedImageView.setVisibility(0);
                progressBar.setVisibility(8);
            } else if (RongIMClient.SentStatus.SENDING == message.getSentStatus()) {
                sendFailedImageView.setVisibility(8);
                progressBar.setVisibility(0);
            } else if (RongIMClient.SentStatus.SENT == message.getSentStatus()) {
                sendFailedImageView.setVisibility(8);
                progressBar.setVisibility(8);
            }
        }
        return convertView;
    }
}

