/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utils.RCDateUtils;
import io.rong.imlib.RongIMClient;
import java.util.Date;
import java.util.List;

public class NotificationViewProvider
extends BaseViewProvider {
    public NotificationViewProvider(MessageContext context) {
        super(context);
    }

    @Override
    public int setItemLayoutRes() {
        return Res.getInstance((Context)this.mContext).layout("rc_item_notification_message_conversation");
    }

    @Override
    public View getItemView(View convertView, BaseViewProvider.ViewHolder holder, RCloudType data, int position, List datas) {
        TextView messageTimeTV = (TextView)holder.obtainView(convertView, "conversation_message_time_tv");
        TextView notificationTextView = (TextView)holder.obtainView(convertView, "conversation_notification_message_tv");
        notificationTextView.setVisibility(8);
        UIMessage message = (UIMessage)data;
        long currentMessageTime = 0L;
        currentMessageTime = message.getSentTime();
        if (position > 0) {
            UIMessage messageTemp = (UIMessage)datas.get(position - 1);
            long preTime = 0L;
            preTime = messageTemp.getSentTime();
            if (RCDateUtils.isShowChatTime(currentMessageTime, preTime)) {
                messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentMessageTime)));
                messageTimeTV.setVisibility(0);
            } else {
                messageTimeTV.setVisibility(8);
            }
        } else {
            messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentMessageTime)));
            messageTimeTV.setVisibility(0);
        }
        if (message != null && message.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
            RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)message.getContent();
            String selfUserId = RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo().getUserId();
            String[] userIds = null;
            String operator = discussionNotificationMessage.getOperator();
            userIds = discussionNotificationMessage.getExtension().indexOf(",") != -1 ? discussionNotificationMessage.getExtension().split(",") : new String[]{discussionNotificationMessage.getExtension()};
            switch (discussionNotificationMessage.getType()) {
                case 1: {
                    if (operator.equals(selfUserId)) {
                        if (userIds == null) break;
                        if (userIds.length > 1) {
                            String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_add"));
                            notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", userIds.length));
                            notificationTextView.setVisibility(0);
                            break;
                        }
                        if (userIds.length != 1) break;
                        if (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName())) {
                            message.setOperatored(this.getUserInfoByCache(userIds[0]));
                        }
                        if (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName())) break;
                        String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_added"));
                        notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", message.getOperatored().getName()));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (userIds == null) break;
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) {
                        message.setOperator(this.getUserInfoByCache(operator));
                    }
                    if (userIds.length == 1) {
                        if (!userIds[0].equals(selfUserId) && (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName()))) {
                            message.setOperatored(this.getUserInfoByCache(userIds[0]));
                        }
                        if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) break;
                        String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_added"));
                        if (userIds[0].equals(selfUserId)) {
                            notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), "\u4f60"));
                            notificationTextView.setVisibility(0);
                            break;
                        }
                        if (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName())) break;
                        notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), message.getOperatored().getName()));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) break;
                    String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_add"));
                    notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), userIds.length));
                    notificationTextView.setVisibility(0);
                    break;
                }
                case 2: {
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) {
                        message.setOperator(this.getUserInfoByCache(operator));
                    }
                    if (userIds == null || message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) break;
                    String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_exit"));
                    notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName()));
                    notificationTextView.setVisibility(0);
                    break;
                }
                case 3: {
                    String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_rename"));
                    if (operator.equals(selfUserId)) {
                        notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", discussionNotificationMessage.getExtension()));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) {
                        message.setOperator(this.getUserInfoByCache(operator));
                    }
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) break;
                    notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), discussionNotificationMessage.getExtension()));
                    notificationTextView.setVisibility(0);
                    break;
                }
                case 4: {
                    if (userIds == null) break;
                    String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_who_removed"));
                    if (!operator.equals(selfUserId) && (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName()))) {
                        message.setOperator(this.getUserInfoByCache(operator));
                    }
                    if (!userIds[0].equals(selfUserId) && (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName()))) {
                        message.setOperatored(this.getUserInfoByCache(userIds[0]));
                    }
                    if (operator.equals(selfUserId)) {
                        if (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName())) break;
                        notificationTextView.setText((CharSequence)String.format(formatString, message.getOperatored().getName(), "\u4f60"));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) break;
                    if (userIds[0].equals(selfUserId)) {
                        if (!"-1".equals(discussionNotificationMessage.getOperator())) {
                            notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", message.getOperator().getName()));
                        } else {
                            notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", ""));
                        }
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (message.getOperatored() == null || TextUtils.isEmpty((CharSequence)message.getOperatored().getName())) break;
                    notificationTextView.setText((CharSequence)String.format(formatString, message.getOperatored().getName(), message.getOperator().getName()));
                    notificationTextView.setVisibility(0);
                    break;
                }
                case 5: {
                    String formatString = this.mContext.getResources().getString(Res.getInstance((Context)this.mContext).string("notification_message_discussion_is_open_invite"));
                    if (operator.equals(selfUserId)) {
                        if (discussionNotificationMessage.getExtension().equals("1")) {
                            notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", "\u5173\u95ed"));
                            notificationTextView.setVisibility(0);
                            break;
                        }
                        if (!discussionNotificationMessage.getExtension().equals("0")) break;
                        notificationTextView.setText((CharSequence)String.format(formatString, "\u4f60", "\u5f00\u653e"));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (message.getOperator() == null || TextUtils.isEmpty((CharSequence)message.getOperator().getName())) {
                        message.setOperator(this.getUserInfoByCache(operator));
                    }
                    if (discussionNotificationMessage.getExtension().equals("1")) {
                        notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), "\u5173\u95ed"));
                        notificationTextView.setVisibility(0);
                        break;
                    }
                    if (!discussionNotificationMessage.getExtension().equals("0")) break;
                    notificationTextView.setText((CharSequence)String.format(formatString, message.getOperator().getName(), "\u5f00\u653e"));
                    notificationTextView.setVisibility(0);
                    break;
                }
                default: {
                    notificationTextView.setVisibility(8);
                }
            }
        }
        return convertView;
    }
}

