/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseAdapter;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import java.util.HashMap;

public class MultiItemViewListAdapter
extends BaseAdapter<UIMessage> {
    private LayoutInflater mInflater;
    private HashMap<String, BaseViewProvider> mViewProviderMap = new HashMap();
    public BaseViewProvider.OnMessageItemClickListener mOnMessageItemClickListener;
    private BaseViewProvider.OnGetDataListener mOnGetDataListener;

    public MultiItemViewListAdapter(MessageContext context) {
        super((Context)context);
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        UIMessage message = (UIMessage)this.dataSet.get(position);
        BaseViewProvider iViewProvider = null;
        if (!this.mViewProviderMap.containsKey(message.getMessageCategory())) {
            iViewProvider = message.getItemViewProvider((MessageContext)this.mContext);
            this.mViewProviderMap.put(message.getMessageCategory(), iViewProvider);
        } else {
            iViewProvider = this.mViewProviderMap.get(message.getMessageCategory());
        }
        if (iViewProvider != null) {
            iViewProvider.setOnMessageItemClickListener(this.mOnMessageItemClickListener);
            iViewProvider.setOnGetDataListener(this.mOnGetDataListener);
        }
        if (convertView == null) {
            convertView = iViewProvider.getItemView(convertView, this.mInflater, (RCloudType)message, position, this.dataSet);
        } else {
            String type = (String)convertView.getTag(Res.getInstance(this.mContext).string("tag_id"));
            if (type != null && message.getMessageCategory().equals(type)) {
                convertView = iViewProvider.getItemView(convertView, this.mInflater, (RCloudType)message, position, this.dataSet);
            } else {
                convertView = iViewProvider.getItemView(null, this.mInflater, (RCloudType)message, position, this.dataSet);
                convertView.setTag(Res.getInstance(this.mContext).string("tag_id"), (Object)message.getMessageCategory());
            }
        }
        return convertView;
    }

    public void setOnMessageItemClickListener(BaseViewProvider.OnMessageItemClickListener listener) {
        this.mOnMessageItemClickListener = listener;
    }

    public int getItemViewType(int position) {
        if (position < 0 || position >= this.dataSet.size()) {
            return 0;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 6;
    }

    public void setOnGetDataListener(BaseViewProvider.OnGetDataListener mOnGetDataListener) {
        this.mOnGetDataListener = mOnGetDataListener;
    }
}

