/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.sea_monster.core.resource.model.CompressedResource;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.RCDateUtils;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;
import io.rong.message.RichContentMessage;
import java.util.Date;
import java.util.List;

public class ImageTextItemViewProvider
extends BaseViewProvider {
    private UIUserInfo mUserInfo = null;

    public ImageTextItemViewProvider(MessageContext context) {
        super(context);
    }

    @Override
    public int setItemLayoutRes() {
        return Res.getInstance((Context)this.mContext).layout("rc_item_image_text_conversation");
    }

    @Override
    public View getItemView(View convertView, BaseViewProvider.ViewHolder holder, RCloudType data, final int position, List datas) {
        RichContentMessage imageTextMessage;
        TextView messageTimeTV = (TextView)holder.obtainView(convertView, "conversation_message_time_tv");
        AsyncImageView otherPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_other_portrait");
        TextView userNameRightTextView = (TextView)holder.obtainView(convertView, "conversation_message_username_right_tv");
        ImageView sendFailedImageView = (ImageView)holder.obtainView(convertView, "conversation_message_send_failed");
        FrameLayout messageRightContent = (FrameLayout)holder.obtainView(convertView, "conversation_message_right_tv");
        AsyncImageView selfPortrait = (AsyncImageView)holder.obtainView(convertView, "conversation_message_self_portrait");
        LinearLayout textRightLayout = (LinearLayout)holder.obtainView(convertView, "text_right_layout_layout");
        LinearLayout textLeftLayout = (LinearLayout)holder.obtainView(convertView, "text_left_layout_layout");
        TextView progressTextView = (TextView)holder.obtainView(convertView, "progress_textview");
        TextView userNameLeftTextView = (TextView)holder.obtainView(convertView, "conversation_message_username_left_tv");
        FrameLayout messageLeftContent = (FrameLayout)holder.obtainView(convertView, "conversation_message_left_tv");
        TextView titleTextViewRight = (TextView)holder.obtainView(convertView, "rc_image_text_title_right");
        TextView contentTextViewRight = (TextView)holder.obtainView(convertView, "rc_image_text_content_right");
        AsyncImageView contentImageRight = (AsyncImageView)holder.obtainView(convertView, "rc_image_text_content_image_right");
        TextView titleTextViewLeft = (TextView)holder.obtainView(convertView, "rc_image_text_title_left");
        TextView contentTextViewLeft = (TextView)holder.obtainView(convertView, "rc_image_text_content_left");
        AsyncImageView contentImageLeft = (AsyncImageView)holder.obtainView(convertView, "rc_image_text_content_image_left");
        final UIMessage message = (UIMessage)data;
        message.setPositionInList(position);
        long currentTime = 0L;
        currentTime = message.getSentTime();
        if (position > 0) {
            UIMessage messageTemp = (UIMessage)datas.get(position - 1);
            long preTime = 0L;
            preTime = messageTemp.getSentTime();
            if (RCDateUtils.isShowChatTime(currentTime, preTime)) {
                messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentTime)));
                messageTimeTV.setVisibility(0);
            } else {
                messageTimeTV.setVisibility(8);
            }
        } else {
            messageTimeTV.setText((CharSequence)RCDateUtils.getConvastionFromatDate(new Date(currentTime)));
            messageTimeTV.setVisibility(0);
        }
        selfPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageTextItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo());
            }
        });
        otherPortrait.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.getUserInfo() != null) {
                    ImageTextItemViewProvider.this.onPortraitClick((RongIMClient.Message)message, message.getUserInfo());
                }
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.SEND) {
            UIUserInfo userInfoSend;
            Resource resource = null;
            if (this.mUserInfo != null && message.getUserInfo() == null) {
                message.setUserInfo(this.mUserInfo);
            }
            if ((userInfoSend = message.getUserInfo()) == null || TextUtils.isEmpty((CharSequence)userInfoSend.getName())) {
                userInfoSend = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoSend != null) {
                message.setUserInfo(userInfoSend);
                resource = userInfoSend.getPortraitResource();
                message.setUserInfo(userInfoSend);
            }
            if (resource != null) {
                selfPortrait.setResource(resource);
            }
        } else if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            if (message.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
                otherPortrait.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance((Context)this.mContext).drawable("rc_custom_service_default_portrait")));
            }
            UIUserInfo userInfoTarget = message.getUserInfo();
            Resource resource = null;
            if (RongIMClient.ConversationType.PRIVATE != message.getConversationType() && RongIMClient.ConversationType.CUSTOMER_SERVICE != message.getConversationType()) {
                userNameLeftTextView.setVisibility(0);
            }
            if (userInfoTarget == null || TextUtils.isEmpty((CharSequence)userInfoTarget.getName())) {
                userInfoTarget = this.getUserInfoByCache(message.getSenderUserId());
            }
            if (userInfoTarget != null) {
                resource = userInfoTarget.getPortraitResource();
                userNameLeftTextView.setText((CharSequence)userInfoTarget.getName());
                message.setUserInfo(userInfoTarget);
            }
            if (resource != null) {
                otherPortrait.setResource(resource);
            }
        }
        messageRightContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ImageTextItemViewProvider.this.onMessageClick(message) && ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onMessageClick(message, null);
                }
            }
        });
        messageRightContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        messageLeftContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ImageTextItemViewProvider.this.onMessageClick(message) && ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onMessageClick(message, null);
                }
            }
        });
        messageLeftContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        sendFailedImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onResendMessage(message, position);
                }
            }
        });
        messageRightContent.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImageTextItemViewProvider.this.mOnMessageItemClickListener != null) {
                    ImageTextItemViewProvider.this.mOnMessageItemClickListener.onMessageLongClick(message);
                }
                return true;
            }
        });
        if (message.getMessageDirection() == RongIMClient.MessageDirection.RECEIVE) {
            textRightLayout.setVisibility(8);
            textLeftLayout.setVisibility(0);
            if (message.getContent() != null && message.getContent() instanceof RichContentMessage) {
                imageTextMessage = (RichContentMessage)message.getContent();
                titleTextViewLeft.setText((CharSequence)imageTextMessage.getTitle());
                contentTextViewLeft.setText((CharSequence)imageTextMessage.getContent());
                if (!TextUtils.isEmpty((CharSequence)imageTextMessage.getUrl())) {
                    contentImageLeft.setResource(new CompressedResource(new Resource(imageTextMessage.getUrl()), 120, 120));
                }
            }
            sendFailedImageView.setVisibility(8);
            userNameRightTextView.setVisibility(8);
            otherPortrait.setVisibility(0);
            selfPortrait.setVisibility(4);
            selfPortrait.setVisibility(4);
            progressTextView.setVisibility(8);
        } else if (message.getMessageDirection() == RongIMClient.MessageDirection.SEND) {
            if (RongIMClient.SentStatus.SENT == message.getSentStatus()) {
                sendFailedImageView.setVisibility(8);
                progressTextView.setVisibility(8);
            } else if (RongIMClient.SentStatus.FAILED == message.getSentStatus()) {
                sendFailedImageView.setVisibility(0);
                progressTextView.setVisibility(8);
            } else if (RongIMClient.SentStatus.SENDING == message.getSentStatus()) {
                progressTextView.setVisibility(0);
                sendFailedImageView.setVisibility(8);
            }
            textRightLayout.setVisibility(0);
            textLeftLayout.setVisibility(8);
            if (message.getProgressText() == 100 || message.getProgressText() == -1) {
                progressTextView.setVisibility(8);
            } else {
                progressTextView.setVisibility(0);
                progressTextView.setText((CharSequence)(message.getProgressText() + "%"));
            }
            if (message.getContent() != null && message.getContent() instanceof RichContentMessage) {
                imageTextMessage = (RichContentMessage)message.getContent();
                titleTextViewRight.setText((CharSequence)imageTextMessage.getTitle());
                contentTextViewRight.setText((CharSequence)imageTextMessage.getContent());
                contentImageRight.setResource(new CompressedResource(new Resource(imageTextMessage.getUrl()), 120, 120));
            }
            userNameLeftTextView.setVisibility(8);
            selfPortrait.setVisibility(0);
            otherPortrait.setVisibility(4);
        }
        return convertView;
    }
}

