/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.FriendListAdapter;
import io.rong.imkit.model.Friend;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.List;

public class FriendMultiChoiceAdapter
extends FriendListAdapter {
    private List<String> mChoiceFriendIds;
    private MutilChoiceCallback mCallback;
    private ArrayList<Friend> mFriends;

    public FriendMultiChoiceAdapter(Context context, List<Friend> friends, List<String> mSelectedList) {
        super(context, friends);
        this.mFriends = (ArrayList)friends;
        this.mChoiceFriendIds = mSelectedList;
    }

    @Override
    protected void bindView(View v, int partition, List<Friend> data, int position) {
        String userId;
        super.bindView(v, partition, data, position);
        FriendListAdapter.ViewHolder holder = (FriendListAdapter.ViewHolder)v.getTag();
        TextView name = holder.name;
        AsyncImageView photo = holder.photo;
        Friend friend = data.get(position);
        name.setText((CharSequence)friend.getNickname());
        Resource res = friend.getPortraitResource();
        photo.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_portrait")));
        photo.setResource(res);
        holder.userId = userId = friend.getUserId();
        if (friend.isSelected()) {
            holder.choice.setButtonDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_multi_choice_disable")));
            holder.choice.setChecked(true);
            holder.choice.setEnabled(false);
        } else {
            holder.choice.setEnabled(true);
            holder.choice.setChecked(this.mChoiceFriendIds.contains(friend.getUserId()));
            holder.choice.setButtonDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_checkbox_selector")));
        }
    }

    @Override
    protected void newSetTag(View view, FriendListAdapter.ViewHolder holder, int position, List<Friend> data) {
        super.newSetTag(view, holder, position, data);
        CheckBox checkBox = (CheckBox)view.findViewById(0x1020001);
        checkBox.setVisibility(0);
        holder.choice = checkBox;
    }

    @Override
    public void onItemClick(String friendId, CheckBox checkBox) {
        if (!checkBox.isEnabled()) {
            return;
        }
        boolean isChoose = checkBox.isChecked();
        if (isChoose) {
            checkBox.setChecked(!isChoose);
            this.mChoiceFriendIds.remove(friendId);
            if (this.mCallback != null) {
                this.mCallback.callback(this.mChoiceFriendIds.size());
            }
        } else {
            int setMaxCount = this.mContext.getResources().getInteger(Res.getInstance(this.mContext).integer("discussion_member_max_count"));
            if (setMaxCount > 500) {
                setMaxCount = 500;
            }
            if (this.mChoiceFriendIds.size() <= setMaxCount - 2) {
                checkBox.setChecked(!isChoose);
                this.mChoiceFriendIds.add(friendId);
                if (this.mCallback != null) {
                    this.mCallback.callback(this.mChoiceFriendIds.size());
                }
            } else if (this.mCallback != null) {
                this.mCallback.callback(setMaxCount);
            }
        }
    }

    public List<String> getChoiceList() {
        return this.mChoiceFriendIds;
    }

    public ArrayList<RongIMClient.UserInfo> getChoiceUserInfos() {
        ArrayList<RongIMClient.UserInfo> userInfos = new ArrayList<RongIMClient.UserInfo>();
        if (this.mChoiceFriendIds.size() > 0 && this.mFriends != null) {
            for (String userId : this.mChoiceFriendIds) {
                for (Friend friend : this.mFriends) {
                    if (!userId.equals(friend.getUserId()) || friend.isSelected()) continue;
                    RongIMClient.UserInfo userInfo = new RongIMClient.UserInfo(friend.getUserId(), friend.getNickname(), friend.getPortrait());
                    userInfos.add(userInfo);
                }
            }
        }
        return userInfos;
    }

    public void setCallback(MutilChoiceCallback callback) {
        this.mCallback = callback;
    }

    public static interface MutilChoiceCallback {
        public void callback(int var1);
    }
}

