/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.Res;
import io.rong.imkit.model.Friend;
import io.rong.imkit.model.FriendSectionIndexer;
import io.rong.imkit.utils.PinyinFilterList;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imkit.view.CompositeAdapter;
import io.rong.imkit.view.PinnedHeaderAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@SuppressLint(value={"UseSparseArrays"})
public class FriendListAdapter
extends PinnedHeaderAdapter<Friend>
implements Filterable {
    private LayoutInflater mInflater;
    private FriendFilter mFilter;
    private ArrayList<View> mViewList;

    public FriendListAdapter(Context context, List<Friend> friends) {
        super(context);
        this.setAdapterData(friends);
        this.mViewList = new ArrayList();
        if (context != null) {
            this.mInflater = LayoutInflater.from((Context)context);
        }
    }

    public void setAdapterData(List<Friend> friends) {
        if (this.dataSet != null) {
            this.dataSet.clear();
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        ArrayList result = new ArrayList();
        char key = '\u0000';
        for (Friend friend : friends) {
            key = friend.getSearchKey();
            if (hashMap.containsKey(key)) {
                int position = (Integer)hashMap.get(key);
                if (position > result.size() - 1) continue;
                ((List)result.get(position)).add(friend);
                continue;
            }
            result.add(new ArrayList());
            int length = result.size() - 1;
            ((List)result.get(length)).add(friend);
            hashMap.put(Integer.valueOf(key), length);
        }
        this.updateCollection(result);
        this.mFilter = new FriendFilter(friends);
    }

    @Override
    protected View newView(Context context, int partition, List<Friend> data, int position, ViewGroup parent) {
        View view = this.mInflater.inflate(Res.getInstance(context).layout("rc_item_friend"), null);
        ViewHolder holder = new ViewHolder();
        this.newSetTag(view, holder, position, data);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    protected void bindView(View v, int partition, List<Friend> data, int position) {
        ViewHolder holder = (ViewHolder)v.getTag();
        TextView name = holder.name;
        AsyncImageView photo = holder.photo;
        Friend friend = data.get(position);
        name.setText((CharSequence)friend.getNickname());
        Resource res = friend.getPortraitResource();
        photo.setResource(res);
        photo.setTag(position);
        holder.friend = friend;
    }

    @Override
    protected View newHeaderView(Context context, int partition, List<Friend> data, ViewGroup parent) {
        View view = this.mInflater.inflate(Res.getInstance(context).layout("rc_item_friend_index"), null);
        view.setTag((Object)view.findViewById(16908308));
        return view;
    }

    @Override
    protected void bindHeaderView(View view, int partition, List<Friend> data) {
        Object objTag = view.getTag();
        if (objTag != null) {
            ((TextView)objTag).setText((CharSequence)String.valueOf(data.get(0).getSearchKey()));
        }
    }

    @Override
    protected SectionIndexer updateIndexer(CompositeAdapter.Partition<Friend>[] data) {
        return new FriendSectionIndexer(data);
    }

    @Override
    public void configurePinnedHeader(View header, int position, int alpha) {
        int section;
        PinnedHeaderCache cache = (PinnedHeaderCache)header.getTag();
        if (cache == null) {
            cache = new PinnedHeaderCache();
            cache.titleView = (TextView)header.findViewById(16908308);
            cache.textColor = cache.titleView.getTextColors();
            cache.background = header.getBackground();
            header.setTag((Object)cache);
        }
        if ((section = this.getSectionForPosition(position)) != -1) {
            String title = (String)this.getSectionIndexer().getSections()[section];
            cache.titleView.setText((CharSequence)title);
            if (alpha == 255) {
                cache.titleView.setTextColor(cache.textColor);
            } else {
                int textColor = cache.textColor.getDefaultColor();
                cache.titleView.setTextColor(Color.argb((int)alpha, (int)Color.red((int)textColor), (int)Color.green((int)textColor), (int)Color.blue((int)textColor)));
            }
        }
    }

    protected void newSetTag(View view, ViewHolder holder, int position, List<Friend> data) {
        AsyncImageView photo = (AsyncImageView)view.findViewById(16908294);
        if (this.mViewList != null && !this.mViewList.contains(view)) {
            this.mViewList.add(view);
        }
        holder.name = (TextView)view.findViewById(16908308);
        holder.photo = photo;
    }

    public void destroy() {
        if (this.mViewList != null) {
            this.mViewList.clear();
            this.mViewList = null;
        }
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void onItemClick(String friendId, CheckBox checkBox) {
    }

    public static interface OnFilterFinished {
        public void onFilterFinished();
    }

    class FriendFilter
    extends PinyinFilterList<Friend> {
        public FriendFilter(List<Friend> dataList) {
            super(dataList);
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayList friends = (ArrayList)results.values;
            if (friends == null) {
                friends = new ArrayList();
            }
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            ArrayList result = new ArrayList();
            char key = '\u0000';
            for (Friend friend : friends) {
                key = friend.getSearchKey();
                if (hashMap.containsKey(key)) {
                    int position = (Integer)hashMap.get(key);
                    if (position > result.size() - 1) continue;
                    ((List)result.get(position)).add(friend);
                    continue;
                }
                result.add(new ArrayList());
                int length = result.size() - 1;
                ((List)result.get(length)).add(friend);
                hashMap.put(Integer.valueOf(key), length);
            }
            FriendListAdapter.this.updateCollection(result);
            if (result.size() > 0) {
                FriendListAdapter.this.notifyDataSetChanged();
            } else {
                FriendListAdapter.this.notifyDataSetInvalidated();
            }
        }
    }

    public static class ViewHolder {
        public TextView name;
        public AsyncImageView photo;
        public String userId;
        public Friend friend;
        public CheckBox choice;
    }

    class PinnedHeaderCache {
        TextView titleView;
        ColorStateList textColor;
        Drawable background;

        PinnedHeaderCache() {
        }
    }
}

