/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseAdapter;
import io.rong.imkit.adapter.ConversationListAdapter;
import io.rong.imkit.model.Friend;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;

public class ConversationMemberGridViewAdapter
extends BaseAdapter<Friend> {
    private boolean isAdd = false;
    private boolean isSub = false;
    private boolean isDeleteState = false;
    private OnGridViewImageListener mGridViewImageListener;
    private ConversationListAdapter.OnGetDataListener mOnGetDataListener;

    public void setOnGetDataListener(ConversationListAdapter.OnGetDataListener mOnGetDataListener) {
        this.mOnGetDataListener = mOnGetDataListener;
    }

    public ConversationMemberGridViewAdapter(Context context) {
        super(context);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        String userId;
        ViewHolder holder;
        if (convertView == null || convertView.getTag() == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(this.setItemLayoutRes(), null);
            holder = new ViewHolder();
            holder.deleteImageView = (ImageView)convertView.findViewById(16908295);
            holder.nameTextView = (TextView)convertView.findViewById(16908308);
            holder.portraitImageView = (AsyncImageView)convertView.findViewById(16908294);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
            holder.nameTextView.setText((CharSequence)"");
            holder.portraitImageView.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_portrait")));
            holder.portraitImageView.clean();
        }
        Friend friend = (Friend)this.dataSet.get(position);
        if (friend.isSub()) {
            holder.deleteImageView.setVisibility(8);
            holder.nameTextView.setVisibility(4);
            holder.portraitImageView.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_ic_setting_friends_delete")));
            holder.portraitImageView.clean();
        } else if (friend.isAdd()) {
            holder.nameTextView.setVisibility(4);
            holder.deleteImageView.setVisibility(8);
            holder.portraitImageView.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_ic_setting_friends_add")));
            holder.portraitImageView.clean();
        } else {
            RongIMClient.UserInfo userInfo;
            holder.nameTextView.setVisibility(0);
            holder.portraitImageView.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_portrait")));
            holder.portraitImageView.clean();
            if (this.isDeleteState) {
                userId = RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo().getUserId();
                if (!friend.getUserId().equals(userId)) {
                    holder.deleteImageView.setVisibility(0);
                }
            } else {
                holder.deleteImageView.setVisibility(8);
            }
            if (friend != null && TextUtils.isEmpty((CharSequence)friend.getNickname()) && RCloudContext.getInstance() != null && RCloudContext.getInstance().getUserInfoCache() != null && (userInfo = RCloudContext.getInstance().getUserInfoCache().get(friend.getUserId())) != null) {
                friend.setNickname(userInfo.getName());
                friend.setPortrait(userInfo.getPortraitUri());
            }
            if (!TextUtils.isEmpty((CharSequence)friend.getNickname())) {
                holder.portraitImageView.setResource(friend.getPortraitResource());
                holder.nameTextView.setText((CharSequence)friend.getNickname());
            } else {
                holder.portraitImageView.clean();
                holder.portraitImageView.setImageDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_portrait")));
            }
        }
        userId = friend.getUserId();
        final int aPosition = position;
        if (holder.deleteImageView.getVisibility() == 0) {
            holder.deleteImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ConversationMemberGridViewAdapter.this.mGridViewImageListener != null) {
                        v.setTag((Object)userId);
                        ConversationMemberGridViewAdapter.this.mGridViewImageListener.onGridViewImageClick(v, aPosition);
                    }
                }
            });
        }
        convertView.setTag(Res.getInstance(this.getContext()).drawable("rc_default_portrait"), (Object)friend);
        return convertView;
    }

    public int setItemLayoutRes() {
        return Res.getInstance(this.getContext()).layout("rc_item_conversation_member");
    }

    public void addAddButtonItem() {
        Friend friend = new Friend();
        friend.setAdd(true);
        friend.setCall(true);
        this.dataSet.add(friend);
        this.isAdd = true;
    }

    public void addSubButtonItem() {
        Friend friend = new Friend();
        friend.setSub(true);
        friend.setCall(true);
        this.dataSet.add(friend);
        this.isSub = true;
    }

    public void deleteToggle(boolean isDelete) {
        if (this.dataSet != null) {
            for (Friend friend : this.dataSet) {
                if (isDelete) {
                    String userId = "";
                    if (RCloudContext.getInstance() != null) {
                        userId = RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo().getUserId();
                    }
                    if (TextUtils.isEmpty((CharSequence)friend.getUserId()) || friend.getUserId().equals(userId)) continue;
                    friend.setDel(true);
                    this.isDeleteState = true;
                    continue;
                }
                friend.setDel(false);
                this.isDeleteState = false;
            }
        }
    }

    public void setGridViewImageListener(OnGridViewImageListener mGridViewImageListener) {
        this.mGridViewImageListener = mGridViewImageListener;
    }

    public boolean isDeleteState() {
        return this.isDeleteState;
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public void setAdd(boolean isAdd) {
        this.isAdd = isAdd;
    }

    public boolean isSub() {
        return this.isSub;
    }

    public void setSub(boolean isSub) {
        this.isSub = isSub;
    }

    public static interface OnGridViewImageListener {
        public void onGridViewImageClick(View var1, int var2);
    }

    class ViewHolder {
        AsyncImageView portraitImageView;
        ImageView deleteImageView;
        TextView nameTextView;
        RelativeLayout relativeLayout;

        ViewHolder() {
        }
    }
}

