/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseAdapter;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIGroup;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.RCDateUtils;
import io.rong.imkit.utils.Util;
import io.rong.imkit.view.AsyncImageView;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.util.Date;

public class ConversationListAdapter
extends BaseAdapter<UIConversation> {
    private OnGetDataListener mOnGetDataListener;
    private boolean mIsGroup = false;

    public ConversationListAdapter(Context context, boolean isGroup) {
        super(context);
        this.mIsGroup = isGroup;
    }

    public boolean isIsGroup() {
        return this.mIsGroup;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null || convertView.getTag() == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(Res.getInstance(this.mContext).layout("rc_item_conversationlist"), null);
            holder = new ViewHolder();
            holder.layout = convertView.findViewById(16908312);
            holder.icon = (AsyncImageView)convertView.findViewById(16908294);
            holder.message = (TextView)convertView.findViewById(Res.getInstance(this.mContext).id("rc_new_message"));
            holder.username = (TextView)convertView.findViewById(16908308);
            holder.time = (TextView)convertView.findViewById(16908309);
            holder.content = (TextView)convertView.findViewById(16908299);
            holder.icon.setDefaultDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_portrait")));
            holder.imageView = (ImageView)convertView.findViewById(Res.getInstance(this.mContext).id("message_block"));
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
            holder.icon.clean();
            holder.time.setText((CharSequence)"");
        }
        holder.username.setText((CharSequence)"");
        holder.content.setText((CharSequence)"");
        holder.content.setCompoundDrawables(null, null, null, null);
        UIConversation conversation = (UIConversation)this.dataSet.get(position);
        if (conversation != null) {
            UIGroup uiGroup;
            int unReadCont = conversation.getUnreadMessageCount();
            String moreMsgFlag = null;
            if (unReadCont > 0) {
                moreMsgFlag = unReadCont > 99 ? this.mContext.getResources().getString(Res.getInstance(this.mContext).string("new_message_more")) : String.valueOf(unReadCont);
                holder.message.setVisibility(0);
                holder.message.setText((CharSequence)moreMsgFlag);
            } else {
                holder.message.setVisibility(8);
            }
            if (conversation.isTop()) {
                holder.layout.setBackgroundColor(this.mContext.getResources().getColor(Res.getInstance(this.mContext).color("rc_list_item_istop_bg_color")));
            } else {
                holder.layout.setBackgroundColor(0);
            }
            if (conversation.getConversationType() == RongIMClient.ConversationType.PRIVATE || conversation.getConversationType() == RongIMClient.ConversationType.SYSTEM) {
                UIUserInfo userInfo = null;
                if (conversation.getUserInfo() == null || TextUtils.isEmpty((CharSequence)conversation.getUserInfo().getName()) || TextUtils.isEmpty((CharSequence)conversation.getConversationTitle())) {
                    userInfo = this.getUserInfoByCache(conversation.getTargetId());
                    conversation.setUserInfo(userInfo);
                } else {
                    userInfo = conversation.getUserInfo();
                }
                if (userInfo != null) {
                    holder.username.setText((CharSequence)userInfo.getName());
                    conversation.setConversationTitle(userInfo.getName());
                    if (userInfo.getPortraitResource() != null) {
                        holder.icon.setResource(userInfo.getPortraitResource());
                    } else {
                        holder.icon.clean();
                    }
                }
            } else if (conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
                RongIMClient.DiscussionNotificationMessage discussionNotificationMessage;
                holder.icon.setImageDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_default_discussion_portrait")));
                if (TextUtils.isEmpty((CharSequence)conversation.getConversationTitle()) || conversation.getUiDiscussion() == null) {
                    if (this.mOnGetDataListener != null) {
                        this.mOnGetDataListener.getDiscussionInfo(position, conversation.getTargetId());
                    }
                } else if (conversation.getUiDiscussion() != null && !TextUtils.isEmpty((CharSequence)conversation.getUiDiscussion().getName())) {
                    conversation.setConversationTitle(conversation.getUiDiscussion().getName());
                }
                if (!TextUtils.isEmpty((CharSequence)conversation.getConversationTitle())) {
                    holder.username.setText((CharSequence)conversation.getConversationTitle());
                } else {
                    holder.username.setText((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("default_discussion_name")));
                }
                if (conversation.getLatestMessage() instanceof RongIMClient.DiscussionNotificationMessage && (discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)conversation.getLatestMessage()).getType() == 3) {
                    holder.username.setText((CharSequence)discussionNotificationMessage.getExtension());
                }
                if (conversation.getLatestMessage() == null && conversation.getSentTime() == 0L) {
                    conversation.setSentTime(System.currentTimeMillis());
                }
            } else if (RongIMClient.ConversationType.GROUP == conversation.getConversationType()) {
                holder.icon.setImageDrawable(this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_group_default_portrait")));
                if (this.mIsGroup) {
                    uiGroup = conversation.getUiGroup();
                    if (uiGroup == null) {
                        uiGroup = this.getGroupInfoByCache(conversation.getTargetId());
                        conversation.setUiGroup(uiGroup);
                    }
                    if (uiGroup != null) {
                        holder.username.setText((CharSequence)uiGroup.getName());
                        if (uiGroup.getPortraitResource() != null) {
                            holder.icon.setResource(uiGroup.getPortraitResource());
                        } else {
                            holder.icon.clean();
                        }
                    }
                } else {
                    holder.username.setText((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("rc_group_conversation_list_name")));
                }
            } else {
                holder.username.setText((CharSequence)conversation.getTargetId());
            }
            if (conversation.getNotificationStatus() == RongIMClient.ConversationNotificationStatus.DO_NOT_DISTURB) {
                holder.imageView.setVisibility(0);
            } else {
                holder.imageView.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getDraft())) {
                SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_draft_content")));
                holder.content.append((CharSequence)spannable.append((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(conversation.getDraft())))));
            } else if (conversation.getLatestMessage() != null) {
                String userId;
                UIUserInfo uiUserInfo1;
                UIUserInfo uiUserInfo;
                if (TextUtils.isEmpty((CharSequence)conversation.getSenderUserName()) && (conversation.getConversationType() == RongIMClient.ConversationType.GROUP || conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) && (uiUserInfo = conversation.getUserInfo()) == null && (uiUserInfo1 = this.getUserInfoByCache(conversation.getSenderUserId())) != null) {
                    conversation.setUserInfo(uiUserInfo1);
                    conversation.setSenderUserName(uiUserInfo1.getName());
                }
                if (!this.mIsGroup && conversation.getConversationType() == RongIMClient.ConversationType.GROUP && (conversation.getUiGroup() == null || TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) && (uiGroup = conversation.getUiGroup()) == null) {
                    uiGroup = this.getGroupInfoByCache(conversation.getTargetId());
                    conversation.setUiGroup(uiGroup);
                }
                this.setContent(position, this.mIsGroup, holder, conversation);
                String string2 = userId = this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "";
                if (conversation.getSenderUserId() != null && conversation.getSenderUserId().equals(userId)) {
                    if (conversation.getSentStatus() != null && conversation.getSentStatus() == RongIMClient.SentStatus.FAILED) {
                        int width = (int)this.mContext.getResources().getDimension(Res.getInstance(this.mContext).dimen("px_to_dip_26"));
                        Drawable drawable2 = this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("rc_conversation_list_msg_send_failure"));
                        drawable2.setBounds(0, 0, width, width);
                        holder.content.setCompoundDrawables(drawable2, null, null, null);
                    } else if (conversation.getSentStatus() == RongIMClient.SentStatus.SENDING) {
                        int width = (int)this.mContext.getResources().getDimension(Res.getInstance(this.mContext).dimen("px_to_dip_26"));
                        Drawable drawable3 = this.mContext.getResources().getDrawable(Res.getInstance(this.mContext).drawable("conversation_list_msg_sending"));
                        drawable3.setBounds(0, 0, width, width);
                        holder.content.setCompoundDrawables(drawable3, null, null, null);
                    }
                }
            } else {
                holder.content.setCompoundDrawables(null, null, null, null);
                holder.content.setText((CharSequence)"");
            }
            if (conversation.getSentTime() > 0L) {
                String time = RCDateUtils.getConvastionListFromatDate(new Date(conversation.getSentTime()));
                holder.time.setText((CharSequence)time);
            } else {
                holder.time.setText((CharSequence)"");
            }
        }
        return convertView;
    }

    private final void setContent(int position, boolean isGroup, ViewHolder hodler, UIConversation conversation) {
        if (isGroup) {
            if (conversation.getConversationType() == RongIMClient.ConversationType.GROUP) {
                if (!TextUtils.isEmpty((CharSequence)conversation.getSenderUserName())) {
                    hodler.content.setText((CharSequence)this.getContent(position, conversation, false, isGroup));
                } else {
                    hodler.content.setText((CharSequence)this.getContent(position, conversation, true, isGroup));
                }
            } else {
                hodler.content.setText((CharSequence)this.getContent(position, conversation, true, isGroup));
            }
        } else if (conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
            if (!TextUtils.isEmpty((CharSequence)conversation.getSenderUserName())) {
                hodler.content.setText((CharSequence)this.getContent(position, conversation, false, isGroup));
            } else {
                hodler.content.setText((CharSequence)this.getContent(position, conversation, true, isGroup));
            }
        } else if (conversation.getConversationType() == RongIMClient.ConversationType.GROUP) {
            if (conversation.getUiGroup() != null && !TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) {
                hodler.content.setText((CharSequence)this.getContent(position, conversation, false, isGroup));
            } else {
                hodler.content.setText((CharSequence)this.getContent(position, conversation, true, isGroup));
            }
        } else {
            hodler.content.setText((CharSequence)this.getContent(position, conversation, true, isGroup));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SpannableStringBuilder getContent(int position, UIConversation conversation, boolean isDirect, boolean isGroup) {
        SpannableStringBuilder textContent = new SpannableStringBuilder();
        if (!isDirect) {
            if (!isGroup) {
                if (conversation.getConversationType() == RongIMClient.ConversationType.GROUP) {
                    if (conversation.getLatestMessage() instanceof TextMessage) {
                        if (conversation.getUiGroup() != null && !TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) {
                            textContent.append((CharSequence)conversation.getUiGroup().getName()).append((CharSequence)"\uff1a").append((CharSequence)conversation.getTextMessageContent());
                            return textContent;
                        } else {
                            textContent.append((CharSequence)conversation.getTextMessageContent());
                        }
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof ImageMessage) {
                        if (conversation.getUiGroup() == null || TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) return textContent;
                        textContent.append((CharSequence)conversation.getUiGroup().getName()).append((CharSequence)"\uff1a");
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
                        if (conversation.getUiGroup() == null || TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) return textContent;
                        textContent.append((CharSequence)conversation.getUiGroup().getName()).append((CharSequence)"\uff1a");
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_voice_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
                        if (conversation.getUiGroup() == null || TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) return textContent;
                        textContent.append((CharSequence)conversation.getUiGroup().getName()).append((CharSequence)"\uff1a");
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_text_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof LocationMessage) {
                        if (conversation.getUiGroup() == null || TextUtils.isEmpty((CharSequence)conversation.getUiGroup().getName())) return textContent;
                        textContent.append((CharSequence)conversation.getUiGroup().getName()).append((CharSequence)"\uff1a");
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_location_content")));
                        return textContent;
                    } else {
                        InformationNotificationMessage informationNotificationMessage;
                        if (!(conversation.getLatestMessage() instanceof InformationNotificationMessage) || (informationNotificationMessage = (InformationNotificationMessage)conversation.getLatestMessage()) == null || TextUtils.isEmpty((CharSequence)informationNotificationMessage.getMessage())) return textContent;
                        textContent.append((CharSequence)Html.fromHtml((String)informationNotificationMessage.getMessage()).toString());
                    }
                    return textContent;
                } else if (conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
                    if (conversation.getLatestMessage() instanceof TextMessage) {
                        if (TextUtils.isEmpty((CharSequence)conversation.getSenderUserName())) {
                            textContent.append((CharSequence)conversation.getTextMessageContent());
                            return textContent;
                        } else {
                            textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a").append((CharSequence)conversation.getTextMessageContent());
                        }
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof ImageMessage) {
                        if (conversation.getSenderUserName() != null) {
                            textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                        }
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
                        if (conversation.getSenderUserName() != null) {
                            textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                        }
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_voice_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
                        if (conversation.getSenderUserName() != null) {
                            textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                        }
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_text_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof LocationMessage) {
                        if (conversation.getSenderUserName() != null) {
                            textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                        }
                        textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_location_content")));
                        return textContent;
                    } else if (conversation.getLatestMessage() instanceof RongIMClient.DiscussionNotificationMessage) {
                        RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)conversation.getLatestMessage();
                        String selfUserId = this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "";
                        String[] userIds = null;
                        String operator = discussionNotificationMessage.getOperator();
                        if (!TextUtils.isEmpty((CharSequence)discussionNotificationMessage.getExtension())) {
                            userIds = discussionNotificationMessage.getExtension().indexOf(",") != -1 ? discussionNotificationMessage.getExtension().split(",") : new String[]{discussionNotificationMessage.getExtension()};
                        }
                        switch (discussionNotificationMessage.getType()) {
                            case 1: {
                                if (operator.equals(selfUserId)) {
                                    if (userIds == null) return textContent;
                                    if (userIds.length > 1) {
                                        String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_add"));
                                        textContent.append((CharSequence)String.format(formatString, "\u4f60", userIds.length));
                                        return textContent;
                                    }
                                    if (userIds.length != 1) return textContent;
                                    if (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName())) {
                                        conversation.setOperatored(this.getUserInfoByCache(userIds[0]));
                                    }
                                    if (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName())) return textContent;
                                    String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_added"));
                                    textContent.append((CharSequence)String.format(formatString, "\u4f60", conversation.getOperatored().getName()));
                                    return textContent;
                                }
                                if (userIds == null) return textContent;
                                if (!operator.equals(selfUserId) && (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName()))) {
                                    conversation.setOperator(this.getUserInfoByCache(userIds[0]));
                                }
                                if (userIds.length == 1) {
                                    if (!userIds[0].equals(selfUserId) && (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName()))) {
                                        conversation.setOperatored(this.getUserInfoByCache(userIds[0]));
                                    }
                                    if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) return textContent;
                                    String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_added"));
                                    if (userIds[0].equals(selfUserId)) {
                                        textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), "\u4f60"));
                                        return textContent;
                                    }
                                    if (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName())) return textContent;
                                    textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), conversation.getOperatored().getName()));
                                    return textContent;
                                }
                                if (operator.equals(selfUserId)) {
                                    String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_add"));
                                    textContent.append((CharSequence)String.format(formatString, "\u4f60", userIds.length));
                                    return textContent;
                                }
                                if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) return textContent;
                                String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_add"));
                                textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), userIds.length));
                                return textContent;
                            }
                            case 2: {
                                if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) {
                                    conversation.setOperator(this.getUserInfoByCache(userIds[0]));
                                }
                                if (userIds == null || conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) return textContent;
                                String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_exit"));
                                textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName()));
                                return textContent;
                            }
                            case 3: {
                                String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_rename"));
                                if (TextUtils.isEmpty((CharSequence)discussionNotificationMessage.getExtension())) return textContent;
                                if (operator.equals(selfUserId)) {
                                    textContent.append((CharSequence)String.format(formatString, "\u4f60", discussionNotificationMessage.getExtension()));
                                } else {
                                    if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) {
                                        conversation.setOperator(this.getUserInfoByCache(operator));
                                    }
                                    if (conversation.getOperator() != null && !TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) {
                                        textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), discussionNotificationMessage.getExtension()));
                                    }
                                }
                                conversation.setConversationTitle(discussionNotificationMessage.getExtension());
                                return textContent;
                            }
                            case 4: {
                                if (userIds == null) return textContent;
                                String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_who_removed"));
                                if (!operator.equals(selfUserId) && (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName()))) {
                                    conversation.setOperator(this.getUserInfoByCache(operator));
                                }
                                if (!userIds[0].equals(selfUserId) && (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName()))) {
                                    conversation.setOperatored(this.getUserInfoByCache(userIds[0]));
                                }
                                if (operator.equals(selfUserId)) {
                                    if (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName())) return textContent;
                                    textContent.append((CharSequence)String.format(formatString, conversation.getOperatored().getName(), "\u4f60"));
                                    return textContent;
                                }
                                if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) return textContent;
                                if (userIds[0].equals(selfUserId)) {
                                    textContent.append((CharSequence)String.format(formatString, "\u4f60", conversation.getOperator().getName()));
                                    return textContent;
                                }
                                if (conversation.getOperatored() == null || TextUtils.isEmpty((CharSequence)conversation.getOperatored().getName())) return textContent;
                                textContent.append((CharSequence)String.format(formatString, conversation.getOperatored().getName(), conversation.getOperator().getName()));
                                return textContent;
                            }
                            case 5: {
                                String formatString = this.mContext.getResources().getString(Res.getInstance(this.mContext).string("notification_message_discussion_is_open_invite"));
                                if (operator.equals(selfUserId)) {
                                    if (TextUtils.isEmpty((CharSequence)discussionNotificationMessage.getExtension())) return textContent;
                                    if (discussionNotificationMessage.getExtension().equals("1")) {
                                        textContent.append((CharSequence)String.format(formatString, "\u4f60", "\u5173\u95ed"));
                                        return textContent;
                                    }
                                    if (!discussionNotificationMessage.getExtension().equals("0")) return textContent;
                                    textContent.append((CharSequence)String.format(formatString, "\u4f60", "\u5f00\u653e"));
                                    return textContent;
                                }
                                if (conversation.getOperator() == null || TextUtils.isEmpty((CharSequence)conversation.getOperator().getName())) {
                                    conversation.setOperator(this.getUserInfoByCache(operator));
                                }
                                if (TextUtils.isEmpty((CharSequence)discussionNotificationMessage.getExtension())) return textContent;
                                if (discussionNotificationMessage.getExtension().equals("1")) {
                                    textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), "\u5173\u95ed"));
                                    return textContent;
                                }
                                if (!discussionNotificationMessage.getExtension().equals("0")) return textContent;
                                textContent.append((CharSequence)String.format(formatString, conversation.getOperator().getName(), "\u5f00\u653e"));
                                return textContent;
                            }
                        }
                        return textContent;
                    } else {
                        InformationNotificationMessage informationNotificationMessage;
                        if (!(conversation.getLatestMessage() instanceof InformationNotificationMessage) || (informationNotificationMessage = (InformationNotificationMessage)conversation.getLatestMessage()) == null || TextUtils.isEmpty((CharSequence)informationNotificationMessage.getMessage())) return textContent;
                        textContent.append((CharSequence)Html.fromHtml((String)informationNotificationMessage.getMessage()).toString());
                    }
                    return textContent;
                } else if (conversation.getLatestMessage() instanceof TextMessage) {
                    textContent.append((CharSequence)conversation.getTextMessageContent());
                    return textContent;
                } else if (conversation.getLatestMessage() instanceof ImageMessage) {
                    textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_content")));
                    return textContent;
                } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
                    textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_voice_content")));
                    return textContent;
                } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
                    textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_text_content")));
                    return textContent;
                } else if (conversation.getLatestMessage() instanceof LocationMessage) {
                    textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_location_content")));
                    return textContent;
                } else {
                    InformationNotificationMessage informationNotificationMessage;
                    if (!(conversation.getLatestMessage() instanceof InformationNotificationMessage) || (informationNotificationMessage = (InformationNotificationMessage)conversation.getLatestMessage()) == null || TextUtils.isEmpty((CharSequence)informationNotificationMessage.getMessage())) return textContent;
                    textContent.append((CharSequence)Html.fromHtml((String)informationNotificationMessage.getMessage()).toString());
                }
                return textContent;
            } else if (conversation.getLatestMessage() instanceof TextMessage) {
                if (TextUtils.isEmpty((CharSequence)conversation.getSenderUserName())) {
                    textContent.append((CharSequence)conversation.getTextMessageContent());
                    return textContent;
                } else {
                    textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a").append((CharSequence)conversation.getTextMessageContent());
                }
                return textContent;
            } else if (conversation.getLatestMessage() instanceof ImageMessage) {
                if (conversation.getSenderUserName() != null) {
                    textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                }
                textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_content")));
                return textContent;
            } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
                if (conversation.getSenderUserName() != null) {
                    textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                }
                textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_voice_content")));
                return textContent;
            } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
                if (conversation.getSenderUserName() != null) {
                    textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                }
                textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_text_content")));
                return textContent;
            } else if (conversation.getLatestMessage() instanceof LocationMessage) {
                if (conversation.getSenderUserName() != null) {
                    textContent.append((CharSequence)conversation.getSenderUserName()).append((CharSequence)"\uff1a");
                }
                textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_location_content")));
                return textContent;
            } else {
                InformationNotificationMessage informationNotificationMessage;
                if (!(conversation.getLatestMessage() instanceof InformationNotificationMessage) || (informationNotificationMessage = (InformationNotificationMessage)conversation.getLatestMessage()) == null || TextUtils.isEmpty((CharSequence)informationNotificationMessage.getMessage())) return textContent;
                textContent.append((CharSequence)Html.fromHtml((String)informationNotificationMessage.getMessage()).toString());
            }
            return textContent;
        } else if (conversation.getLatestMessage() instanceof TextMessage) {
            textContent.append((CharSequence)conversation.getTextMessageContent());
            return textContent;
        } else if (conversation.getLatestMessage() instanceof ImageMessage) {
            textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_content")));
            return textContent;
        } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
            textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_voice_content")));
            return textContent;
        } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
            textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_image_text_content")));
            return textContent;
        } else if (conversation.getLatestMessage() instanceof LocationMessage) {
            textContent.append((CharSequence)this.mContext.getResources().getString(Res.getInstance(this.mContext).string("message_type_location_content")));
            return textContent;
        } else {
            InformationNotificationMessage informationNotificationMessage;
            if (!(conversation.getLatestMessage() instanceof InformationNotificationMessage) || (informationNotificationMessage = (InformationNotificationMessage)conversation.getLatestMessage()) == null || TextUtils.isEmpty((CharSequence)informationNotificationMessage.getMessage())) return textContent;
            textContent.append((CharSequence)Html.fromHtml((String)informationNotificationMessage.getMessage()).toString());
        }
        return textContent;
    }

    public void setOnGetDataListener(OnGetDataListener mOnGetDataListener) {
        this.mOnGetDataListener = mOnGetDataListener;
    }

    private final UIUserInfo getUserInfoByCache(String userId) {
        RongIMClient.UserInfo userInfo;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getUserInfoCache() != null && (userInfo = RCloudContext.getInstance().getUserInfoCache().get(userId)) != null) {
            return new UIUserInfo(userInfo.getUserId(), userInfo.getName(), userInfo.getPortraitUri());
        }
        return null;
    }

    private final UIGroup getGroupInfoByCache(String groupId) {
        RongIMClient.Group group;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getGroupCache() != null && (group = RCloudContext.getInstance().getGroupCache().get(groupId)) != null) {
            return new UIGroup(group.getId(), group.getName(), group.getPortraitUri());
        }
        return null;
    }

    public static interface OnGetDataListener {
        public void getDiscussionInfo(int var1, String var2);
    }

    class ViewHolder {
        View layout;
        AsyncImageView icon;
        TextView message;
        TextView username;
        TextView time;
        TextView content;
        ImageView imageView;

        ViewHolder() {
        }
    }
}

