/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.IViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imlib.RongIMClient;
import java.util.List;

public abstract class BaseViewProvider
implements IViewProvider {
    protected MessageContext mContext;
    protected View mConvertView;
    protected OnGetDataListener mOnGetDataListener;
    public OnMessageItemClickListener mOnMessageItemClickListener;

    public BaseViewProvider(MessageContext context) {
        this.mContext = context;
    }

    @Override
    public View getItemView(View convertView, LayoutInflater inflater, RCloudType data, int position, List datas) {
        ViewHolder holder;
        if (convertView == null) {
            this.mConvertView = convertView = inflater.inflate(this.setItemLayoutRes(), null);
            holder = new ViewHolder();
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        return this.getItemView(convertView, holder, data, position, datas);
    }

    @Override
    public View getConvertView() {
        if (this.mConvertView == null) {
            this.mConvertView = LayoutInflater.from((Context)this.mContext).inflate(this.setItemLayoutRes(), null);
        }
        return this.mConvertView;
    }

    protected abstract int setItemLayoutRes();

    protected abstract View getItemView(View var1, ViewHolder var2, RCloudType var3, int var4, List var5);

    public void setOnMessageItemClickListener(OnMessageItemClickListener listener) {
        this.mOnMessageItemClickListener = listener;
    }

    protected RongIMClient.UserInfo onPortraitClick(RongIMClient.Message message, UIUserInfo uiUserInfo) {
        RongIMClient.UserInfo user = null;
        if (uiUserInfo != null) {
            user = new RongIMClient.UserInfo(uiUserInfo.getUserId(), uiUserInfo.getName(), uiUserInfo.getPortraitUri());
        }
        if (RCloudContext.getInstance().getConversationBehaviorListener() != null) {
            RCloudContext.getInstance().getConversationBehaviorListener().onClickUserPortrait((Context)this.mContext, message.getConversationType(), user);
        }
        return user;
    }

    protected RongIMClient.UserInfo onPortraitClick(RongIMClient.Message message, RongIMClient.UserInfo userInfo) {
        if (RCloudContext.getInstance().getConversationBehaviorListener() != null && userInfo != null) {
            RCloudContext.getInstance().getConversationBehaviorListener().onClickUserPortrait((Context)this.mContext, message.getConversationType(), userInfo);
        }
        return userInfo;
    }

    protected RongIMClient.UserInfo onPortraitClick(RongIMClient.Message message, String userId) {
        RongIMClient.UserInfo user = new RongIMClient.UserInfo(userId, null, null);
        if (RCloudContext.getInstance().getConversationBehaviorListener() != null) {
            RCloudContext.getInstance().getConversationBehaviorListener().onClickUserPortrait((Context)this.mContext, message.getConversationType(), user);
        }
        return user;
    }

    protected boolean onMessageClick(RongIMClient.Message message) {
        if (RCloudContext.getInstance().getConversationBehaviorListener() != null) {
            return RCloudContext.getInstance().getConversationBehaviorListener().onClickMessage((Context)this.mContext, message);
        }
        return false;
    }

    public void setOnGetDataListener(OnGetDataListener mOnGetDataListener) {
        this.mOnGetDataListener = mOnGetDataListener;
    }

    protected final UIUserInfo getUserInfoByCache(String userId) {
        RongIMClient.UserInfo userInfo;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getUserInfoCache() != null && (userInfo = RCloudContext.getInstance().getUserInfoCache().get(userId)) != null) {
            return new UIUserInfo(userInfo.getUserId(), userInfo.getName(), userInfo.getPortraitUri());
        }
        return null;
    }

    public static interface OnGetDataListener {
        public void getDiscussionInfo(int var1, String var2);
    }

    public static interface OnMessageItemClickListener {
        public void onMessageClick(UIMessage var1, View var2);

        public void onMessageLongClick(UIMessage var1);

        public void onMessageDoubleClick(UIMessage var1);

        public void onResendMessage(UIMessage var1, int var2);
    }

    protected class ViewHolder {
        private SparseArray<View> views = new SparseArray();

        protected ViewHolder() {
        }

        public <E extends View> E obtainView(View convertView, int resId) {
            View v = (View)this.views.get(resId);
            if (null == v) {
                v = convertView.findViewById(resId);
                this.views.put(resId, (Object)v);
            }
            return (E)v;
        }

        public <E extends View> E obtainView(View convertView, String resIdstr) {
            int resId = Res.getInstance((Context)BaseViewProvider.this.mContext).id(resIdstr);
            View v = (View)this.views.get(resId);
            if (null == v) {
                v = convertView.findViewById(resId);
                this.views.put(resId, (Object)v);
            }
            return (E)v;
        }
    }
}

