/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseAdapter;
import java.util.List;

public abstract class BaseUIAdapter<T>
extends BaseAdapter<T> {
    public BaseUIAdapter(Context context) {
        super(context);
    }

    public BaseUIAdapter(Context context, List<T> data) {
        super(context, data);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(this.setItemLayoutRes(), null);
            holder = new ViewHolder();
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        return this.getView(position, convertView, parent, holder);
    }

    public abstract View getView(int var1, View var2, ViewGroup var3, ViewHolder var4);

    public abstract int setItemLayoutRes();

    protected class ViewHolder {
        private SparseArray<View> views = new SparseArray();

        protected ViewHolder() {
        }

        public <E extends View> E obtainView(View convertView, int resId) {
            View v = (View)this.views.get(resId);
            if (null == v) {
                v = convertView.findViewById(resId);
                this.views.put(resId, (Object)v);
            }
            return (E)v;
        }

        public <E extends View> E obtainView(View convertView, String resIdstr) {
            int resId = Res.getInstance(BaseUIAdapter.this.mContext).id(resIdstr);
            View v = (View)this.views.get(resId);
            if (null == v) {
                v = convertView.findViewById(resId);
                this.views.put(resId, (Object)v);
            }
            return (E)v;
        }
    }
}

