/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.adapter;

import android.content.Context;
import android.os.Handler;
import android.view.ViewGroup;
import android.widget.ListView;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseAdapter<T>
extends android.widget.BaseAdapter {
    protected List<T> dataSet;
    protected Handler handler = new Handler();
    protected Context mContext;
    private ListView mListView;

    public BaseAdapter(Context context) {
        this(context, new ArrayList());
    }

    public BaseAdapter(Context context, List<T> data) {
        this.mContext = context;
        this.dataSet = data;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void addData(T data) {
        this.dataSet.add(data);
    }

    public void addData(Collection<T> data) {
        this.dataSet.addAll(data);
    }

    public void addData(int index, Collection<T> data) {
        this.dataSet.addAll(index, data);
    }

    public void removeData(Collection<T> data) {
        this.dataSet.removeAll(data);
    }

    public void removeAll() {
        if (this.dataSet != null) {
            this.dataSet.clear();
        }
    }

    public void remove(T data) {
        this.dataSet.remove(data);
    }

    public void remove(int position) {
        this.dataSet.remove(position);
    }

    public List<T> subData(int index, int count) {
        return this.dataSet.subList(index, index + count);
    }

    public int getCount() {
        return this.dataSet.size();
    }

    public long getItemId(int position) {
        return 0L;
    }

    public T getItem(int position) {
        return this.dataSet.get(position);
    }

    public void setItem(int position, T obj) {
        this.dataSet.set(position, obj);
    }

    public void addItem(int position, T obj) {
        this.dataSet.add(position, obj);
    }

    public void addItems(int position, Collection<T> data) {
        this.dataSet.addAll(position, data);
    }

    public UIUserInfo getUserInfo(String userId) {
        RongIMClient.UserInfo userInfo;
        if (RCloudContext.getInstance().getGetUserInfoProvider() != null && (userInfo = RCloudContext.getInstance().getGetUserInfoProvider().getUserInfo(userId)) != null) {
            return new UIUserInfo(userInfo);
        }
        return null;
    }

    public void setListView(ListView listView) {
        this.mListView = listView;
    }

    public void notifyDataSetChanged(int position) {
        if (this.mListView != null) {
            int firstVisiblePosition = this.mListView.getFirstVisiblePosition();
            int lastVisiblePosition = this.mListView.getLastVisiblePosition();
            if (position >= firstVisiblePosition && position <= lastVisiblePosition) {
                this.getView(position, this.mListView.getChildAt(position - firstVisiblePosition), (ViewGroup)this.mListView);
            }
        }
    }

    protected RongIMClient.UserInfo getCurrentUserInfo() {
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null && RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo() != null) {
            return RCloudContext.getInstance().getRongIMClient().getCurrentUserInfo();
        }
        return null;
    }
}

