/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.logic.MessageLogic;
import io.rong.imkit.utils.Util;
import io.rong.imlib.AnnotationNotFoundException;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.RongVersionDatabase;
import io.rong.imlib.notification.RongNotificationManager;
import io.rong.imlib.push.PushContext;
import io.rong.message.HandshakeMessage;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.SuspendMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.io.File;
import java.util.List;

public class RongIM {
    private static final String TAG = RongIM.class.getSimpleName();
    private static RongIM rongIM;
    private static Context mContext;
    private static RongIMClient mRrongIMClient;
    private ConnectionStatusListener mConnectionStatusListener;
    private static String mCurrentProcessName;
    private static String mMainProcessName;
    private static ConnectionStatusListener.ConnectionStatus mCurrentStatus;
    private static SharedPreferences mPreferences;
    private static Handler mHandler;

    private RongIM() {
        mHandler = new Handler(Looper.getMainLooper());
    }

    private static void saveToken(String token) {
        if (mPreferences == null && mContext != null) {
            mPreferences = mContext.getSharedPreferences("RONG_SDK", 0);
        }
        if (mPreferences != null) {
            SharedPreferences.Editor editor = mPreferences.edit();
            editor.putString("token_value", token);
            editor.commit();
        }
    }

    static String getLastToken() {
        if (mPreferences == null && mContext != null) {
            mPreferences = mContext.getSharedPreferences("RONG_SDK", 0);
        }
        if (mPreferences != null) {
            return mPreferences.getString("token_value", null);
        }
        return "";
    }

    private static void saveAppKey(String appkey) {
        if (mPreferences == null && mContext != null) {
            mPreferences = mContext.getSharedPreferences("RONG_SDK", 0);
        }
        if (mPreferences != null) {
            SharedPreferences.Editor editor = mPreferences.edit();
            editor.putString("app_key", appkey);
            editor.commit();
        }
    }

    static String getAppKey() {
        if (mPreferences == null) {
            mPreferences = mContext.getSharedPreferences("RONG_SDK", 0);
        }
        if (mPreferences != null) {
            return mPreferences.getString("app_key", null);
        }
        return "";
    }

    public static void init(Context context) {
        if (mCurrentProcessName == null) {
            mCurrentProcessName = Util.getCurProcessName(context);
        }
        if (mMainProcessName == null) {
            mMainProcessName = context.getPackageName();
        }
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(context.getPackageName())) {
            if (PushContext.getInstance() == null) {
                PushContext.init(context);
                RongVersionDatabase.init(context);
                RongNotificationManager.init(context);
            }
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException();
        }
        mContext = context.getApplicationContext();
        RongIMClient.init(context);
        RCloudContext.init(mContext);
        try {
            RongIMClient.registerMessageType(LocationMessage.class);
            RongIMClient.registerMessageType(HandshakeMessage.class);
            RongIMClient.registerMessageType(SuspendMessage.class);
            RongIMClient.registerMessageType(RichContentMessage.class);
            RongIMClient.registerMessageType(InformationNotificationMessage.class);
            RongIMClient.registerMessageType(Class.forName("io.rong.voipkit.message.VoIPCallMessage"));
            RongIMClient.registerMessageType(Class.forName("io.rong.voipkit.message.VoIPAcceptMessage"));
            RongIMClient.registerMessageType(Class.forName("io.rong.voipkit.message.VoIPFinishMessage"));
        }
        catch (AnnotationNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static RongIM connect(String token, final RongIMClient.ConnectCallback callback) throws Exception {
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException();
        }
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            callback.onError(RongIMClient.ConnectCallback.ErrorCode.UNKNOWN);
            return null;
        }
        RongIM.saveToken(token);
        rongIM = new RongIM();
        mRrongIMClient = RongIMClient.connect(token, new RongIMClient.ConnectCallback(){

            @Override
            public void onSuccess(final String userId) {
                if (RCloudContext.getInstance() != null) {
                    RCloudContext.getInstance().initService();
                    RCloudContext.getInstance().setCurrentUserId(userId);
                }
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(userId);
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.ConnectCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(errorCode);
                        }
                    });
                }
            }
        });
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setRongIMClient(mRrongIMClient);
        }
        return rongIM;
    }

    public ConnectionStatusListener.ConnectionStatus getCurrentConnectionStatus() {
        if (RCloudContext.getInstance() == null) {
            throw new IllegalArgumentException();
        }
        return ConnectionStatusListener.ConnectionStatus.setValue(RCloudContext.getInstance().getCurrentConnStatus());
    }

    public void disconnect(boolean isReceivePush) {
        if (RCloudContext.getInstance() == null || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.disconnect(isReceivePush);
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().logout();
        }
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public static RongIM getInstance() {
        return rongIM;
    }

    public void startConversationList(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversationlist").build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public static void setConversationBehaviorListener(ConversationBehaviorListener listener) {
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            return;
        }
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setConversationBehaviorListener(listener);
        }
    }

    public static void registerMessageType(Class<? extends RongIMClient.MessageContent> type) throws AnnotationNotFoundException {
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            return;
        }
        RongIMClient.registerMessageType(type);
    }

    public void createDiscussionChat(Context context, List<String> targetUserIds, String title) {
        if (context == null || targetUserIds == null || targetUserIds.size() == 0) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.DISCUSSION.getName().toLowerCase()).appendQueryParameter("targetIds", TextUtils.join((CharSequence)",", targetUserIds)).appendQueryParameter("delimiter", ",").appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startConversation(Context context, RongIMClient.ConversationType conversationType, String targetId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(conversationType.getName().toLowerCase()).appendQueryParameter("targetId", targetId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startPrivateChat(Context context, String targetUserId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetUserId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.PRIVATE.getName().toLowerCase()).appendQueryParameter("targetId", targetUserId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startChatroom(Context context, String chatroomId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)chatroomId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.CHATROOM.getName().toLowerCase()).appendQueryParameter("targetId", chatroomId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startDiscussionChat(Context context, String targetDiscussionId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetDiscussionId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.DISCUSSION.getName().toLowerCase()).appendQueryParameter("targetId", targetDiscussionId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startGroupChat(Context context, String targetGroupId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetGroupId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.GROUP.getName().toLowerCase()).appendQueryParameter("targetId", targetGroupId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startConversationSetting(Context context, RongIMClient.ConversationType conversationType, String targetId) {
        if (context == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversationsetting").appendPath(conversationType.getName().toLowerCase()).appendQueryParameter("targetId", targetId).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void startCustomerServiceChat(Context context, String customerServiceUserId, String title) {
        if (context == null || TextUtils.isEmpty((CharSequence)customerServiceUserId)) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.CUSTOMER_SERVICE.getName().toLowerCase()).appendQueryParameter("targetId", customerServiceUserId).appendQueryParameter("title", title).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
        this.sendMessage(RongIMClient.ConversationType.CUSTOMER_SERVICE, customerServiceUserId, new HandshakeMessage(), null);
    }

    public RongIMClient.Message sendMessage(RongIMClient.ConversationType conversationType, String targetId, RongIMClient.MessageContent content, final RongIMClient.SendMessageCallback callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        RongIMClient.Message message = mRrongIMClient.sendMessage(conversationType, targetId, content, new RongIMClient.SendMessageCallback(){

            @Override
            public void onSuccess(int messageId) {
                if (mContext != null) {
                    Util.initBroadcastPackage(mContext.getPackageName());
                    mContext.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION));
                    mContext.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
                }
                if (callback != null) {
                    callback.onSuccess(messageId);
                }
            }

            @Override
            public void onError(int messageId, RongIMClient.SendMessageCallback.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(messageId, errorCode);
                }
            }

            @Override
            public void onProgress(int messageId, int percent) {
                if (callback != null) {
                    callback.onProgress(messageId, percent);
                }
            }
        });
        return message;
    }

    public RongIMClient.Message sendTextMessage(RongIMClient.ConversationType conversationType, String targetId, String text, RongIMClient.SendMessageCallback callback) {
        TextMessage content = TextMessage.obtain(text);
        return this.sendMessage(conversationType, targetId, content, callback);
    }

    public RongIMClient.Message sendImageMessage(RongIMClient.ConversationType conversationType, String targetId, String path, RongIMClient.SendMessageCallback callback) {
        Uri uri = Uri.fromFile((File)new File(path));
        ImageMessage content = ImageMessage.obtain(uri, uri);
        return this.sendMessage(conversationType, targetId, content, callback);
    }

    public RongIMClient.Message sendVoiceMessage(RongIMClient.ConversationType conversationType, String targetId, String path, int duration, RongIMClient.SendMessageCallback callback) {
        VoiceMessage content = VoiceMessage.obtain(Uri.fromFile((File)new File(path)), duration);
        return this.sendMessage(conversationType, targetId, content, callback);
    }

    public RongIMClient.Message sendRichContentMessage(RongIMClient.ConversationType conversationType, String targetId, String title, String description, Uri imageUri, RongIMClient.SendMessageCallback callback) {
        RichContentMessage content = RichContentMessage.obtain(title, description, imageUri.toString());
        return this.sendMessage(conversationType, targetId, content, callback);
    }

    public RongIMClient.Message sendLocationMessage(RongIMClient.ConversationType conversationType, String targetId, double latitude, double longitude, String poi, Uri imageUri, RongIMClient.SendMessageCallback callback) {
        LocationMessage content = LocationMessage.obtain(latitude, longitude, poi, imageUri);
        return this.sendMessage(conversationType, targetId, content, callback);
    }

    public List<RongIMClient.Conversation> getConversationList() {
        if (mRrongIMClient == null) {
            throw new RuntimeException("RongIM not init or not connect");
        }
        return mRrongIMClient.getConversationList();
    }

    public int getTotalUnreadCount() {
        if (mRrongIMClient == null) {
            throw new RuntimeException("RongIM not init or not connect");
        }
        return mRrongIMClient.getTotalUnreadCount();
    }

    public int getUnreadCount(RongIMClient.ConversationType conversationType, String targetId) {
        if (TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)targetId.trim()) || conversationType == null || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        return mRrongIMClient.getUnreadCount(conversationType, targetId);
    }

    private void refreshUserInfo(RongIMClient.UserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException();
        }
    }

    public void syncGroup(List<RongIMClient.Group> groups, final OperationCallback callback) {
        if (groups == null || groups.size() == 0 || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.syncGroup(groups, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void joinGroup(String groupId, String groupName, final OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupId) || TextUtils.isEmpty((CharSequence)groupName) || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.joinGroup(groupId, groupName, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void quitGroup(String groupId, final OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupId) || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.quitGroup(groupId, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public void joinChatRoom(String id2, int defMessageCount, final OperationCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)id2) || defMessageCount < 0) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.joinChatRoom(id2, defMessageCount, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public void quitChatRoom(String id2, final OperationCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalArgumentException();
        }
        mRrongIMClient.quitChatRoom(id2, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public static void setGetUserInfoProvider(GetUserInfoProvider provider, boolean cacheUserInfo) {
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            return;
        }
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setGetUserInfoProvider(provider);
        }
    }

    public static void setGetFriendsProvider(GetFriendsProvider provider) {
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            return;
        }
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setGetFriendsProvider(provider);
        }
    }

    public static void setGetGroupInfoProvider(GetGroupInfoProvider provider) {
        if (mCurrentProcessName != null && !mCurrentProcessName.equals(mMainProcessName)) {
            Log.e((String)"RONG_SDK", (String)"Rong SDK should not be initialized at subprocess");
            return;
        }
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setGetGroupInfoProvider(provider);
        }
    }

    public static void setLocationProvider(LocationProvider locationProvider) {
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setLocationProvider(locationProvider);
        }
    }

    public void setReceiveMessageListener(OnReceiveMessageListener listener) {
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setReceiveMessageListener(listener);
        }
    }

    public void setConnectionStatusListener(ConnectionStatusListener listener) {
        if (this.mConnectionStatusListener != null && RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().unRegConnectionStatusListener(this.mConnectionStatusListener);
        }
        if (RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().regConnectionStatusListener(listener);
        }
        this.mConnectionStatusListener = listener;
    }

    public boolean removeConversation(Context context, RongIMClient.ConversationType conversationType, String targetId) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || context == null || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        boolean isRemove = mRrongIMClient.removeConversation(conversationType, targetId);
        if (context != null) {
            Util.initBroadcastPackage(context.getPackageName());
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION));
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST));
        }
        return isRemove;
    }

    public boolean clearMessages(Context context, RongIMClient.ConversationType conversationType, String targetId) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || context == null || mRrongIMClient == null) {
            throw new IllegalArgumentException();
        }
        boolean isClear = mRrongIMClient.clearMessages(conversationType, targetId);
        if (context != null) {
            Util.initBroadcastPackage(context.getPackageName());
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION));
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
            context.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST));
        }
        return isClear;
    }

    public void setConversationNotificationStatus(RongIMClient.ConversationType conversationType, String targetId, RongIMClient.ConversationNotificationStatus notificationStatus, RongIMClient.SetConversationNotificationStatusCallback callback) {
        if (conversationType == null || notificationStatus == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null || mRrongIMClient == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.setConversationNotificationStatus(conversationType, targetId, notificationStatus, callback);
    }

    public void getConversationNotificationStatus(RongIMClient.ConversationType conversationType, String targetId, RongIMClient.GetConversationNotificationStatusCallback callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null || mRrongIMClient == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.getConversationNotificationStatus(conversationType, targetId, callback);
    }

    public boolean clearConversations(RongIMClient.ConversationType ... conversationTypes) {
        if (conversationTypes == null || mRrongIMClient == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return mRrongIMClient.clearConversations(conversationTypes);
    }

    public void addToBlacklist(String userId, final OperationCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.addToBlacklist(userId, new RongIMClient.AddToBlackCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.AddToBlackCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void removeFromBlacklist(String userId, final OperationCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.removeFromBlacklist(userId, new RongIMClient.RemoveFromBlacklistCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.RemoveFromBlacklistCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void getBlacklistStatus(String userId, final GetUserBlacklistCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.getBlacklistStatus(userId, new RongIMClient.GetUserBlacklistCallback(){

            @Override
            public void onSuccess(final RongIMClient.BlacklistStatus blacklistStatus) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(blacklistStatus);
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.GetUserBlacklistCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(GetUserBlacklistCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void getBlacklist(final GetBlacklistCallback callback) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        mRrongIMClient.getBlacklist(new RongIMClient.GetBlacklistCallback(){

            @Override
            public void onSuccess(final String[] userIds) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(userIds);
                        }
                    });
                }
            }

            @Override
            public void onError(final RongIMClient.GetBlacklistCallback.ErrorCode errorCode) {
                if (callback != null) {
                    mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(GetBlacklistCallback.ErrorCode.setValue(errorCode.getValue()));
                        }
                    });
                }
            }
        });
    }

    public void startDiscussionMemberSelect(Context context, String discussionId, List<String> userIds) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        Uri.Builder builder = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("friend").appendPath(RongIMClient.ConversationType.DISCUSSION.getName().toLowerCase()).appendQueryParameter("userIds", TextUtils.join((CharSequence)",", userIds));
        if (!TextUtils.isEmpty((CharSequence)discussionId)) {
            builder.appendQueryParameter("discussionId", discussionId);
        }
        context.startActivity(new Intent("android.intent.action.VIEW", builder.build()));
    }

    public void startFriendSelect(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        Uri uri = Uri.parse((String)("rong://" + context.getApplicationInfo().packageName)).buildUpon().appendPath("friend").appendPath(RongIMClient.ConversationType.PRIVATE.getName().toLowerCase()).build();
        context.startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    public void addMemberToDiscussion(String discussionId, List<String> userIdList, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || MessageLogic.getInstance() == null || mRrongIMClient == null || userIdList == null || userIdList.size() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageLogic.getInstance().inviteMemberToDiscussion(discussionId, userIdList, callback);
    }

    public void removeMemberFromDiscussion(String discussionId, String userId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || MessageLogic.getInstance() == null || mRrongIMClient == null || TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageLogic.getInstance().removeMemberFromDiscussion(discussionId, userId, callback);
    }

    public List<RongIMClient.Message> getHistoryMessages(RongIMClient.ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            new IllegalAccessException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return mRrongIMClient.getHistoryMessages(conversationType, targetId, oldestMessageId, count);
    }

    public List<RongIMClient.Message> getHistoryMessages(RongIMClient.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            new IllegalAccessException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return mRrongIMClient.getHistoryMessages(conversationType, targetId, objectName, oldestMessageId, count);
    }

    public RongIMClient getRongIMClient() {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        return mRrongIMClient;
    }

    public boolean setConversationToTop(RongIMClient.ConversationType conversationType, String targetId, boolean isTop) {
        if (mRrongIMClient == null) {
            throw new RuntimeException("Connect is not initialized!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException();
        }
        boolean isSuccess = mRrongIMClient.setConversationToTop(conversationType, targetId, isTop);
        if (isSuccess && mContext != null) {
            Util.initBroadcastPackage(mContext.getPackageName());
            mContext.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
        }
        return isSuccess;
    }

    public void setSendMessageListener(OnSendMessageListener onSendMessageListener) {
        if (onSendMessageListener != null && RCloudContext.getInstance() != null) {
            RCloudContext.getInstance().setOnSendMessageListener(onSendMessageListener);
        }
    }

    static {
        mCurrentStatus = ConnectionStatusListener.ConnectionStatus.DISCONNECTED;
    }

    public static interface OnSendMessageListener {
        public RongIMClient.Message onSent(RongIMClient.Message var1);
    }

    public static interface GetBlacklistCallback {
        public void onSuccess(String[] var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)"RongIMClient", (String)("GetBlacklistCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface GetUserBlacklistCallback {
        public void onSuccess(RongIMClient.BlacklistStatus var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)"RongIMClient", (String)("GetUserBlacklistCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface OperationCallback {
        public void onSuccess();

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                return UNKNOWN;
            }
        }
    }

    public static interface GetGroupInfoProvider {
        public RongIMClient.Group getGroupInfo(String var1);
    }

    public static interface GetFriendsProvider {
        public List<RongIMClient.UserInfo> getFriends();
    }

    public static interface GetUserInfoProvider {
        public RongIMClient.UserInfo getUserInfo(String var1);
    }

    public static interface ConnectionStatusListener {
        public void onChanged(ConnectionStatus var1);

        public static enum ConnectionStatus {
            DISCONNECTED(-9, "Disconnected"),
            CONNECTED(0, "Connect Success."),
            CONNECTING(2, "Connecting"),
            UNKNOWN(-1, "Unknown error."),
            NETWORK_UNAVAILABLE(1, "Network is unavailable."),
            KICKED_OFFLINE_BY_OTHER_CLIENT(6, "Login on the other device, and be kicked offline."),
            LOGIN_ON_WEB(7, "Login on web client.");

            private int code;
            private String msg;

            private ConnectionStatus(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ConnectionStatus setValue(int code) {
                for (ConnectionStatus c : ConnectionStatus.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                return UNKNOWN;
            }
        }
    }

    public static interface OnReceiveMessageListener {
        public void onReceived(RongIMClient.Message var1, int var2);
    }

    public static interface ConversationBehaviorListener {
        public boolean onClickUserPortrait(Context var1, RongIMClient.ConversationType var2, RongIMClient.UserInfo var3);

        public boolean onClickMessage(Context var1, RongIMClient.Message var2);
    }

    public static interface LocationProvider {
        public void onStartLocation(Context var1, LocationCallback var2);

        public static interface LocationCallback {
            public void onSuccess(LocationMessage var1);

            public void onFailure(String var1);
        }
    }
}

