/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.Menu;
import io.rong.imkit.Res;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.ConversationFragment;
import io.rong.imkit.fragment.ConversationGroupListFragment;
import io.rong.imkit.fragment.ConversationListFragment;
import io.rong.imkit.fragment.ConversationSettingFragment;
import io.rong.imkit.fragment.FriendMultiChoiceFragment;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.view.ActionBar;
import io.rong.imkit.view.LoadingDialog;
import io.rong.imlib.RongIMClient;

public class RongActivity
extends FragmentActivity {
    private ActionBar mActionBar;
    private LoadingDialog mDialog;
    private Handler mHandler;

    protected void onCreate(Bundle arg0) {
        super.onCreate(arg0);
        if (arg0 != null) {
            Log.d((String)"RongActivity", (String)("onCreate:" + arg0.toString()));
        }
        this.mHandler = new Handler();
        this.setVolumeControlStream(3);
        this.requestWindowFeature(1);
        this.setContentView(Res.getInstance((Context)this).layout("rc_activity"));
        this.mActionBar = (ActionBar)this.findViewById(Res.getInstance((Context)this).id("rc_actionbar"));
        Intent intent = this.getIntent();
        if (intent != null && intent.getData() != null && intent.getData().getScheme().equals("rong")) {
            if (intent.getExtras() != null && intent.getExtras().get("appId") != null) {
                if (RongIM.getInstance() == null && RongIM.getLastToken() != null) {
                    this.reconnect(RongIM.getLastToken());
                }
            } else if (intent != null && arg0 == null) {
                this.enterFragment(intent);
            }
        } else if (intent != null && arg0 == null) {
            this.enterFragment(intent);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (RongIM.getInstance() == null && savedInstanceState.containsKey("RONG_TOKEN")) {
            String token = savedInstanceState.getString("RONG_TOKEN");
            this.reconnect(token);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putString("RONG_TOKEN", RongIM.getLastToken());
        super.onSaveInstanceState(outState);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.enterFragment(intent);
    }

    private void enterFragment(Intent intent) {
        String fragmentName;
        Fragment fragment = null;
        this.getBar().recycle();
        if (intent.getExtras() != null && intent.getExtras().containsKey("extra_fragment_content")) {
            fragmentName = intent.getExtras().getString("extra_fragment_content");
            fragment = Fragment.instantiate((Context)this, (String)fragmentName);
        } else if (intent.getData() != null) {
            if (((String)intent.getData().getPathSegments().get(0)).equals("conversation")) {
                fragmentName = ConversationFragment.class.getCanonicalName();
                fragment = Fragment.instantiate((Context)this, (String)fragmentName);
            } else if (intent.getData().getLastPathSegment().equals("conversationlist")) {
                fragmentName = ConversationListFragment.class.getCanonicalName();
                fragment = Fragment.instantiate((Context)this, (String)fragmentName);
            } else if (((String)intent.getData().getPathSegments().get(0)).equals("conversationsetting")) {
                fragmentName = ConversationSettingFragment.class.getCanonicalName();
                fragment = Fragment.instantiate((Context)this, (String)fragmentName);
            } else if (intent.getData().getLastPathSegment().equals("conversationgrouplist")) {
                fragmentName = ConversationGroupListFragment.class.getCanonicalName();
                fragment = Fragment.instantiate((Context)this, (String)fragmentName);
            } else if (((String)intent.getData().getPathSegments().get(0)).equals("friend")) {
                fragmentName = FriendMultiChoiceFragment.class.getCanonicalName();
                fragment = Fragment.instantiate((Context)this, (String)fragmentName);
            }
        }
        if (fragment != null) {
            FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
            transaction.replace(Res.getInstance((Context)this).id("rc_content"), fragment);
            transaction.commitAllowingStateLoss();
        }
    }

    private void reconnect(String token) {
        this.mDialog = new LoadingDialog((Context)this);
        this.mDialog.setCancelable(false);
        this.mDialog.setText(Res.getInstance((Context)this).string("connect_auto_reconnect"));
        this.mDialog.show();
        try {
            RongIM.connect(token, new RongIMClient.ConnectCallback(){

                @Override
                public void onSuccess(String userId) {
                    RongActivity.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            RongActivity.this.mDialog.dismiss();
                            RongToast.toast((Context)RongActivity.this, Res.getInstance((Context)RongActivity.this).string("connect_auto_success"));
                            Intent intent = RongActivity.this.getIntent();
                            if (intent != null) {
                                RongActivity.this.enterFragment(intent);
                            }
                        }
                    });
                }

                @Override
                public void onError(RongIMClient.ConnectCallback.ErrorCode errorCode) {
                    RongActivity.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            RongActivity.this.mDialog.dismiss();
                            RongToast.toast((Context)RongActivity.this, Res.getInstance((Context)RongActivity.this).string("connect_auto_fail"));
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RongActivity.this.mDialog.dismiss();
                    RongToast.toast((Context)RongActivity.this, Res.getInstance((Context)RongActivity.this).string("connect_auto_fail"));
                }
            });
            e.printStackTrace();
        }
    }

    public ActionBar getBar() {
        return this.mActionBar;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            this.getBar().recycle();
            super.onBackPressed();
        }
    }
}

