/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.common.DiscardOldestPolicy;
import com.sea_monster.core.common.PriorityRunnable;
import com.sea_monster.core.network.DefaultHttpHandler;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.cache.ResourceCacheWrapper;
import com.sea_monster.core.resource.compress.ResourceCompressHandler;
import com.sea_monster.core.resource.io.FileSysHandler;
import com.sea_monster.core.resource.io.ResourceRemoteWrapper;
import com.sea_monster.core.utils.FileUtils;
import de.greenrobot.event.EventBus;
import io.rong.imkit.RongIM;
import io.rong.imkit.cache.RongCache;
import io.rong.imkit.cache.RongCacheWrap;
import io.rong.imkit.service.RongIMService;
import io.rong.imkit.utils.Util;
import io.rong.imkit.version.Version;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.push.PushContext;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.senab.bitmapcache.BitmapLruCache;

public class RCloudContext
extends ContextWrapper {
    private static final String TAG = RCloudContext.class.getSimpleName();
    public static final String CLIENT_CONNECTED_TO_SDK = "client_connected_to_sdk";
    public static final String CLIENT_DISCONNECT_TO_SDK = "client_disconnect_to_sdk";
    public static final String CLICK_REPEAT = "click_repeat";
    public static final Version objVer = new Version();
    private static RCloudContext sS;
    private ComponentName mComponentName;
    private SharedPreferences mPreferences;
    private String mAppResourceDir;
    private RongIMClient mRongIMClient;
    private FileSysHandler mFileSysHandler;
    ThreadPoolExecutor mExecutor;
    private int mNotificationNewMessageCount = 0;
    private ArrayList<String> mNotificationUserIdList = new ArrayList();
    private List<RongIM.ConnectionStatusListener> mConnectStatusListeners;
    private ConnectionStatusListener mConnStatusListener;
    private String mCurrentTargetId;
    private Handler mHandler;
    private int mConnectStatus = -1;
    private EventBus mEventBus;
    private String mCurrentUserId;
    private static ArrayList<String> mMessageTypeList;
    private RongCache<String, RongIMClient.UserInfo> mUserInfoCache;
    private RongCache<String, RongIMClient.Group> mGroupCache;
    private RongIM.ConversationBehaviorListener mConversationBehaviorListener;
    private RongIM.GetFriendsProvider mGetFriendsProvider;
    private RongIM.GetUserInfoProvider mGetUserInfoProvider;
    private RongIM.OnReceiveMessageListener mOnReceiveMessageListener;
    private RongIM.GetGroupInfoProvider mGetGroupInfoProvider;
    private RongIM.LocationProvider mLocationProvider;
    private RongIM.OnSendMessageListener mOnSendMessageListener;

    private RCloudContext(Context context) {
        super(context);
        this.mComponentName = new ComponentName((Context)this, RongIMService.class);
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        PriorityBlockingQueue<Runnable> mWorkQueue = new PriorityBlockingQueue<Runnable>(25);
        ThreadFactory mThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ConnectTask #" + this.mCount.getAndIncrement());
            }
        };
        this.mExecutor = new ThreadPoolExecutor(2, 3, 1L, TimeUnit.SECONDS, mWorkQueue, mThreadFactory);
        this.mExecutor.setRejectedExecutionHandler(new DiscardOldestPolicy());
        this.mFileSysHandler = new FileSysHandler(this.mExecutor, this.getResourceDir(context), "file", "rong");
        DefaultHttpHandler httpHandler = new DefaultHttpHandler(context, this.mExecutor);
        ResourceRemoteWrapper remoteWrapper = new ResourceRemoteWrapper(context, this.mFileSysHandler, httpHandler);
        File cacheFile = new File(this.getResourceDir(context), "cache");
        if (!cacheFile.exists()) {
            FileUtils.createDirectory(cacheFile, true);
        }
        BitmapLruCache cache = new BitmapLruCache.Builder(context).setDiskCacheEnabled(true).setDiskCacheLocation(cacheFile).setMemoryCacheMaxSize(6164480).build();
        ResourceCompressHandler compressHandler = new ResourceCompressHandler(context, this.mFileSysHandler);
        ResourceCacheWrapper cacheWrapper = new ResourceCacheWrapper(context, cache, this.mFileSysHandler, compressHandler);
        ResourceManager.init(context, remoteWrapper, cacheWrapper);
        this.mConnectStatusListeners = new ArrayList<RongIM.ConnectionStatusListener>();
        final Context mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.getRongIMClient();
        RongIMClient.setConnectionStatusListener(new RongIMClient.ConnectionStatusListener(){

            @Override
            public void onChanged(final RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
                if (RCloudContext.this.mConnectStatus == 6) {
                    return;
                }
                RCloudContext.this.mConnectStatus = status.getValue();
                if (status == RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) {
                    Log.d((String)"NetStatus", (String)"ConnectionStatus.NETWORK_UNAVAILABLE");
                }
                RCloudContext.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (RongIM.ConnectionStatusListener item : RCloudContext.this.mConnectStatusListeners) {
                            item.onChanged(RongIM.ConnectionStatusListener.ConnectionStatus.setValue(status.getValue()));
                        }
                        if (RCloudContext.this.mConnStatusListener != null) {
                            RCloudContext.this.mConnStatusListener.onChanged(RCloudContext.this.mConnectStatus);
                        }
                        if (status == RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT) {
                            RCloudContext.this.sendKickedBroadCast(mContext);
                        }
                    }
                });
            }
        });
        this.mEventBus = EventBus.getDefault();
        this.initCache();
    }

    public String getCurrentUserId() {
        return this.mCurrentUserId;
    }

    public void setCurrentUserId(String currentUserId) {
        this.mCurrentUserId = currentUserId;
    }

    private void sendKickedBroadCast(Context context) {
        Intent i = new Intent();
        i.putExtra("kicked_message", true);
        i.setAction(context.getPackageName() + "com.ccrc.avtest.action.reciveMsg");
        context.sendBroadcast(i);
    }

    public static RCloudContext getInstance() {
        return sS;
    }

    public EventBus getEventBus() {
        return this.mEventBus;
    }

    public static void init(Context context) {
        Util.initBroadcastPackage(context.getPackageName());
        if (sS == null) {
            sS = new RCloudContext(context);
        }
        RCloudContext.setMessageType(TextMessage.class);
        RCloudContext.setMessageType(VoiceMessage.class);
        RCloudContext.setMessageType(ImageMessage.class);
        RCloudContext.setMessageType(LocationMessage.class);
        RCloudContext.setMessageType(RichContentMessage.class);
        RCloudContext.setMessageType(InformationNotificationMessage.class);
        RCloudContext.setMessageType(RongIMClient.DiscussionNotificationMessage.class);
    }

    public void initService() {
        Log.d((String)"RCloudContext", (String)"-------initService------");
        if (this.isRCloudServiceRuning("io.rong.imkit.service.RongIMService")) {
            this.stopService(new Intent().setComponent(this.mComponentName));
        }
        this.startService(new Intent().setComponent(this.mComponentName));
    }

    public int getCurrentConnStatus() {
        return this.mConnectStatus;
    }

    public void setConnectionStatusListener(ConnectionStatusListener listener) {
        if (listener != null) {
            this.mConnStatusListener = listener;
            this.mConnStatusListener.onChanged(this.mConnectStatus);
        }
    }

    public void regConnectionStatusListener(RongIM.ConnectionStatusListener listener) {
        this.mConnectStatusListeners.add(listener);
    }

    public void unRegConnectionStatusListener(RongIM.ConnectionStatusListener listener) {
        this.mConnectStatusListeners.remove(listener);
    }

    public void logout() {
        Log.d((String)"RCloudContext", (String)"--------logout-----");
        this.mConnectStatus = -1;
        this.stopService(new Intent().setComponent(this.mComponentName));
    }

    public void sendAction(Intent intent) {
        Log.d((String)"MessageLogic", (String)"----RCloudContext----sendAction-----");
        if (intent != null) {
            intent.setComponent(this.mComponentName);
            this.startService(intent);
        }
    }

    private boolean isRCloudServiceRuning(String className) {
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo runningServiceInfo : servicesList) {
            if (!runningServiceInfo.service.getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public SharedPreferences getSharedPreferences() {
        return this.mPreferences;
    }

    public void executorBackgroup(final Runnable runnable) {
        PriorityRunnable priorityRunnable = new PriorityRunnable(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        this.mExecutor.execute(priorityRunnable);
    }

    public String getAppResourceDir() {
        return this.mAppResourceDir;
    }

    public RongIMClient getRongIMClient() {
        return this.mRongIMClient;
    }

    public RongIM.OnSendMessageListener getOnSendMessageListener() {
        return this.mOnSendMessageListener;
    }

    public void setOnSendMessageListener(RongIM.OnSendMessageListener onSendMessageListener) {
        this.mOnSendMessageListener = onSendMessageListener;
    }

    public RongIM.ConversationBehaviorListener getConversationBehaviorListener() {
        return this.mConversationBehaviorListener;
    }

    public void setConversationBehaviorListener(RongIM.ConversationBehaviorListener conversationBehaviorListener) {
        this.mConversationBehaviorListener = conversationBehaviorListener;
    }

    public RongIM.GetFriendsProvider getGetFriendsProvider() {
        return this.mGetFriendsProvider;
    }

    public void setGetFriendsProvider(RongIM.GetFriendsProvider mGetFriendsProvider) {
        this.mGetFriendsProvider = mGetFriendsProvider;
    }

    public RongIM.LocationProvider getLocationProvider() {
        return this.mLocationProvider;
    }

    public void setLocationProvider(RongIM.LocationProvider locationProvider) {
        this.mLocationProvider = locationProvider;
    }

    public RongIM.GetUserInfoProvider getGetUserInfoProvider() {
        if (this.mGetUserInfoProvider == null && this.mGetFriendsProvider != null) {
            return null;
        }
        return this.mGetUserInfoProvider;
    }

    public void setGetUserInfoProvider(RongIM.GetUserInfoProvider mGetUserInfoProvider) {
        this.mGetUserInfoProvider = mGetUserInfoProvider;
    }

    public void setReceiveMessageListener(RongIM.OnReceiveMessageListener listener) {
        this.mOnReceiveMessageListener = listener;
    }

    public RongIM.OnReceiveMessageListener getOnReceiveMessageListener() {
        return this.mOnReceiveMessageListener;
    }

    public RongIM.GetGroupInfoProvider getGetGroupInfoProvider() {
        return this.mGetGroupInfoProvider;
    }

    public void setGetGroupInfoProvider(RongIM.GetGroupInfoProvider provider) {
        this.mGetGroupInfoProvider = provider;
    }

    public void setRongIMClient(RongIMClient mRongIMClient) {
        this.mRongIMClient = mRongIMClient;
        this.mConnectStatus = 0;
    }

    private final File getResourceDir(Context context) {
        File root = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            root = context.getExternalFilesDir("RongCloud");
        }
        if (root == null) {
            root = new File(context.getFilesDir(), "RongCloud");
        }
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public String getAppKey() {
        return PushContext.getInstance().getCurrentVersion().getAppKey();
    }

    public int getNotificationNewMessageCount() {
        return this.mNotificationNewMessageCount;
    }

    public void setNotificationNewMessageCount(int mNotificationNewMessageCount) {
        this.mNotificationNewMessageCount = mNotificationNewMessageCount;
    }

    public ArrayList<String> getNotificationUserIdList() {
        return this.mNotificationUserIdList;
    }

    public void clearNotificationUserIdList() {
        this.mNotificationUserIdList.clear();
    }

    public String getCurrentTargetId() {
        return this.mCurrentTargetId;
    }

    public void setCurrentTargetId(String currentTargetId) {
        this.mCurrentTargetId = currentTargetId;
    }

    public static boolean isExitMessageType(String objName) {
        return mMessageTypeList.contains(objName);
    }

    private static void setMessageType(String objName) {
        if (!TextUtils.isEmpty((CharSequence)objName) && !mMessageTypeList.contains(objName)) {
            mMessageTypeList.add(objName);
        }
    }

    private static void setMessageType(Class<? extends RongIMClient.MessageContent> type) {
        MessageTag tag = type.getAnnotation(MessageTag.class);
        if (tag != null) {
            RCloudContext.setMessageType(tag.value());
        }
    }

    private void initCache() {
        this.mUserInfoCache = new RongCacheWrap<String, RongIMClient.UserInfo>(this, 250){

            @Override
            public RongIMClient.UserInfo obtainValue(final String key) {
                if (key == null) {
                    return null;
                }
                RongIMClient.UserInfo userInfo = null;
                if (RCloudContext.this.getGetUserInfoProvider() != null) {
                    userInfo = RCloudContext.this.getGetUserInfoProvider().getUserInfo(key);
                }
                if (userInfo != null && !TextUtils.isEmpty((CharSequence)key) && key.equals(userInfo.getUserId()) && !TextUtils.isEmpty((CharSequence)userInfo.getName())) {
                    this.put(key, userInfo);
                    EventBus.getDefault().post(userInfo);
                    return userInfo;
                }
                RCloudContext.this.getRongIMClient().getUserInfo(key, new RongIMClient.GetUserInfoCallback(){

                    @Override
                    public void onSuccess(RongIMClient.UserInfo user) {
                        this.put(key, user);
                        EventBus.getDefault().post(user);
                    }

                    @Override
                    public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                        Log.d((String)TAG, (String)"--initCache--getUserInfo--onError---");
                        RongIMClient.UserInfo user = new RongIMClient.UserInfo(key, key, "");
                        this.put(key, user);
                        EventBus.getDefault().post(user);
                    }
                });
                return null;
            }
        };
        this.mGroupCache = new RongCacheWrap<String, RongIMClient.Group>(this, 10){

            @Override
            public RongIMClient.Group obtainValue(String key) {
                if (key == null) {
                    return null;
                }
                RongIMClient.Group group = null;
                if (RCloudContext.this.getGetGroupInfoProvider() != null) {
                    group = RCloudContext.this.getGetGroupInfoProvider().getGroupInfo(key);
                }
                if (group != null && !TextUtils.isEmpty((CharSequence)key) && key.equals(group.getId()) && !TextUtils.isEmpty((CharSequence)group.getName())) {
                    this.put(key, group);
                    EventBus.getDefault().post(group);
                } else {
                    RongIMClient.Group group1 = new RongIMClient.Group(key, key, "");
                    this.put(key, group1);
                    EventBus.getDefault().post(group1);
                }
                return group;
            }
        };
    }

    public RongCache<String, RongIMClient.UserInfo> getUserInfoCache() {
        return this.mUserInfoCache;
    }

    public RongCache<String, RongIMClient.Group> getGroupCache() {
        return this.mGroupCache;
    }

    static {
        mMessageTypeList = new ArrayList();
    }

    public static interface ConnectionStatusListener {
        public void onChanged(int var1);
    }
}

