/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.os.Environment;
import android.os.Looper;
import android.text.format.DateFormat;
import android.util.Log;
import java.io.File;
import java.io.PrintWriter;
import java.util.Calendar;

class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public final String fTag = "CrashHandler";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private final String fCrashReporterExtension = ".log";

    public CrashHandler(Context context) {
    }

    public void init() {
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.handleException(ex);
        this.mDefaultHandler.uncaughtException(thread, ex);
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return true;
        }
        ex.printStackTrace();
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Looper.loop();
            }
        }.start();
        this.saveCrashInfoToFile(ex);
        return true;
    }

    private void saveCrashInfoToFile(Throwable ex) {
        if (this.isSdCardReady()) {
            try {
                String dirName = this.getRoot() + "/crash";
                File dir = new File(dirName);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(System.currentTimeMillis());
                String fileName = dirName + "/crash-" + DateFormat.format((CharSequence)"MMM_dd_yyyy_h_mmaa", (Calendar)calendar) + "-" + ".log";
                PrintWriter printWriter = new PrintWriter(fileName);
                ex.printStackTrace(printWriter);
                for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                    cause.printStackTrace(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception e) {
                Log.d((String)"CrashHandler", (String)"an error occured while writing report file...", (Throwable)e);
            }
        }
    }

    private boolean isSdCardReady() {
        String sd = Environment.getExternalStorageState();
        return sd.equals("mounted");
    }

    public String getRoot() {
        File sd = Environment.getExternalStorageDirectory();
        return sd.getPath() + "/RongCloud";
    }
}

