/*
 * Decompiled with CFR 0.152.
 */
package io.rong.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import io.rong.database.RongSession;
import io.rong.database.Version;

public class VersionDao
extends AbstractDao<Version, String> {
    public static final String TABLENAME = "VERSION";

    public VersionDao(DaoConfig config) {
        super(config);
    }

    public VersionDao(DaoConfig config, RongSession daoSession) {
        super(config, daoSession);
    }

    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "'VERSION' (" + "'APP_ID' TEXT PRIMARY KEY NOT NULL ," + "'APP_KEY' TEXT NOT NULL ," + "'APP_VERSION_CODE' INTEGER NOT NULL ," + "'SDKVERSION_CODE' INTEGER NOT NULL ," + "'PUSH_VERSION_CODE' INTEGER NOT NULL );");
        db.execSQL("CREATE INDEX " + constraint + "IDX_VERSION_APP_ID ON VERSION" + " (APP_ID);");
        db.execSQL("CREATE INDEX " + constraint + "IDX_VERSION_APP_KEY ON VERSION" + " (APP_KEY);");
    }

    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'VERSION'";
        db.execSQL(sql);
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, Version entity) {
        stmt.clearBindings();
        String AppId = entity.getAppId();
        if (AppId != null) {
            stmt.bindString(1, AppId);
        }
        stmt.bindString(2, entity.getAppKey());
        stmt.bindLong(3, (long)entity.getAppVersionCode());
        stmt.bindLong(4, (long)entity.getSDKVersionCode());
        stmt.bindLong(5, (long)entity.getPushVersionCode());
    }

    @Override
    public String readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0);
    }

    @Override
    public Version readEntity(Cursor cursor, int offset) {
        Version entity = new Version(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0), cursor.getString(offset + 1), cursor.getInt(offset + 2), cursor.getInt(offset + 3), cursor.getInt(offset + 4));
        return entity;
    }

    @Override
    public void readEntity(Cursor cursor, Version entity, int offset) {
        entity.setAppId(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0));
        entity.setAppKey(cursor.getString(offset + 1));
        entity.setAppVersionCode(cursor.getInt(offset + 2));
        entity.setSDKVersionCode(cursor.getInt(offset + 3));
        entity.setPushVersionCode(cursor.getInt(offset + 4));
    }

    @Override
    protected String updateKeyAfterInsert(Version entity, long rowId) {
        return entity.getAppId();
    }

    @Override
    public String getKey(Version entity) {
        if (entity != null) {
            return entity.getAppId();
        }
        return null;
    }

    @Override
    protected boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property AppId = new Property(0, String.class, "AppId", true, "APP_ID", "VERSION");
        public static final Property AppKey = new Property(1, String.class, "AppKey", false, "APP_KEY", "VERSION");
        public static final Property AppVersionCode = new Property(2, Integer.TYPE, "AppVersionCode", false, "APP_VERSION_CODE", "VERSION");
        public static final Property SDKVersionCode = new Property(3, Integer.TYPE, "SDKVersionCode", false, "SDKVERSION_CODE", "VERSION");
        public static final Property PushVersionCode = new Property(4, Integer.TYPE, "PushVersionCode", false, "PUSH_VERSION_CODE", "VERSION");
    }
}

