/*
 * Decompiled with CFR 0.152.
 */
package io.rong.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import de.greenrobot.dao.AbstractDaoMaster;
import de.greenrobot.dao.identityscope.IdentityScopeType;
import io.rong.database.RongSession;
import io.rong.database.VersionDao;

public class RongMaster
extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 1;

    public static void createAllTables(SQLiteDatabase db, boolean ifNotExists) {
        VersionDao.createTable(db, ifNotExists);
    }

    public static void dropAllTables(SQLiteDatabase db, boolean ifExists) {
        VersionDao.dropTable(db, ifExists);
    }

    public RongMaster(SQLiteDatabase db) {
        super(db, 1);
        this.registerDaoClass(VersionDao.class);
    }

    @Override
    public RongSession newSession() {
        return new RongSession(this.db, IdentityScopeType.Session, this.daoConfigMap);
    }

    @Override
    public RongSession newSession(IdentityScopeType type) {
        return new RongSession(this.db, type, this.daoConfigMap);
    }

    public static class DevOpenHelper
    extends OpenHelper {
        public DevOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.i((String)"greenDAO", (String)("Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables"));
            RongMaster.dropAllTables(db, true);
            this.onCreate(db);
        }
    }

    public static abstract class OpenHelper
    extends SQLiteOpenHelper {
        public OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            Log.i((String)"greenDAO", (String)"Creating tables for schema version 1");
            RongMaster.createAllTables(db, false);
        }
    }
}

