/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.test;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.test.AbstractDaoTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDaoTestSinglePk<D extends AbstractDao<T, K>, T, K>
extends AbstractDaoTest<D, T, K> {
    protected Set<K> usedPks = new HashSet<K>();
    private Property pkColumn;

    public AbstractDaoTestSinglePk(Class<D> daoClass) {
        super(daoClass);
    }

    @Override
    protected void setUp() throws Exception {
        Property[] columns;
        super.setUp();
        for (Property column : columns = this.daoAccess.getProperties()) {
            if (!column.primaryKey) continue;
            if (this.pkColumn != null) {
                throw new RuntimeException("Test does not work with multiple PK columns");
            }
            this.pkColumn = column;
        }
        if (this.pkColumn == null) {
            throw new RuntimeException("Test does not work without a PK column");
        }
    }

    public void testInsertAndLoad() {
        K pk = this.nextPk();
        T entity = this.createEntity(pk);
        this.dao.insert(entity);
        AbstractDaoTestSinglePk.assertEquals(pk, this.daoAccess.getKey(entity));
        Object entity2 = this.dao.load(pk);
        AbstractDaoTestSinglePk.assertNotNull(entity2);
        AbstractDaoTestSinglePk.assertEquals(this.daoAccess.getKey(entity), this.daoAccess.getKey(entity2));
    }

    public void testInsertInTx() {
        this.dao.deleteAll();
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < 20; ++i) {
            list.add(this.createEntityWithRandomPk());
        }
        this.dao.insertInTx(list);
        AbstractDaoTestSinglePk.assertEquals((long)list.size(), (long)this.dao.count());
    }

    public void testCount() {
        this.dao.deleteAll();
        AbstractDaoTestSinglePk.assertEquals((long)0L, (long)this.dao.count());
        this.dao.insert(this.createEntityWithRandomPk());
        AbstractDaoTestSinglePk.assertEquals((long)1L, (long)this.dao.count());
        this.dao.insert(this.createEntityWithRandomPk());
        AbstractDaoTestSinglePk.assertEquals((long)2L, (long)this.dao.count());
    }

    public void testInsertTwice() {
        K pk = this.nextPk();
        T entity = this.createEntity(pk);
        this.dao.insert(entity);
        try {
            this.dao.insert(entity);
            AbstractDaoTestSinglePk.fail((String)"Inserting twice should not work");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testInsertOrReplaceTwice() {
        T entity = this.createEntityWithRandomPk();
        long rowId1 = this.dao.insert(entity);
        long rowId2 = this.dao.insertOrReplace(entity);
        if (this.dao.getPkProperty().type == Long.class) {
            AbstractDaoTestSinglePk.assertEquals((long)rowId1, (long)rowId2);
        }
    }

    public void testInsertOrReplaceInTx() {
        this.dao.deleteAll();
        ArrayList<T> listPartial = new ArrayList<T>();
        ArrayList<T> listAll = new ArrayList<T>();
        for (int i = 0; i < 20; ++i) {
            T entity = this.createEntityWithRandomPk();
            if (i % 2 == 0) {
                listPartial.add(entity);
            }
            listAll.add(entity);
        }
        this.dao.insertOrReplaceInTx(listPartial);
        this.dao.insertOrReplaceInTx(listAll);
        AbstractDaoTestSinglePk.assertEquals((long)listAll.size(), (long)this.dao.count());
    }

    public void testDelete() {
        K pk = this.nextPk();
        this.dao.deleteByKey(pk);
        T entity = this.createEntity(pk);
        this.dao.insert(entity);
        AbstractDaoTestSinglePk.assertNotNull(this.dao.load(pk));
        this.dao.deleteByKey(pk);
        AbstractDaoTestSinglePk.assertNull(this.dao.load(pk));
    }

    public void testDeleteAll() {
        ArrayList<T> entityList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            Object entity = this.createEntityWithRandomPk();
            entityList.add(entity);
        }
        this.dao.insertInTx(entityList);
        this.dao.deleteAll();
        AbstractDaoTestSinglePk.assertEquals((long)0L, (long)this.dao.count());
        for (Object entity : entityList) {
            Object key = this.daoAccess.getKey(entity);
            AbstractDaoTestSinglePk.assertNotNull(key);
            AbstractDaoTestSinglePk.assertNull(this.dao.load(key));
        }
    }

    public void testDeleteInTx() {
        ArrayList<T> entityList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            T entity = this.createEntityWithRandomPk();
            entityList.add(entity);
        }
        this.dao.insertInTx(entityList);
        ArrayList entitiesToDelete = new ArrayList();
        entitiesToDelete.add(entityList.get(0));
        entitiesToDelete.add(entityList.get(3));
        entitiesToDelete.add(entityList.get(4));
        entitiesToDelete.add(entityList.get(8));
        this.dao.deleteInTx(entitiesToDelete);
        AbstractDaoTestSinglePk.assertEquals((long)(entityList.size() - entitiesToDelete.size()), (long)this.dao.count());
        for (Object deletedEntity : entitiesToDelete) {
            Object key = this.daoAccess.getKey(deletedEntity);
            AbstractDaoTestSinglePk.assertNotNull(key);
            AbstractDaoTestSinglePk.assertNull(this.dao.load(key));
        }
    }

    public void testDeleteByKeyInTx() {
        ArrayList<T> entityList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            T entity = this.createEntityWithRandomPk();
            entityList.add(entity);
        }
        this.dao.insertInTx(entityList);
        ArrayList keysToDelete = new ArrayList();
        keysToDelete.add(this.daoAccess.getKey(entityList.get(0)));
        keysToDelete.add(this.daoAccess.getKey(entityList.get(3)));
        keysToDelete.add(this.daoAccess.getKey(entityList.get(4)));
        keysToDelete.add(this.daoAccess.getKey(entityList.get(8)));
        this.dao.deleteByKeyInTx(keysToDelete);
        AbstractDaoTestSinglePk.assertEquals((long)(entityList.size() - keysToDelete.size()), (long)this.dao.count());
        for (Object key : keysToDelete) {
            AbstractDaoTestSinglePk.assertNotNull(key);
            AbstractDaoTestSinglePk.assertNull(this.dao.load(key));
        }
    }

    public void testRowId() {
        long rowId2;
        T entity1 = this.createEntityWithRandomPk();
        T entity2 = this.createEntityWithRandomPk();
        long rowId1 = this.dao.insert(entity1);
        AbstractDaoTestSinglePk.assertTrue((rowId1 != (rowId2 = this.dao.insert(entity2)) ? 1 : 0) != 0);
    }

    public void testLoadAll() {
        this.dao.deleteAll();
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < 15; ++i) {
            T entity = this.createEntity(this.nextPk());
            list.add(entity);
        }
        this.dao.insertInTx(list);
        List loaded = this.dao.loadAll();
        AbstractDaoTestSinglePk.assertEquals((int)list.size(), (int)loaded.size());
    }

    public void testQuery() {
        this.dao.insert(this.createEntityWithRandomPk());
        K pkForQuery = this.nextPk();
        this.dao.insert(this.createEntity(pkForQuery));
        this.dao.insert(this.createEntityWithRandomPk());
        String where = "WHERE " + this.dao.getPkColumns()[0] + "=?";
        List list = this.dao.queryRaw(where, pkForQuery.toString());
        AbstractDaoTestSinglePk.assertEquals((int)1, (int)list.size());
        AbstractDaoTestSinglePk.assertEquals(pkForQuery, this.daoAccess.getKey(list.get(0)));
    }

    public void testUpdate() {
        this.dao.deleteAll();
        T entity = this.createEntityWithRandomPk();
        this.dao.insert(entity);
        this.dao.update(entity);
        AbstractDaoTestSinglePk.assertEquals((long)1L, (long)this.dao.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWithOffset() {
        K pk = this.nextPk();
        T entity = this.createEntity(pk);
        this.dao.insert(entity);
        try (Cursor cursor = this.queryWithDummyColumnsInFront(5, "42", pk);){
            Object entity2 = this.daoAccess.readEntity(cursor, 5);
            AbstractDaoTestSinglePk.assertEquals(pk, this.daoAccess.getKey(entity2));
        }
    }

    public void testLoadPkWithOffset() {
        this.runLoadPkTest(10);
    }

    public void testLoadPk() {
        this.runLoadPkTest(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runLoadPkTest(int offset) {
        K pk = this.nextPk();
        T entity = this.createEntity(pk);
        this.dao.insert(entity);
        try (Cursor cursor = this.queryWithDummyColumnsInFront(offset, "42", pk);){
            Object pk2 = this.daoAccess.readKey(cursor, offset);
            AbstractDaoTestSinglePk.assertEquals(pk, pk2);
        }
    }

    protected Cursor queryWithDummyColumnsInFront(int dummyCount, String valueForColumn, K pk) {
        StringBuilder builder = new StringBuilder("SELECT ");
        for (int i = 0; i < dummyCount; ++i) {
            builder.append(valueForColumn).append(",");
        }
        SqlUtils.appendColumns(builder, "T", this.dao.getAllColumns()).append(" FROM ");
        builder.append(this.dao.getTablename()).append(" T");
        if (pk != null) {
            builder.append(" WHERE ");
            AbstractDaoTestSinglePk.assertEquals((int)1, (int)this.dao.getPkColumns().length);
            builder.append(this.dao.getPkColumns()[0]).append("=");
            DatabaseUtils.appendValueToSql((StringBuilder)builder, pk);
        }
        String select = builder.toString();
        Cursor cursor = this.db.rawQuery(select, null);
        AbstractDaoTestSinglePk.assertTrue((boolean)cursor.moveToFirst());
        try {
            for (int i = 0; i < dummyCount; ++i) {
                AbstractDaoTestSinglePk.assertEquals((String)valueForColumn, (String)cursor.getString(i));
            }
            if (pk != null) {
                AbstractDaoTestSinglePk.assertEquals((int)1, (int)cursor.getCount());
            }
        }
        catch (RuntimeException ex) {
            cursor.close();
            throw ex;
        }
        return cursor;
    }

    protected K nextPk() {
        for (int i = 0; i < 100000; ++i) {
            K pk = this.createRandomPk();
            if (!this.usedPks.add(pk)) continue;
            return pk;
        }
        throw new IllegalStateException("Could not find a new PK");
    }

    protected T createEntityWithRandomPk() {
        return this.createEntity(this.nextPk());
    }

    protected abstract K createRandomPk();

    protected abstract T createEntity(K var1);
}

