/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.Property;
import java.util.Date;
import java.util.List;

public interface WhereCondition {
    public void appendTo(StringBuilder var1);

    public void appendValuesTo(List<Object> var1);

    public static class UpdateCondition
    extends AbstractCondition {
        public final Property property;
        public final String op;

        private static Object checkValueForType(Property property, Object value) {
            if (value != null && value.getClass().isArray()) {
                throw new DaoException("Illegal value: found array, but simple object required");
            }
            Class<?> type = property.type;
            if (type == Date.class) {
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Long) {
                    return value;
                }
                throw new DaoException("Illegal date value: expected java.util.Date or Long for value " + value);
            }
            if (property.type == Boolean.TYPE || property.type == Boolean.class) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof Number) {
                    int intValue = ((Number)value).intValue();
                    if (intValue != 0 && intValue != 1) {
                        throw new DaoException("Illegal boolean value: numbers must be 0 or 1, but was " + value);
                    }
                } else if (value instanceof String) {
                    String stringValue = (String)value;
                    if ("TRUE".equalsIgnoreCase(stringValue)) {
                        return 1;
                    }
                    if ("FALSE".equalsIgnoreCase(stringValue)) {
                        return 0;
                    }
                    throw new DaoException("Illegal boolean value: Strings must be \"TRUE\" or \"FALSE\" (case insesnsitive), but was " + value);
                }
            }
            return value;
        }

        private static Object[] checkValuesForType(Property property, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = UpdateCondition.checkValueForType(property, values[i]);
            }
            return values;
        }

        public UpdateCondition(Property property, String op) {
            this.property = property;
            this.op = op;
        }

        public UpdateCondition(Property property, String op, Object value) {
            super(UpdateCondition.checkValueForType(property, value));
            this.property = property;
            this.op = op;
        }

        public UpdateCondition(Property property, String op, Object[] values) {
            super(UpdateCondition.checkValuesForType(property, values));
            this.property = property;
            this.op = op;
        }

        public UpdateCondition(Property property, String op, Property value) {
            this.property = property;
            this.op = op + value.tableName + "." + "'" + value.columnName + "'";
        }

        @Override
        public void appendTo(StringBuilder builder) {
            builder.append(this.property.columnName).append(this.op);
        }
    }

    public static class StringCondition
    extends AbstractCondition {
        protected final String string;

        public StringCondition(String string2) {
            this.string = string2;
        }

        public StringCondition(String string2, Object value) {
            super(value);
            this.string = string2;
        }

        public StringCondition(String string2, Object ... values) {
            super(values);
            this.string = string2;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            builder.append(this.string);
        }
    }

    public static class PropertySelfCondition
    extends AbstractCondition {
        public final Property property;
        public final String op1;
        public final String op2;

        private static Object checkValueForType(Property property, Object value) {
            if (value != null && value.getClass().isArray()) {
                throw new DaoException("Illegal value: found array, but simple object required");
            }
            Class<?> type = property.type;
            if (type == Date.class) {
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Long) {
                    return value;
                }
                throw new DaoException("Illegal date value: expected java.util.Date or Long for value " + value);
            }
            if (property.type == Boolean.TYPE || property.type == Boolean.class) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof Number) {
                    int intValue = ((Number)value).intValue();
                    if (intValue != 0 && intValue != 1) {
                        throw new DaoException("Illegal boolean value: numbers must be 0 or 1, but was " + value);
                    }
                } else if (value instanceof String) {
                    String stringValue = (String)value;
                    if ("TRUE".equalsIgnoreCase(stringValue)) {
                        return 1;
                    }
                    if ("FALSE".equalsIgnoreCase(stringValue)) {
                        return 0;
                    }
                    throw new DaoException("Illegal boolean value: Strings must be \"TRUE\" or \"FALSE\" (case insesnsitive), but was " + value);
                }
            }
            return value;
        }

        private static Object[] checkValuesForType(Property property, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = PropertySelfCondition.checkValueForType(property, values[i]);
            }
            return values;
        }

        public PropertySelfCondition(Property property, String op1, String op2) {
            this.property = property;
            this.op1 = op1;
            this.op2 = op2;
        }

        public PropertySelfCondition(Property property, String op1, String op2, Object value) {
            super(PropertySelfCondition.checkValueForType(property, value));
            this.property = property;
            this.op1 = op1;
            this.op2 = op2;
        }

        public PropertySelfCondition(Property property, String op1, String op2, Object ... values) {
            super(PropertySelfCondition.checkValuesForType(property, values));
            this.property = property;
            this.op1 = op1;
            this.op2 = op2;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            builder.append(this.property.tableName).append(".'").append(this.property.columnName).append('\'').append(this.op1).append(this.op2);
        }
    }

    public static class PropertyCondition
    extends AbstractCondition {
        public final Property property;
        public final String op;

        private static Object checkValueForType(Property property, Object value) {
            if (value != null && value.getClass().isArray()) {
                throw new DaoException("Illegal value: found array, but simple object required");
            }
            Class<?> type = property.type;
            if (type == Date.class) {
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Long) {
                    return value;
                }
                throw new DaoException("Illegal date value: expected java.util.Date or Long for value " + value);
            }
            if (property.type == Boolean.TYPE || property.type == Boolean.class) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof Number) {
                    int intValue = ((Number)value).intValue();
                    if (intValue != 0 && intValue != 1) {
                        throw new DaoException("Illegal boolean value: numbers must be 0 or 1, but was " + value);
                    }
                } else if (value instanceof String) {
                    String stringValue = (String)value;
                    if ("TRUE".equalsIgnoreCase(stringValue)) {
                        return 1;
                    }
                    if ("FALSE".equalsIgnoreCase(stringValue)) {
                        return 0;
                    }
                    throw new DaoException("Illegal boolean value: Strings must be \"TRUE\" or \"FALSE\" (case insesnsitive), but was " + value);
                }
            }
            return value;
        }

        private static Object[] checkValuesForType(Property property, Object[] values) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = PropertyCondition.checkValueForType(property, values[i]);
            }
            return values;
        }

        public PropertyCondition(Property property, String op) {
            this.property = property;
            this.op = op;
        }

        public PropertyCondition(Property property, String op, Object value) {
            super(PropertyCondition.checkValueForType(property, value));
            this.property = property;
            this.op = op;
        }

        public PropertyCondition(Property property, String op, Property value) {
            this.property = property;
            this.op = op + value.tableName + "." + "'" + value.columnName + "'";
        }

        public PropertyCondition(Property property, String op, Object[] values) {
            super(PropertyCondition.checkValuesForType(property, values));
            this.property = property;
            this.op = op;
        }

        @Override
        public void appendTo(StringBuilder builder) {
            builder.append(this.property.tableName).append(".'").append(this.property.columnName).append('\'').append(this.op);
        }
    }

    public static abstract class AbstractCondition
    implements WhereCondition {
        protected final boolean hasSingleValue;
        protected final Object value;
        protected final Object[] values;

        public AbstractCondition() {
            this.hasSingleValue = false;
            this.value = null;
            this.values = null;
        }

        public AbstractCondition(Object value) {
            this.value = value;
            this.hasSingleValue = true;
            this.values = null;
        }

        public AbstractCondition(Object[] values) {
            this.value = null;
            this.hasSingleValue = false;
            this.values = values;
        }

        @Override
        public void appendValuesTo(List<Object> valuesTarget) {
            if (this.hasSingleValue) {
                valuesTarget.add(this.value);
            }
            if (this.values != null) {
                for (Object value : this.values) {
                    valuesTarget.add(value);
                }
            }
        }
    }
}

