/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.sqlite.SQLiteDatabase;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.IQueryDaoAccess;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.AbstractQueryData;

public class UpdateQuery<T>
extends AbstractQuery<T> {
    private final QueryData<T> queryData;

    static <T2> UpdateQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        QueryData queryData = new QueryData(dao, sql, UpdateQuery.toStringArray(initialValues));
        return (UpdateQuery)queryData.forCurrentThread();
    }

    private UpdateQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, new IQueryDaoAccess.InternalQueryDaoAccess<T>(dao), sql, initialValues);
        this.queryData = queryData;
    }

    public UpdateQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.checkThread();
        SQLiteDatabase db = this.dao.getDatabase();
        if (db.isDbLockedByCurrentThread()) {
            this.dao.getDatabase().execSQL(this.sql, (Object[])this.parameters);
        } else {
            db.beginTransaction();
            try {
                this.dao.getDatabase().execSQL(this.sql, (Object[])this.parameters);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, UpdateQuery<T2>> {
        private QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            super(dao, sql, initialValues);
        }

        @Override
        protected UpdateQuery<T2> createQuery() {
            return new UpdateQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

