/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.IQueryDaoAccess;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.AbstractQueryData;

public class FuncQuery<T>
extends AbstractQuery<T> {
    private final QueryData<T> queryData;

    static <T2> FuncQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        QueryData queryData = new QueryData(dao, sql, FuncQuery.toStringArray(initialValues));
        return (FuncQuery)queryData.forCurrentThread();
    }

    private FuncQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, new IQueryDaoAccess.InternalQueryDaoAccess<T>(dao), sql, initialValues);
        this.queryData = queryData;
    }

    public FuncQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() {
        this.checkThread();
        try (Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);){
            if (!cursor.moveToNext()) {
                throw new DaoException("No result for func");
            }
            if (!cursor.isLast()) {
                throw new DaoException("Unexpected row func: " + cursor.getCount());
            }
            if (cursor.getColumnCount() != 1) {
                throw new DaoException("Unexpected column func: " + cursor.getColumnCount());
            }
            long l = cursor.getLong(0);
            return l;
        }
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, FuncQuery<T2>> {
        private QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            super(dao, sql, initialValues);
        }

        @Override
        protected FuncQuery<T2> createQuery() {
            return new FuncQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

