/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.text.TextUtils;
import de.greenrobot.dao.AbstractDeepDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.DaoLog;
import de.greenrobot.dao.FuncProperty;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.query.CloseableListIterator;
import de.greenrobot.dao.query.CountQuery;
import de.greenrobot.dao.query.DeepQuery;
import de.greenrobot.dao.query.GroupQuery;
import de.greenrobot.dao.query.LazyList;
import de.greenrobot.dao.query.WhereCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DeepQueryBuilder<T> {
    public static boolean LOG_SQL;
    public static boolean LOG_VALUES;
    private StringBuilder orderBuilder;
    private final List<WhereCondition> whereConditions;
    private final List<Object> values;
    private final AbstractDeepDao<T, ?> dao;
    private Integer limit;
    private Integer offset;

    public static <T2> DeepQueryBuilder<T2> internalCreate(AbstractDeepDao<T2, ?> dao) {
        return new DeepQueryBuilder<T2>(dao);
    }

    protected DeepQueryBuilder(AbstractDeepDao<T, ?> dao) {
        this.dao = dao;
        this.values = new ArrayList<Object>();
        this.whereConditions = new ArrayList<WhereCondition>();
    }

    private void checkOrderBuilder() {
        if (this.orderBuilder == null) {
            this.orderBuilder = new StringBuilder();
        } else if (this.orderBuilder.length() > 0) {
            this.orderBuilder.append(",");
        }
    }

    public DeepQueryBuilder<T> where(WhereCondition cond, WhereCondition ... condMore) {
        this.whereConditions.add(cond);
        for (WhereCondition whereCondition : condMore) {
            this.whereConditions.add(whereCondition);
        }
        return this;
    }

    public DeepQueryBuilder<T> whereOr(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        this.whereConditions.add(this.or(cond1, cond2, condMore));
        return this;
    }

    public WhereCondition or(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.combineWhereConditions(" OR ", cond1, cond2, condMore);
    }

    public WhereCondition and(WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        return this.combineWhereConditions(" AND ", cond1, cond2, condMore);
    }

    protected WhereCondition combineWhereConditions(String combineOp, WhereCondition cond1, WhereCondition cond2, WhereCondition ... condMore) {
        StringBuilder builder = new StringBuilder("(");
        ArrayList<Object> combinedValues = new ArrayList<Object>();
        this.addCondition(builder, combinedValues, cond1);
        builder.append(combineOp);
        this.addCondition(builder, combinedValues, cond2);
        for (WhereCondition cond : condMore) {
            builder.append(combineOp);
            this.addCondition(builder, combinedValues, cond);
        }
        builder.append(')');
        return new WhereCondition.StringCondition(builder.toString(), combinedValues.toArray());
    }

    protected void addCondition(StringBuilder builder, List<Object> values, WhereCondition condition) {
        condition.appendTo(builder);
        condition.appendValuesTo(values);
    }

    public <J> DeepQueryBuilder<J> join(Class<J> entityClass, Property toOneProperty) {
        throw new UnsupportedOperationException();
    }

    public <J> DeepQueryBuilder<J> joinToMany(Class<J> entityClass, Property toManyProperty) {
        throw new UnsupportedOperationException();
    }

    public DeepQueryBuilder<T> orderAsc(Property ... properties) {
        this.orderAscOrDesc(" ASC", properties);
        return this;
    }

    public DeepQueryBuilder<T> orderDesc(Property ... properties) {
        this.orderAscOrDesc(" DESC", properties);
        return this;
    }

    private void orderAscOrDesc(String ascOrDescWithLeadingSpace, Property ... properties) {
        for (Property property : properties) {
            this.checkOrderBuilder();
            this.append(this.orderBuilder, property);
            if (String.class.equals(property.type)) {
                this.orderBuilder.append(" COLLATE LOCALIZED");
            }
            this.orderBuilder.append(ascOrDescWithLeadingSpace);
        }
    }

    public DeepQueryBuilder<T> orderCustom(Property property, String customOrderForProperty) {
        this.checkOrderBuilder();
        this.append(this.orderBuilder, property).append(' ');
        this.orderBuilder.append(customOrderForProperty);
        return this;
    }

    public DeepQueryBuilder<T> orderRaw(String rawOrder) {
        this.checkOrderBuilder();
        this.orderBuilder.append(rawOrder);
        return this;
    }

    protected StringBuilder append(StringBuilder builder, Property property) {
        builder.append(property.tableName).append('.').append('\'').append(property.columnName).append('\'');
        return builder;
    }

    protected void checkProperty(Property property) {
        if (this.dao != null) {
            Property[] properties = this.dao.getProperties();
            boolean found = false;
            for (Property property2 : properties) {
                if (property != property2) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new DaoException("Property '" + property.name + "' is not part of " + this.dao);
            }
        }
    }

    public DeepQueryBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public DeepQueryBuilder<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    public DeepQuery<T> build() {
        String select = this.dao.getSelectDeep();
        StringBuilder builder = new StringBuilder(select);
        this.appendWhereClause(builder);
        if (this.orderBuilder != null && this.orderBuilder.length() > 0) {
            builder.append(" ORDER BY ").append((CharSequence)this.orderBuilder);
        }
        int limitPosition = -1;
        if (this.limit != null) {
            builder.append(" LIMIT ?");
            this.values.add(this.limit);
            limitPosition = this.values.size() - 1;
        }
        int offsetPosition = -1;
        if (this.offset != null) {
            if (this.limit == null) {
                throw new IllegalStateException("Offset cannot be set without limit");
            }
            builder.append(" OFFSET ?");
            this.values.add(this.offset);
            offsetPosition = this.values.size() - 1;
        }
        String sql = builder.toString();
        if (LOG_SQL) {
            DaoLog.d("Built SQL for query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for query: " + this.values);
        }
        return DeepQuery.create(this.dao, sql, this.values.toArray(), limitPosition, offsetPosition);
    }

    public GroupQuery<T> buildGroup(Property property, List<FuncProperty> funcProperties) {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(property);
        return this.buildGroup(properties, funcProperties);
    }

    public GroupQuery<T> buildGroup(List<Property> properties, FuncProperty funcProperty) {
        ArrayList<FuncProperty> funcProperties = new ArrayList<FuncProperty>();
        if (funcProperty != null) {
            funcProperties.add(funcProperty);
        }
        return this.buildGroup(properties, funcProperties);
    }

    public GroupQuery<T> buildGroup(List<Property> properties, List<FuncProperty> funcProperties) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            Property item = properties.get(i);
            SqlUtils.appendColumn(builder, item.tableName, item.columnName);
            if (i >= properties.size() - 1) continue;
            builder.append(',');
        }
        if (funcProperties != null) {
            ListIterator<FuncProperty> iter = funcProperties.listIterator();
            if (funcProperties.size() > 0) {
                builder.append(" , ");
            }
            while (iter.hasNext()) {
                if (iter.hasPrevious()) {
                    builder.append(" , ");
                }
                builder.append(iter.next().getColumn());
            }
        }
        builder.append(this.dao.getDeepJoinString());
        String baseSql = SqlUtils.createSqlSelectRaw(builder.toString());
        builder = new StringBuilder(baseSql);
        this.appendWhereClause(builder);
        this.appendGroupClause(builder, properties);
        if (this.orderBuilder != null && this.orderBuilder.length() > 0) {
            builder.append(" ORDER BY ").append((CharSequence)this.orderBuilder);
        }
        String sql = builder.toString();
        if (LOG_SQL) {
            DaoLog.d("Built SQL for delete query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for delete query: " + this.values);
        }
        return GroupQuery.create(this.dao, sql, this.values.toArray());
    }

    public CountQuery<T> buildCount() {
        String tablename = this.dao.getTablename();
        String baseSql = SqlUtils.createSqlSelectCountStar(tablename);
        StringBuilder builder = new StringBuilder(baseSql);
        this.appendWhereClause(builder);
        String sql = builder.toString();
        if (LOG_SQL) {
            DaoLog.d("Built SQL for count query: " + sql);
        }
        if (LOG_VALUES) {
            DaoLog.d("Values for count query: " + this.values);
        }
        return CountQuery.create(this.dao, sql, this.values.toArray());
    }

    private void appendWhereClause(StringBuilder builder) {
        this.values.clear();
        if (!this.whereConditions.isEmpty()) {
            builder.append(" WHERE ");
            ListIterator<WhereCondition> iter = this.whereConditions.listIterator();
            while (iter.hasNext()) {
                if (iter.hasPrevious()) {
                    builder.append(" AND ");
                }
                WhereCondition condition = iter.next();
                condition.appendTo(builder);
                condition.appendValuesTo(this.values);
            }
        }
    }

    private void appendGroupClause(StringBuilder builder, List<Property> properties) {
        if (!properties.isEmpty()) {
            builder.append(" GROUP BY ");
            ListIterator<Property> iter = properties.listIterator();
            while (iter.hasNext()) {
                if (iter.hasPrevious()) {
                    builder.append(" , ");
                }
                Property property = iter.next();
                if (TextUtils.isEmpty((CharSequence)property.asName)) {
                    SqlUtils.appendColumn(builder, property.tableName, property.columnName);
                    continue;
                }
                SqlUtils.appendColumn(builder, property.asName);
            }
        }
    }

    public List<T> list() {
        return this.build().list();
    }

    public LazyList<T> listLazy() {
        return this.build().listLazy();
    }

    public LazyList<T> listLazyUncached() {
        return this.build().listLazyUncached();
    }

    public CloseableListIterator<T> listIterator() {
        return this.build().listIterator();
    }

    public T unique() {
        return this.build().unique();
    }

    public T uniqueOrThrow() {
        return this.build().uniqueOrThrow();
    }

    public long count() {
        return this.buildCount().count();
    }
}

