/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDeepDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.IQueryDaoAccess;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.AbstractQueryData;
import de.greenrobot.dao.query.CloseableListIterator;
import de.greenrobot.dao.query.LazyList;
import java.util.List;

public class DeepQuery<T>
extends AbstractQuery<T> {
    private final int limitPosition;
    private final int offsetPosition;
    private final QueryData<T> queryData;

    public static <T2> DeepQuery<T2> internalCreate(AbstractDeepDao<T2, ?> dao, String sql, Object[] initialValues) {
        return DeepQuery.create(dao, sql, initialValues, -1, -1);
    }

    static <T2> DeepQuery<T2> create(AbstractDeepDao<T2, ?> dao, String sql, Object[] initialValues, int limitPosition, int offsetPosition) {
        QueryData<T2> queryData = new QueryData<T2>(dao, sql, DeepQuery.toStringArray(initialValues), limitPosition, offsetPosition);
        return (DeepQuery)queryData.forCurrentThread();
    }

    private DeepQuery(QueryData<T> queryData, AbstractDeepDao<T, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
        super(dao, new IQueryDaoAccess.InternalQueryDeepDaoAccess<T>(dao), sql, initialValues);
        this.queryData = queryData;
        this.limitPosition = limitPosition;
        this.offsetPosition = offsetPosition;
    }

    public DeepQuery<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    @Override
    public void setParameter(int index, Object parameter) {
        if (index >= 0 && (index == this.limitPosition || index == this.offsetPosition)) {
            throw new IllegalArgumentException("Illegal parameter index: " + index);
        }
        super.setParameter(index, parameter);
    }

    public void setLimit(int limit) {
        this.checkThread();
        if (this.limitPosition == -1) {
            throw new IllegalStateException("Limit must be set with QueryBuilder before it can be used here");
        }
        this.parameters[this.limitPosition] = Integer.toString(limit);
    }

    public void setOffset(int offset) {
        this.checkThread();
        if (this.offsetPosition == -1) {
            throw new IllegalStateException("Offset must be set with QueryBuilder before it can be used here");
        }
        this.parameters[this.offsetPosition] = Integer.toString(offset);
    }

    public List<T> list() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadAllAndCloseCursor(cursor);
    }

    public LazyList<T> listLazy() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, true);
    }

    public Cursor getCursor() {
        return this.dao.getDatabase().rawQuery(this.sql, this.parameters);
    }

    public LazyList<T> listLazyUncached() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, false);
    }

    public CloseableListIterator<T> listIterator() {
        return this.listLazyUncached().listIteratorAutoClose();
    }

    public T unique() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadUniqueAndCloseCursor(cursor);
    }

    public T uniqueOrThrow() {
        T entity = this.unique();
        if (entity == null) {
            throw new DaoException("No entity found for query");
        }
        return entity;
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, DeepQuery<T2>> {
        private final int limitPosition;
        private final int offsetPosition;

        QueryData(AbstractDeepDao<T2, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
            super(dao, sql, initialValues);
            this.limitPosition = limitPosition;
            this.offsetPosition = offsetPosition;
        }

        @Override
        protected DeepQuery<T2> createQuery() {
            return new DeepQuery(this, (AbstractDeepDao)this.dao, this.sql, (String[])this.initialValues.clone(), this.limitPosition, this.offsetPosition);
        }
    }
}

