/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.IQueryDaoAccess;

abstract class AbstractQuery<T> {
    protected final AbstractDao<T, ?> dao;
    protected final IQueryDaoAccess<T> daoAccess;
    protected final String sql;
    protected final String[] parameters;
    protected final Thread ownerThread;

    protected static String[] toStringArray(Object[] values) {
        int length = values.length;
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            Object object = values[i];
            strings[i] = object != null ? object.toString() : null;
        }
        return strings;
    }

    protected AbstractQuery(AbstractDao<T, ?> dao, IQueryDaoAccess<T> daoAccess, String sql, String[] parameters) {
        this.dao = dao;
        this.daoAccess = daoAccess;
        this.sql = sql;
        this.parameters = parameters;
        this.ownerThread = Thread.currentThread();
    }

    public void setParameter(int index, Object parameter) {
        this.checkThread();
        this.parameters[index] = parameter != null ? parameter.toString() : null;
    }

    protected void checkThread() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new DaoException("Method may be called only in owner thread, use forCurrentThread to get an instance for this thread");
        }
    }
}

