/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.internal;

import android.text.TextUtils;

public class SqlUtils {
    public static StringBuilder appendColumn(StringBuilder builder, String column) {
        builder.append('\'').append(column).append('\'');
        return builder;
    }

    public static StringBuilder appendColumn(StringBuilder builder, String tableName, String column) {
        builder.append(tableName).append(".'").append(column).append('\'');
        return builder;
    }

    public static StringBuilder appendColumns(StringBuilder builder, String tableName, String[] columns) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            SqlUtils.appendColumn(builder, tableName, columns[i]);
            if (i >= length - 1) continue;
            builder.append(',');
        }
        return builder;
    }

    public static StringBuilder appendColumns(StringBuilder builder, String tableName, String[] columns, String rawColumns) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            SqlUtils.appendColumn(builder, tableName, columns[i]);
            if (i < length - 1) {
                builder.append(',');
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)rawColumns)) continue;
            builder.append(',');
            builder.append(rawColumns);
        }
        return builder;
    }

    public static StringBuilder appendColumns(StringBuilder builder, String[] columns) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            builder.append('\'').append(columns[i]).append('\'');
            if (i >= length - 1) continue;
            builder.append(',');
        }
        return builder;
    }

    public static StringBuilder appendPlaceholders(StringBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            if (i < count - 1) {
                builder.append("?,");
                continue;
            }
            builder.append('?');
        }
        return builder;
    }

    public static StringBuilder appendColumnsEqualPlaceholders(StringBuilder builder, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            SqlUtils.appendColumn(builder, columns[i]).append("=?");
            if (i >= columns.length - 1) continue;
            builder.append(',');
        }
        return builder;
    }

    public static StringBuilder appendColumnsEqValue(StringBuilder builder, String tablename, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            SqlUtils.appendColumn(builder, tablename, columns[i]).append("=?");
            if (i >= columns.length - 1) continue;
            builder.append(',');
        }
        return builder;
    }

    public static String createSqlInsert(String insertInto, String tablename, String[] columns) {
        StringBuilder builder = new StringBuilder(insertInto);
        builder.append(tablename).append(" (");
        SqlUtils.appendColumns(builder, columns);
        builder.append(") VALUES (");
        SqlUtils.appendPlaceholders(builder, columns.length);
        builder.append(')');
        return builder.toString();
    }

    public static String createSqlSelect(String tablename, String[] columns) {
        StringBuilder builder = new StringBuilder("SELECT ");
        SqlUtils.appendColumns(builder, tablename, columns).append(" FROM ");
        builder.append(tablename).append(' ');
        return builder.toString();
    }

    public static String createSqlSelect(String tablename, String[] columns, String rawColnums) {
        StringBuilder builder = new StringBuilder("SELECT ");
        SqlUtils.appendColumns(builder, tablename, columns, rawColnums).append(" FROM ");
        builder.append(tablename).append(' ');
        return builder.toString();
    }

    public static String createSqlSelectRaw(String raw) {
        StringBuilder builder = new StringBuilder("SELECT ");
        return builder.append(raw).toString();
    }

    public static String createSqlSelectRaw(String tablename, String raw) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(raw).toString();
        builder.append(" FROM " + tablename);
        builder.append(" ");
        return builder.toString();
    }

    public static String createSqlSelectCountStar(String tablename) {
        StringBuilder builder = new StringBuilder("SELECT COUNT(*) FROM ");
        builder.append(tablename).append(' ');
        return builder.toString();
    }

    public static String createSqlDelete(String tablename, String[] columns) {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(tablename);
        if (columns != null && columns.length > 0) {
            builder.append(" WHERE ");
            SqlUtils.appendColumnsEqValue(builder, tablename, columns);
        }
        return builder.toString();
    }

    public static String createSqlUpdate(String tablename, String[] updateColumns, String[] whereColumns) {
        StringBuilder builder = new StringBuilder("UPDATE ");
        builder.append(tablename).append(" SET ");
        SqlUtils.appendColumnsEqualPlaceholders(builder, updateColumns);
        builder.append(" WHERE ");
        SqlUtils.appendColumnsEqValue(builder, tablename, whereColumns);
        return builder.toString();
    }

    public static String createSqlUpdate(String tablename) {
        StringBuilder builder = new StringBuilder("UPDATE ");
        builder.append(tablename).append(" SET ");
        return builder.toString();
    }
}

