/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.query.WhereCondition;
import java.util.Collection;
import java.util.Objects;

public class Property {
    public final int ordinal;
    public final Class<?> type;
    public final String name;
    public final boolean primaryKey;
    public final String columnName;
    public final String tableName;
    public String asName;

    public Property(int ordinal, Class<?> type, String name, boolean primaryKey, String columnName, String tableName) {
        this.ordinal = ordinal;
        this.type = type;
        this.name = name;
        this.primaryKey = primaryKey;
        this.columnName = columnName;
        this.tableName = tableName;
    }

    public Property as(String asName) {
        this.asName = asName;
        return this;
    }

    public String toString() {
        return this.tableName + "." + this.columnName;
    }

    public WhereCondition.UpdateCondition obtainUpdateCondition(Object value) {
        return new WhereCondition.UpdateCondition(this, "=?", value);
    }

    public WhereCondition.UpdateCondition obtainUpdateCondition(Property value) {
        return new WhereCondition.UpdateCondition(this, "=", value);
    }

    public WhereCondition eq(Object value) {
        return new WhereCondition.PropertyCondition(this, "=?", value);
    }

    public WhereCondition eq(Property value) {
        return new WhereCondition.PropertyCondition(this, "=", value);
    }

    public WhereCondition notEq(Object value) {
        return new WhereCondition.PropertyCondition(this, "<>?", value);
    }

    public WhereCondition notEq(Property value) {
        return new WhereCondition.PropertyCondition(this, "<>", value);
    }

    public WhereCondition like(String value) {
        return new WhereCondition.PropertyCondition(this, " LIKE ?", value);
    }

    public WhereCondition like(Property value) {
        return new WhereCondition.PropertyCondition(this, " LIKE ", value);
    }

    public WhereCondition between(Object value1, Object value2) {
        Object[] values = new Object[]{value1, value2};
        return new WhereCondition.PropertyCondition(this, " BETWEEN ? AND ?", values);
    }

    public WhereCondition in(Object ... inValues) {
        StringBuilder condition = new StringBuilder(" IN (");
        SqlUtils.appendPlaceholders(condition, inValues.length).append(')');
        return new WhereCondition.PropertyCondition(this, condition.toString(), inValues);
    }

    public WhereCondition in(Collection<?> inValues) {
        return this.in(inValues.toArray());
    }

    public WhereCondition notIn(Object ... notInValues) {
        StringBuilder condition = new StringBuilder(" NOT IN (");
        SqlUtils.appendPlaceholders(condition, notInValues.length).append(')');
        return new WhereCondition.PropertyCondition(this, condition.toString(), notInValues);
    }

    public WhereCondition notIn(Collection<?> notInValues) {
        return this.notIn(notInValues.toArray());
    }

    public WhereCondition gt(Object value) {
        return new WhereCondition.PropertyCondition(this, ">?", value);
    }

    public WhereCondition gt(Property value) {
        return new WhereCondition.PropertyCondition(this, ">", value);
    }

    public WhereCondition lt(Object value) {
        return new WhereCondition.PropertyCondition(this, "<?", value);
    }

    public WhereCondition lt(Property value) {
        return new WhereCondition.PropertyCondition(this, "<", value);
    }

    public WhereCondition ge(Object value) {
        return new WhereCondition.PropertyCondition(this, ">=?", value);
    }

    public WhereCondition ge(Property value) {
        return new WhereCondition.PropertyCondition(this, ">=", value);
    }

    public WhereCondition le(Object value) {
        return new WhereCondition.PropertyCondition(this, "<=?", value);
    }

    public WhereCondition le(Property value) {
        return new WhereCondition.PropertyCondition(this, "<=", value);
    }

    public WhereCondition isNull() {
        return new WhereCondition.PropertyCondition(this, " IS NULL");
    }

    public WhereCondition isNotNull() {
        return new WhereCondition.PropertyCondition(this, " IS NOT NULL");
    }

    public WhereCondition andEq(Object value) {
        return new WhereCondition.PropertySelfCondition(this, "&?", "=?&-1", value, value);
    }

    public WhereCondition andEq(Object value1, Objects value2) {
        return new WhereCondition.PropertySelfCondition(this, "&?", "=?&-1", value1, value2);
    }

    public WhereCondition orEq(Object value) {
        return new WhereCondition.PropertySelfCondition(this, "|?", "=?&-1", value, value);
    }

    public WhereCondition orEq(Object value1, Objects value2) {
        return new WhereCondition.PropertySelfCondition(this, "|?", "=?&-1", value1, value2);
    }

    public WhereCondition andUneq(Object value) {
        return new WhereCondition.PropertySelfCondition(this, "&?", "<>?&-1", value, value);
    }

    public WhereCondition andUneq(Object value1, Objects value2) {
        return new WhereCondition.PropertySelfCondition(this, "&?", "<>?&-1", value1, value2);
    }

    public WhereCondition orUneq(Object value) {
        return new WhereCondition.PropertySelfCondition(this, "|?", "<>?&-1", value, value);
    }

    public WhereCondition orUneq(Object value1, Objects value2) {
        return new WhereCondition.PropertySelfCondition(this, "|?", "<>?&-1", value1, value2);
    }
}

