/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.AbstractDeepDao;
import de.greenrobot.dao.internal.TableStatements;
import java.util.List;

public interface IQueryDaoAccess<T> {
    public T loadCurrent(Cursor var1, int var2, boolean var3);

    public List<T> loadAllAndCloseCursor(Cursor var1);

    public T loadUniqueAndCloseCursor(Cursor var1);

    public static final class InternalQueryDeepDaoAccess<T>
    implements IQueryDaoAccess<T> {
        private final AbstractDeepDao<T, ?> dao;

        public InternalQueryDeepDaoAccess(AbstractDeepDao<T, ?> abstractDao) {
            this.dao = abstractDao;
        }

        @Override
        public T loadCurrent(Cursor cursor, int offset, boolean lock) {
            return this.dao.loadDeepCurrent(cursor, offset, lock);
        }

        @Override
        public List<T> loadAllAndCloseCursor(Cursor cursor) {
            return this.dao.loadDeepAllAndCloseCursor(cursor);
        }

        @Override
        public T loadUniqueAndCloseCursor(Cursor cursor) {
            return this.dao.loadDeepUniqueAndCloseCursor(cursor);
        }
    }

    public static final class InternalQueryDaoAccess<T>
    implements IQueryDaoAccess<T> {
        private final AbstractDao<T, ?> dao;

        public InternalQueryDaoAccess(AbstractDao<T, ?> abstractDao) {
            this.dao = abstractDao;
        }

        @Override
        public T loadCurrent(Cursor cursor, int offset, boolean lock) {
            return this.dao.loadCurrent(cursor, offset, lock);
        }

        @Override
        public List<T> loadAllAndCloseCursor(Cursor cursor) {
            return this.dao.loadAllAndCloseCursor(cursor);
        }

        @Override
        public T loadUniqueAndCloseCursor(Cursor cursor) {
            return this.dao.loadUniqueAndCloseCursor(cursor);
        }

        public TableStatements getStatements() {
            return this.dao.getStatements();
        }

        public static <T2> TableStatements getStatements(AbstractDao<T2, ?> dao) {
            return dao.getStatements();
        }
    }
}

