/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import android.text.TextUtils;
import de.greenrobot.dao.Property;

public abstract class FuncProperty {
    Property property;
    String asName;

    public FuncProperty as(String asName) {
        this.asName = asName;
        return this;
    }

    public Property getProperty() {
        return this.property;
    }

    public abstract String getColumn();

    public static class MaxProperty
    extends FuncProperty {
        public MaxProperty(Property property) {
            this.property = property;
        }

        @Override
        public String getColumn() {
            return TextUtils.isEmpty((CharSequence)this.asName) ? "MAX(" + this.property.tableName + ".'" + this.property.columnName + "')" : "MAX(" + this.property.tableName + ".'" + this.property.columnName + "') AS " + this.asName;
        }
    }

    public static class MinProperty
    extends FuncProperty {
        public MinProperty(Property property) {
            this.property = property;
        }

        @Override
        public String getColumn() {
            return TextUtils.isEmpty((CharSequence)this.asName) ? "MIN(" + this.property.tableName + ".'" + this.property.columnName + "')" : "MIN(" + this.property.tableName + ".'" + this.property.columnName + "') AS " + this.asName;
        }
    }

    public static class CountProperty
    extends FuncProperty {
        public CountProperty(Property property) {
            this.property = property;
        }

        @Override
        public String getColumn() {
            if (this.property == null) {
                return TextUtils.isEmpty((CharSequence)this.asName) ? "COUNT(*)" : "COUNT(*) AS " + this.asName;
            }
            return TextUtils.isEmpty((CharSequence)this.asName) ? "COUNT(" + this.property.tableName + ".'" + this.property.columnName + "')" : "COUNT(" + this.property.tableName + ".'" + this.property.columnName + "') AS " + this.asName;
        }
    }
}

