/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.AbstractDaoSession;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.DeepQueryBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDeepDao<T, K>
extends AbstractDao<T, K> {
    public AbstractDeepDao(DaoConfig config) {
        super(config);
    }

    public AbstractDeepDao(DaoConfig config, AbstractDaoSession daoSession) {
        super(config, daoSession);
    }

    public abstract T loadDeep(Long var1);

    protected abstract T loadCurrentDeep(Cursor var1, boolean var2);

    public abstract String getSelectDeep();

    public abstract String getDeepJoinString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        ArrayList<T> list = new ArrayList<T>(count);
        if (cursor.moveToFirst()) {
            if (this.identityScope != null) {
                this.identityScope.lock();
                this.identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(this.loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            }
            finally {
                if (this.identityScope != null) {
                    this.identityScope.unlock();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            List<T> list = this.loadAllDeepFromCursor(cursor);
            return list;
        }
        finally {
            cursor.close();
        }
    }

    public List<T> queryDeep(String where, String ... selectionArg) {
        return this.loadDeepAllAndCloseCursor(this.getDeepCursor(where, selectionArg));
    }

    public Cursor getDeepCursor(String where, String ... selectionArg) {
        return this.db.rawQuery(this.getSelectDeep() + where, selectionArg);
    }

    protected T loadDeepCurrent(Cursor cursor, int offset, boolean lock) {
        cursor.move(offset);
        return this.loadCurrentDeep(cursor, lock);
    }

    public DeepQueryBuilder<T> deepQueryBuilder() {
        return DeepQueryBuilder.internalCreate(this);
    }

    protected T loadDeepUnique(Cursor cursor) {
        boolean available = cursor.moveToFirst();
        if (!available) {
            return null;
        }
        if (!cursor.isLast()) {
            throw new DaoException("Expected unique result, but count was " + cursor.getCount());
        }
        return this.loadDeepCurrent(cursor, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T loadDeepUniqueAndCloseCursor(Cursor cursor) {
        try {
            T t = this.loadDeepUnique(cursor);
            return t;
        }
        finally {
            cursor.close();
        }
    }
}

