/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine.video;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import com.ultrapower.mcs.engine.video.CaptureCapabilityAndroid;
import com.ultrapower.mcs.engine.video.VideoCaptureAndroid;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoCaptureDeviceInfoAndroid {
    Context context;
    private static final String TAG = "WEBRTC";
    private static int PIXEL_FORMAT = 17;
    String currentDeviceUniqueId;
    int id;
    List<AndroidVideoCaptureDevice> deviceList;

    public static VideoCaptureDeviceInfoAndroid CreateVideoCaptureDeviceInfoAndroid(int in_id, Context in_context) {
        Log.d((String)TAG, (String)String.format(Locale.US, "VideoCaptureDeviceInfoAndroid", new Object[0]));
        VideoCaptureDeviceInfoAndroid self = new VideoCaptureDeviceInfoAndroid(in_id, in_context);
        if (self != null && self.Init() == 0) {
            return self;
        }
        Log.d((String)TAG, (String)"Failed to create VideoCaptureDeviceInfoAndroid.");
        return null;
    }

    private VideoCaptureDeviceInfoAndroid(int in_id, Context in_context) {
        this.id = in_id;
        this.context = in_context;
        this.deviceList = new ArrayList<AndroidVideoCaptureDevice>();
    }

    private int Init() {
        Log.d((String)TAG, (String)"VideoCaptureDeviceInfoAndroid Init() into... ");
        Camera camera = null;
        try {
            if (Build.VERSION.SDK_INT > 8) {
                Class<?> cameraClazz = Class.forName("android.hardware.Camera");
                Method getNumberOfCamerasMethod = cameraClazz.getMethod("getNumberOfCameras", new Class[0]);
                Integer num = (Integer)getNumberOfCamerasMethod.invoke(cameraClazz, new Object[0]);
                Method openMethod = cameraClazz.getMethod("open", Integer.TYPE);
                for (int i = 0; i < num; ++i) {
                    AndroidVideoCaptureDevice newDevice = new AndroidVideoCaptureDevice();
                    Class<?> cameraInfoClazz = Class.forName("android.hardware.Camera$CameraInfo");
                    Object obj = cameraInfoClazz.newInstance();
                    Field facField = obj.getClass().getDeclaredField("facing");
                    Field orientationField = obj.getClass().getDeclaredField("orientation");
                    int faing = facField.getInt(obj);
                    int orientation = orientationField.getInt(obj);
                    Camera.CameraInfo info = new Camera.CameraInfo();
                    Method getCameraInfoMethod = cameraClazz.getMethod("getCameraInfo", Integer.TYPE, cameraInfoClazz);
                    getCameraInfoMethod.invoke(cameraClazz, i, obj);
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                    newDevice.index = i;
                    newDevice.orientation = info.orientation;
                    faing = info.facing;
                    if (faing == 0) {
                        newDevice.deviceUniqueName = "Camera " + i + ", Facing back, Orientation " + orientation;
                        Log.d((String)TAG, (String)("Camera " + i + ", Facing back, Orientation " + orientation));
                    } else {
                        newDevice.deviceUniqueName = "Camera " + i + ", Facing front, Orientation " + orientation;
                        newDevice.frontCameraType = FrontFacingCameraType.Android23;
                        Log.d((String)TAG, (String)("Camera " + i + ", Facing front, Orientation " + orientation));
                    }
                    camera = (Camera)openMethod.invoke(cameraClazz, i);
                    Camera.Parameters parameters = camera.getParameters();
                    this.AddDeviceInfo(newDevice, parameters);
                    camera.release();
                    camera = null;
                    this.deviceList.add(newDevice);
                }
            } else {
                int i = 0;
                int camera_orientation = 0;
                AndroidVideoCaptureDevice newDevice = new AndroidVideoCaptureDevice();
                newDevice.index = i;
                newDevice.orientation = camera_orientation;
                newDevice.deviceUniqueName = "Camera_" + i + "_FB_Orien_" + camera_orientation;
                Log.d((String)TAG, (String)("Camera " + i + ", Facing back, Orientation " + camera_orientation));
                camera = Camera.open();
                Camera.Parameters parameters = camera.getParameters();
                this.AddDeviceInfo(newDevice, parameters);
                camera.release();
                camera = null;
                this.deviceList.add(newDevice);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Failed to init VideoCaptureDeviceInfo ex" + ex.getLocalizedMessage() + "   ,ex.toString=" + ex.toString()));
            return 0;
        }
        this.VerifyCapabilities();
        Log.d((String)TAG, (String)"VideoCaptureDeviceInfoAndroid Init() out... ");
        return 0;
    }

    private void AddDeviceInfo(AndroidVideoCaptureDevice newDevice, Camera.Parameters parameters) {
        List sizes = parameters.getSupportedPreviewSizes();
        List frameRates = parameters.getSupportedPreviewFrameRates();
        int maxFPS = 0;
        for (Integer frameRate : frameRates) {
            if (frameRate <= maxFPS) continue;
            maxFPS = frameRate;
        }
        newDevice.captureCapabilies = new CaptureCapabilityAndroid[sizes.size()];
        for (int i = 0; i < sizes.size(); ++i) {
            Camera.Size s = (Camera.Size)sizes.get(i);
            newDevice.captureCapabilies[i] = new CaptureCapabilityAndroid();
            newDevice.captureCapabilies[i].height = s.height;
            newDevice.captureCapabilies[i].width = s.width;
            newDevice.captureCapabilies[i].maxFPS = maxFPS;
            Log.d((String)TAG, (String)("VideoCaptureDeviceInfo maxFPS:" + maxFPS + " width:" + s.width + " height:" + s.height));
        }
    }

    private void VerifyCapabilities() {
        if (Build.DEVICE.equals("GT-I9000") || Build.DEVICE.equals("crespo")) {
            CaptureCapabilityAndroid specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 352;
            specificCapability.height = 288;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
            specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 176;
            specificCapability.height = 144;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
            specificCapability = new CaptureCapabilityAndroid();
            specificCapability.width = 320;
            specificCapability.height = 240;
            specificCapability.maxFPS = 15;
            this.AddDeviceSpecificCapability(specificCapability);
        }
        if (Build.MANUFACTURER.equals("motorola") && Build.DEVICE.equals("umts_sholes")) {
            for (AndroidVideoCaptureDevice device : this.deviceList) {
                for (CaptureCapabilityAndroid capability : device.captureCapabilies) {
                    capability.maxFPS = 15;
                }
            }
        }
    }

    private void AddDeviceSpecificCapability(CaptureCapabilityAndroid specificCapability) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            boolean foundCapability = false;
            for (CaptureCapabilityAndroid capability : device.captureCapabilies) {
                if (capability.width != specificCapability.width || capability.height != specificCapability.height) continue;
                foundCapability = true;
                break;
            }
            if (foundCapability) continue;
            CaptureCapabilityAndroid[] newCaptureCapabilies = new CaptureCapabilityAndroid[device.captureCapabilies.length + 1];
            for (int i = 0; i < device.captureCapabilies.length; ++i) {
                newCaptureCapabilies[i + 1] = device.captureCapabilies[i];
            }
            newCaptureCapabilies[0] = specificCapability;
            device.captureCapabilies = newCaptureCapabilies;
        }
    }

    public int NumberOfDevices() {
        return this.deviceList.size();
    }

    public String GetDeviceUniqueName(int deviceNumber) {
        if (deviceNumber < 0 || deviceNumber >= this.deviceList.size()) {
            return null;
        }
        return this.deviceList.get((int)deviceNumber).deviceUniqueName;
    }

    public CaptureCapabilityAndroid[] GetCapabilityArray(String deviceUniqueId) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
            return device.captureCapabilies;
        }
        return null;
    }

    public int GetOrientation(String deviceUniqueId) {
        for (AndroidVideoCaptureDevice device : this.deviceList) {
            if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
            return device.orientation;
        }
        return -1;
    }

    public VideoCaptureAndroid AllocateCamera(int id, long context, String deviceUniqueId) {
        Log.d((String)TAG, (String)"VideoCaptureDeviceInfoAndroid AllocateCamera() into... ");
        try {
            Log.d((String)TAG, (String)("AllocateCamera " + deviceUniqueId));
            Camera camera = null;
            AndroidVideoCaptureDevice deviceToUse = null;
            block6: for (AndroidVideoCaptureDevice device : this.deviceList) {
                if (!device.deviceUniqueName.equals(deviceUniqueId)) continue;
                deviceToUse = device;
                switch (device.frontCameraType) {
                    case GalaxyS: {
                        camera = this.AllocateGalaxySFrontCamera();
                        continue block6;
                    }
                    case HTCEvo: {
                        camera = this.AllocateEVOFrontFacingCamera();
                        continue block6;
                    }
                }
                if (Build.VERSION.SDK_INT > 8) {
                    Class<?> cameraClazz = Class.forName("android.hardware.Camera");
                    Method openMethod = cameraClazz.getMethod("open", Integer.TYPE);
                    camera = (Camera)openMethod.invoke(cameraClazz, device.index);
                    continue;
                }
                camera = Camera.open();
            }
            if (camera == null) {
                Log.d((String)TAG, (String)"VideoCaptureAndroid::AllocateCamera - create camera fail");
                return null;
            }
            Log.d((String)TAG, (String)"VideoCaptureAndroid::AllocateCamera - creating success");
            return new VideoCaptureAndroid(id, context, camera, deviceToUse);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("AllocateCamera Failed to open camera- ex " + ex.getLocalizedMessage()));
            return null;
        }
    }

    private Camera.Parameters SearchOldFrontFacingCameras(AndroidVideoCaptureDevice newDevice) throws SecurityException, IllegalArgumentException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        String cameraId = parameters.get("camera-id");
        if (cameraId != null && cameraId.equals("1")) {
            try {
                parameters.set("camera-id", 2);
                camera.setParameters(parameters);
                parameters = camera.getParameters();
                newDevice.frontCameraType = FrontFacingCameraType.GalaxyS;
                newDevice.orientation = 0;
                camera.release();
                return parameters;
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Init Failed to open front camera camera - ex " + ex.getLocalizedMessage()));
            }
        }
        camera.release();
        File file = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        boolean exists = file.exists();
        if (!exists) {
            file = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            exists = file.exists();
        }
        if (exists) {
            newDevice.frontCameraType = FrontFacingCameraType.HTCEvo;
            newDevice.orientation = 0;
            Camera evCamera = this.AllocateEVOFrontFacingCamera();
            parameters = evCamera.getParameters();
            evCamera.release();
            return parameters;
        }
        return null;
    }

    private Camera AllocateEVOFrontFacingCamera() throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File mFilesDir;
        String classPath = null;
        File file = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        classPath = "com.htc.hardware.twinCamDevice.FrontFacingCamera";
        boolean exists = file.exists();
        if (!exists) {
            file = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            classPath = "com.sprint.hardware.twinCamDevice.FrontFacingCamera";
            exists = file.exists();
        }
        if (!exists) {
            return null;
        }
        String dexOutputDir = "";
        if (this.context == null || (mFilesDir = new File(dexOutputDir = this.context.getFilesDir().getAbsolutePath(), "dexfiles")).exists() || !mFilesDir.mkdirs()) {
            // empty if block
        }
        dexOutputDir = dexOutputDir + "/dexfiles";
        DexClassLoader loader = new DexClassLoader(file.getAbsolutePath(), dexOutputDir, null, ClassLoader.getSystemClassLoader());
        Method method = loader.loadClass(classPath).getDeclaredMethod("getFrontFacingCamera", null);
        Camera camera = (Camera)method.invoke((Object)null, (Object[])null);
        return camera;
    }

    private Camera AllocateGalaxySFrontCamera() {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        parameters.set("camera-id", 2);
        camera.setParameters(parameters);
        return camera;
    }

    public static int FindSupportSize(Camera.Parameters para, CameraSupportVideoSize cs) {
        Camera.Size s;
        List sizes_old = para.getSupportedPreviewSizes();
        ArrayList sizes = new ArrayList();
        for (int i = 0; i < sizes_old.size(); ++i) {
            if (((Camera.Size)sizes_old.get((int)i)).width <= ((Camera.Size)sizes_old.get((int)i)).height || ((Camera.Size)sizes_old.get((int)i)).width < 128) continue;
            boolean find = false;
            for (int j = 0; j < sizes.size(); ++j) {
                if (((Camera.Size)sizes.get((int)j)).width != ((Camera.Size)sizes_old.get((int)i)).width || ((Camera.Size)sizes.get((int)j)).height != ((Camera.Size)sizes_old.get((int)i)).height) continue;
                find = true;
            }
            if (find) continue;
            sizes.add(sizes_old.get(i));
        }
        Log.d((String)TAG, (String)("FindSupportSize new size len =" + sizes.size()));
        int min_w = 9999;
        int min_h = 0;
        int min_index = 0;
        for (int i = 0; i < sizes.size(); ++i) {
            s = (Camera.Size)sizes.get(i);
            if (min_w <= s.width) continue;
            min_w = s.width;
            min_h = s.height;
            min_index = i;
        }
        Log.d((String)TAG, (String)("FindSupportSize min_w:" + min_w + " min_h:" + min_h));
        cs.min_width = min_w;
        cs.min_height = min_h;
        int best_index = 0;
        if (0 == min_index) {
            if (min_w > 176) {
                cs.width = cs.min_width;
                cs.height = cs.min_height;
                cs.max_width = cs.min_width;
                cs.max_height = cs.min_height;
            } else {
                s = null;
                int i = 0;
                while (i < sizes.size()) {
                    s = (Camera.Size)sizes.get(i);
                    best_index = i++;
                    if (s.width >= 176) break;
                }
                if (null == s) {
                    Log.d((String)TAG, (String)"FindSupportSize s=null");
                    return -1;
                }
                if (s.width < 176) {
                    cs.width = cs.min_width;
                    cs.height = cs.min_height;
                    cs.max_width = cs.min_width;
                    cs.max_height = cs.min_height;
                } else if (s.width == 176) {
                    cs.width = s.width;
                    cs.height = s.height;
                    if (best_index + 1 <= sizes.size() - 1) {
                        s = (Camera.Size)sizes.get(best_index + 1);
                        cs.max_width = s.width;
                        cs.max_height = s.height;
                    } else {
                        cs.max_width = cs.width;
                        cs.max_height = cs.height;
                    }
                } else {
                    cs.max_width = s.width;
                    cs.max_height = s.height;
                    if (best_index - 1 >= 0) {
                        s = (Camera.Size)sizes.get(best_index - 1);
                        cs.width = s.width;
                        cs.height = s.height;
                    } else {
                        cs.width = cs.max_width;
                        cs.height = cs.max_height;
                    }
                }
            }
        } else if (sizes.size() - 1 == min_index) {
            if (min_w > 176) {
                cs.width = cs.min_width;
                cs.height = cs.min_height;
                cs.max_width = cs.min_width;
                cs.max_height = cs.min_height;
            } else {
                s = null;
                int i = sizes.size() - 1;
                while (i >= 0) {
                    s = (Camera.Size)sizes.get(i);
                    best_index = i--;
                    if (s.width >= 176) break;
                }
                if (null == s) {
                    return -1;
                }
                if (s.width < 176) {
                    cs.width = cs.min_width;
                    cs.height = cs.min_height;
                    cs.max_width = cs.min_width;
                    cs.max_height = cs.min_height;
                } else if (s.width == 176) {
                    cs.width = s.width;
                    cs.height = s.height;
                    if (best_index - 1 <= sizes.size() - 1) {
                        s = (Camera.Size)sizes.get(best_index - 1);
                        cs.max_width = s.width;
                        cs.max_height = s.height;
                    } else {
                        cs.max_width = cs.width;
                        cs.max_height = cs.height;
                    }
                } else {
                    cs.max_width = s.width;
                    cs.max_height = s.height;
                    if (best_index + 1 <= sizes.size() - 1) {
                        s = (Camera.Size)sizes.get(best_index + 1);
                        cs.width = s.width;
                        cs.height = s.height;
                    } else {
                        cs.width = cs.max_width;
                        cs.height = cs.max_height;
                    }
                }
            }
        } else {
            Log.d((String)TAG, (String)"FindSupportSize min_index wrong, should never happen");
        }
        return 0;
    }

    public static ArrayList<CameraSupportVideoSize> GetCameraSupportVideoSize() {
        ArrayList<CameraSupportVideoSize> lst;
        block18: {
            lst = new ArrayList<CameraSupportVideoSize>();
            Log.d((String)TAG, (String)"GetCameraSupportVideoSize into... ");
            Camera camera = null;
            try {
                int j;
                if (Build.VERSION.SDK_INT > 8) {
                    Class<?> cameraClazz = Class.forName("android.hardware.Camera");
                    Method getNumberOfCamerasMethod = cameraClazz.getMethod("getNumberOfCameras", new Class[0]);
                    Integer num = (Integer)getNumberOfCamerasMethod.invoke(cameraClazz, new Object[0]);
                    Method openMethod = cameraClazz.getMethod("open", Integer.TYPE);
                    for (int i = 0; i < num; ++i) {
                        int j2;
                        CameraSupportVideoSize cs = new CameraSupportVideoSize();
                        cs.index = i;
                        boolean ret = false;
                        camera = (Camera)openMethod.invoke(cameraClazz, i);
                        Camera.Parameters parameters = camera.getParameters();
                        List sizes_old = parameters.getSupportedPreviewSizes();
                        Boolean hasFind = false;
                        Boolean isReverse = ((Camera.Size)sizes_old.get((int)0)).width > ((Camera.Size)sizes_old.get((int)(sizes_old.size() - 1))).width;
                        if (isReverse.booleanValue()) {
                            for (j2 = 0; j2 < sizes_old.size() / 2; ++j2) {
                                Camera.Size tmpSize0 = (Camera.Size)sizes_old.get(j2);
                                Camera.Size tmpSizen = (Camera.Size)sizes_old.get(sizes_old.size() - 1 - j2);
                                sizes_old.set(j2, tmpSizen);
                                sizes_old.set(sizes_old.size() - 1 - j2, tmpSize0);
                            }
                        }
                        for (j2 = 0; j2 < sizes_old.size(); ++j2) {
                            Camera.Size size = (Camera.Size)sizes_old.get(j2);
                            if (size.height < 480 || size.width < 640) continue;
                            cs.height = size.height;
                            cs.width = size.width;
                            try {
                                parameters.setPreviewSize(size.width, size.height);
                                parameters.setPreviewFormat(VideoCaptureAndroid.PIXEL_FORMAT);
                                List listfps = parameters.getSupportedPreviewFpsRange();
                                int min = ((int[])listfps.get(0))[0];
                                int max = ((int[])listfps.get(0))[1];
                                if (10 >= min / 1000 && 10 <= max / 1000) {
                                    parameters.setPreviewFrameRate(10);
                                } else {
                                    parameters.setPreviewFrameRate(min / 1000);
                                }
                                camera.setParameters(parameters);
                                cs.width = size.width;
                                cs.height = size.height;
                            }
                            catch (Exception e) {
                                continue;
                            }
                            lst.add(cs);
                            hasFind = true;
                            break;
                        }
                        if (!hasFind.booleanValue()) {
                            cs.width = ((Camera.Size)sizes_old.get((int)0)).width;
                            cs.height = ((Camera.Size)sizes_old.get((int)0)).height;
                        }
                        camera.release();
                        camera = null;
                    }
                    break block18;
                }
                CameraSupportVideoSize cs = new CameraSupportVideoSize();
                cs.index = 0;
                camera = Camera.open();
                Camera.Parameters parameters = camera.getParameters();
                List sizes_old = parameters.getSupportedPreviewSizes();
                Boolean hasFind = false;
                Boolean isReverse = ((Camera.Size)sizes_old.get((int)0)).width > ((Camera.Size)sizes_old.get((int)(sizes_old.size() - 1))).width;
                if (isReverse.booleanValue()) {
                    for (j = 0; j < sizes_old.size() / 2; ++j) {
                        Camera.Size tmpSize0 = (Camera.Size)sizes_old.get(j);
                        Camera.Size tmpSizen = (Camera.Size)sizes_old.get(sizes_old.size() - 1 - j);
                        sizes_old.set(j, tmpSizen);
                        sizes_old.set(sizes_old.size() - 1 - j, tmpSize0);
                    }
                }
                for (j = 0; j < sizes_old.size(); ++j) {
                    Camera.Size size = (Camera.Size)sizes_old.get(j);
                    if (size.height < 480 || size.width < 640) continue;
                    cs.height = size.height;
                    cs.width = size.width;
                    try {
                        parameters.setPreviewSize(size.width, size.height);
                        parameters.setPreviewFormat(VideoCaptureAndroid.PIXEL_FORMAT);
                        parameters.setPreviewFrameRate(10);
                        camera.setParameters(parameters);
                        cs.width = size.width;
                        cs.height = size.height;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    lst.add(cs);
                    hasFind = true;
                    break;
                }
                if (!hasFind.booleanValue()) {
                    cs.width = ((Camera.Size)sizes_old.get((int)0)).width;
                    cs.height = ((Camera.Size)sizes_old.get((int)0)).height;
                }
                camera.release();
                camera = null;
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("GetCameraSupportVideoSize fail for exception:" + ex.getLocalizedMessage() + " ,ex.toString=" + ex.toString()));
            }
        }
        return lst;
    }

    public static String CameraVideoSizeToStr(int width, int height) {
        String size_str;
        if (128 == width && 96 == height) {
            size_str = "SQCIF";
        } else if (160 == width && 120 == height) {
            size_str = "QQVGA";
        } else if (176 == width && 144 == height) {
            size_str = "QCIF";
        } else if (240 == width && 160 == height) {
            size_str = "W240P";
        } else if (320 == width && 200 == height) {
            size_str = "CGA";
        } else if (320 == width && 240 == height) {
            size_str = "QVGA";
        } else if (352 == width && 240 == height) {
            size_str = "SIF";
        } else if (400 == width && 240 == height) {
            size_str = "WQVGA";
        } else if (352 == width && 288 == height) {
            size_str = "CIF";
        } else if (512 == width && 288 == height) {
            size_str = "W288P";
        } else if (640 == width && 368 == height) {
            size_str = "W368P";
        } else if (576 == width && 448 == height) {
            size_str = "S_448P";
        } else if (640 == width && 480 == height) {
            size_str = "VGA";
        } else if (720 == width && 432 == height) {
            size_str = "S_432P";
        } else if (768 == width && 432 == height) {
            size_str = "W432P";
        } else if (704 == width && 480 == height) {
            size_str = "S_4SIF";
        } else if (768 == width && 448 == height) {
            size_str = "W448P";
        } else if (720 == width && 480 == height) {
            size_str = "NTSC";
        } else if (800 == width && 448 == height) {
            size_str = "FW448P";
        } else if (768 == width && 480 == height) {
            size_str = "S_768x480P";
        } else if (800 == width && 480 == height) {
            size_str = "WVGA";
        } else if (704 == width && 576 == height) {
            size_str = "S_4CIF";
        } else if (800 == width && 600 == height) {
            size_str = "SVGA";
        } else if (960 == width && 544 == height) {
            size_str = "W544P";
        } else if (1024 == width && 576 == height) {
            size_str = "W576P";
        } else if (960 == width && 720 == height) {
            size_str = "HD";
        } else if (1024 == width && 768 == height) {
            size_str = "XGA";
        } else if (1280 == width && 720 == height) {
            size_str = "WHD";
        } else if (1440 == width && 1080 == height) {
            size_str = "FULL_HD";
        } else if (1600 == width && 1200 == height) {
            size_str = "UXGA";
        } else if (1920 == width && 1080 == height) {
            size_str = "WFULL_HD";
        } else {
            return "QCIF";
        }
        return size_str;
    }

    public static class CameraSupportVideoSize {
        public int index;
        public int min_width = 320;
        public int min_height = 240;
        public int width = 320;
        public int height = 240;
        public int max_width = 320;
        public int max_height = 240;
    }

    public static enum FrontFacingCameraType {
        None,
        GalaxyS,
        HTCEvo,
        Android23;

    }

    public class AndroidVideoCaptureDevice {
        public String deviceUniqueName;
        public CaptureCapabilityAndroid[] captureCapabilies;
        public FrontFacingCameraType frontCameraType = FrontFacingCameraType.None;
        public int orientation;
        public int index = 0;

        AndroidVideoCaptureDevice() {
        }
    }
}

