/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine.video;

import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import com.ultrapower.mcs.engine.video.CaptureCapabilityAndroid;
import com.ultrapower.mcs.engine.video.IOrientationChangedObserver;
import com.ultrapower.mcs.engine.video.OrientationChangedNotify;
import com.ultrapower.mcs.engine.video.ViERenderer;
import com.ultrapower.mcs.engine.video.VideoCaptureDeviceInfoAndroid;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

class VideoCaptureAndroid
implements Camera.PreviewCallback,
SurfaceHolder.Callback,
IOrientationChangedObserver {
    private static final String TAG = "WEBRTC-JC";
    private Camera camera;
    private VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice currentDevice = null;
    public ReentrantLock previewBufferLock = new ReentrantLock();
    private final ReentrantLock captureLock = new ReentrantLock();
    public static int PIXEL_FORMAT = 17;
    PixelFormat pixelFormat = new PixelFormat();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private SurfaceHolder surfaceHolder = null;
    private final int numCaptureBuffers = 3;
    private int expectedFrameSize = 0;
    private final int orientation = 0;
    private int id = 0;
    private long context = 0L;
    private SurfaceHolder localPreview = null;
    private boolean ownsBuffers = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFPS = -1;
    public static final int FX_MAX_FRAME_RATE_SUPPORT = 10;
    public static final int BEST_CAMERA_SIZE_WIDTH = 320;
    public static final int BEST_CAMERA_SIZE_HEIGHT = 240;
    private byte[] rotatedData;

    public static void DeleteVideoCaptureAndroid(VideoCaptureAndroid captureAndroid) {
        captureAndroid.StopCapture();
        captureAndroid.camera.release();
        captureAndroid.camera = null;
        captureAndroid.context = 0L;
        captureAndroid.localPreview = null;
    }

    public VideoCaptureAndroid(int in_id, long in_context, Camera in_camera, VideoCaptureDeviceInfoAndroid.AndroidVideoCaptureDevice in_device) {
        this.id = in_id;
        this.context = in_context;
        this.camera = in_camera;
        this.currentDevice = in_device;
    }

    private int tryStartCapture(int width, int height, int frameRate) {
        if (this.camera == null) {
            return -1;
        }
        if (this.isCaptureRunning || !this.isSurfaceReady || !this.isCaptureStarted) {
            return 0;
        }
        try {
            this.camera.setPreviewDisplay(this.surfaceHolder);
            CaptureCapabilityAndroid currentCapability = new CaptureCapabilityAndroid();
            currentCapability.width = width;
            currentCapability.height = height;
            currentCapability.maxFPS = frameRate > 10 ? 10 : frameRate;
            PixelFormat.getPixelFormatInfo((int)PIXEL_FORMAT, (PixelFormat)this.pixelFormat);
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewSize(currentCapability.width, currentCapability.height);
            parameters.setPreviewFormat(PIXEL_FORMAT);
            List listfps = parameters.getSupportedPreviewFpsRange();
            int min = ((int[])listfps.get(0))[0];
            int max = ((int[])listfps.get(0))[1];
            if (currentCapability.maxFPS >= min / 1000 && currentCapability.maxFPS <= max / 1000) {
                parameters.setPreviewFrameRate(currentCapability.maxFPS);
            } else {
                parameters.setPreviewFrameRate(min / 1000);
            }
            try {
                this.camera.setParameters(parameters);
            }
            catch (Exception ex) {
                if (currentCapability.maxFPS >= frameRate) {
                    ex.printStackTrace();
                    return -1;
                }
                currentCapability.maxFPS = currentCapability.maxFPS == 10 ? 15 : (currentCapability.maxFPS == 15 ? frameRate : frameRate);
                parameters.setPreviewFrameRate(currentCapability.maxFPS);
                try {
                    this.camera.setParameters(parameters);
                }
                catch (Exception e) {
                    return -1;
                }
            }
            int bufSize = width * height * this.pixelFormat.bitsPerPixel / 8;
            byte[] buffer = null;
            for (int i = 0; i < 3; ++i) {
                buffer = new byte[bufSize];
                this.camera.addCallbackBuffer(buffer);
                this.rotatedData = new byte[bufSize];
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            this.ownsBuffers = true;
            OrientationChangedNotify.Instances().AddObserver(this);
            this.camera.startPreview();
            this.previewBufferLock.lock();
            this.expectedFrameSize = bufSize;
            this.isCaptureRunning = true;
            this.previewBufferLock.unlock();
        }
        catch (Exception ex) {
            return -1;
        }
        this.isCaptureRunning = true;
        return 0;
    }

    public int StartCapture(int width, int height, int frameRate) {
        this.localPreview = ViERenderer.GetLocalRenderer();
        if (this.localPreview != null) {
            this.localPreview.addCallback((SurfaceHolder.Callback)this);
        }
        this.captureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = width;
        this.mCaptureHeight = height;
        this.mCaptureFPS = frameRate;
        int res = this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
        return res;
    }

    public int StopCapture() {
        try {
            this.previewBufferLock.lock();
            this.isCaptureRunning = false;
            this.previewBufferLock.unlock();
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
            OrientationChangedNotify.Instances().RemoveObserver(this);
            OrientationChangedNotify.Instances().AddObserver(this);
        }
        catch (Exception ex) {
            OrientationChangedNotify.Instances().RemoveObserver(this);
            return -1;
        }
        this.isCaptureStarted = false;
        return 0;
    }

    native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    private void saveJPEG(byte[] data) {
        FileOutputStream outStream = null;
        try {
            YuvImage yuvimage = new YuvImage(data, 17, this.mCaptureWidth, this.mCaptureHeight, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            yuvimage.compressToJpeg(new Rect(0, 0, this.mCaptureWidth, this.mCaptureHeight), 80, (OutputStream)baos);
            outStream = new FileOutputStream(String.format("/sdcard/capture_%d.jpg", System.currentTimeMillis()));
            outStream.write(baos.toByteArray());
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void RouteData(byte[] data, int total) {
        int len = total * 2 / 3;
        int half_len = len / 2;
        for (int i = 0; i < half_len; ++i) {
            byte tmp = data[i];
            data[i] = data[len - 1 - i];
            data[len - 1 - i] = tmp;
        }
        int uv_len = total - len;
        int half_uv_len = uv_len / 4;
        for (int i = 0; i < half_uv_len; ++i) {
            byte tmp_u = data[len + i * 2];
            byte tmp_v = data[len + i * 2 + 1];
            data[len + i * 2] = data[total - 1 - i * 2 - 1];
            data[len + i * 2 + 1] = data[total - 1 - i * 2];
            data[total - 1 - i * 2 - 1] = tmp_u;
            data[total - 1 - i * 2] = tmp_v;
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.previewBufferLock.lock();
        if (this.isCaptureRunning && data.length == this.expectedFrameSize) {
            this.ProvideCameraFrame(data, this.expectedFrameSize, this.context);
            if (this.ownsBuffers) {
                camera.addCallbackBuffer(data);
            }
        }
        this.previewBufferLock.unlock();
    }

    public void SetPreviewRotation(int rotation) {
        if (this.camera != null) {
            int resultRotation = 90;
            resultRotation = (rotation - 90 + 360 + (this.currentDevice.orientation - 90)) % 360;
            if (this.currentDevice.index == 0) {
                resultRotation = rotation == 0 ? 90 : (rotation == 90 ? 180 : (rotation == 270 ? 0 : 270));
            }
            Log.d((String)"rotation", (String)("rocation =" + rotation + "set local rotaion " + resultRotation));
            this.camera.setDisplayOrientation(resultRotation);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.captureLock.lock();
        this.isSurfaceReady = true;
        this.surfaceHolder = holder;
        this.tryStartCapture(this.mCaptureWidth, this.mCaptureHeight, this.mCaptureFPS);
        this.captureLock.unlock();
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.isSurfaceReady = false;
    }

    @Override
    public void OnOrientationChanged(int orientation) {
        this.SetPreviewRotation(orientation);
    }
}

