/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Process;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "WEBRTC";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private final Rect srcRect = new Rect();
    private final Rect dstRect = new Rect();
    private float dstTopScale = 0.0f;
    private float dstBottomScale = 1.0f;
    private float dstLeftScale = 0.0f;
    private float dstRightScale = 1.0f;
    private final Rect srcRectRoute = new Rect();

    public ViESurfaceRenderer(SurfaceView view) {
        this.surfaceHolder = view.getHolder();
        if (this.surfaceHolder == null) {
            return;
        }
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    private void changeDestRect(int dstWidth, int dstHeight) {
        this.dstRect.right = (int)((float)this.dstRect.left + this.dstRightScale * (float)dstWidth);
        this.dstRect.bottom = (int)((float)this.dstRect.top + this.dstBottomScale * (float)dstHeight);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int in_width, int in_height) {
        this.changeDestRect(in_width, in_height);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            Rect dst = this.surfaceHolder.getSurfaceFrame();
            if (dst != null) {
                this.changeDestRect(dst.right - dst.left, dst.bottom - dst.top);
                Log.d((String)TAG, (String)("ViESurfaceRender::surfaceCreated dst.left:" + dst.left + " dst.top:" + dst.top + " dst.right:" + dst.right + " dst.bottom:" + dst.bottom + " srcRect.left:" + this.srcRect.left + " srcRect.top:" + this.srcRect.top + " srcRect.right:" + this.srcRect.right + " srcRect.bottom:" + this.srcRect.bottom + " dstRect.left:" + this.dstRect.left + " dstRect.top:" + this.dstRect.top + " dstRect.right:" + this.dstRect.right + " dstRect.bottom:" + this.dstRect.bottom));
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"ViESurfaceRenderer::surfaceDestroyed");
        this.bitmap = null;
        this.byteBuffer = null;
    }

    public Bitmap CreateBitmap(int width, int height) {
        Log.d((String)TAG, (String)("CreateByteBitmap " + width + ":" + height));
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.srcRect.left = 0;
        this.srcRect.top = 0;
        this.srcRect.bottom = height;
        this.srcRect.right = width;
        Log.d((String)TAG, (String)("ViESurfaceRender::CreateBitmap:  srcRect.left:" + this.srcRect.left + " srcRect.top:" + this.srcRect.top + " srcRect.right:" + this.srcRect.right + " srcRect.bottom:" + this.srcRect.bottom + " dstRect.left:" + this.dstRect.left + " dstRect.top:" + this.dstRect.top + " dstRect.right:" + this.dstRect.right + " dstRect.bottom:" + this.dstRect.bottom));
        return this.bitmap;
    }

    public ByteBuffer CreateByteBuffer(int width, int height) {
        Log.d((String)TAG, (String)("CreateByteBuffer " + width + ":" + height));
        if (this.bitmap != null) {
            this.bitmap = null;
        }
        this.bitmap = this.CreateBitmap(width, height);
        if (this.byteBuffer != null) {
            this.byteBuffer = null;
        }
        this.byteBuffer = ByteBuffer.allocateDirect(width * height * 2);
        return this.byteBuffer;
    }

    public void SetCoordinates(float left, float top, float right, float bottom) {
        Log.d((String)TAG, (String)("SetCoordinates " + left + "," + top + ":" + right + "," + bottom));
        this.dstLeftScale = left;
        this.dstTopScale = top;
        this.dstRightScale = right;
        this.dstBottomScale = bottom;
    }

    private void saveBitmapToJPEG(int width, int height) {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        this.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteOutStream);
        try {
            FileOutputStream output = new FileOutputStream(String.format("/sdcard/render_%d.jpg", System.currentTimeMillis()));
            output.write(byteOutStream.toByteArray());
            output.flush();
            output.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DrawByteBuffer() {
        if (this.byteBuffer == null) {
            return;
        }
        this.byteBuffer.rewind();
        this.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        this.DrawBitmap();
    }

    public void DrawBitmap() {
        if (this.bitmap == null) {
            return;
        }
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            int w = this.bitmap.getWidth();
            int h = this.bitmap.getHeight();
            Matrix mtx = new Matrix();
            mtx.postRotate(-90.0f);
            Bitmap rotateBmp = Bitmap.createBitmap((Bitmap)this.bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
            if (null != rotateBmp) {
                this.srcRectRoute.left = 0;
                this.srcRectRoute.top = 0;
                this.srcRectRoute.bottom = rotateBmp.getHeight();
                this.srcRectRoute.right = rotateBmp.getWidth();
                canvas.drawBitmap(rotateBmp, this.srcRectRoute, this.dstRect, null);
            } else {
                canvas.drawBitmap(this.bitmap, this.srcRect, this.dstRect, null);
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

