/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine.video;

import android.content.Context;
import android.view.OrientationEventListener;
import com.ultrapower.mcs.engine.video.IOrientationChangedObserver;
import java.util.ArrayList;

public class OrientationChangedNotify {
    private static OrientationChangedNotify _self = new OrientationChangedNotify();
    private OrientationEventListener _OrientationEventListener;
    private int _lastOrientation;
    private ArrayList<IOrientationChangedObserver> _observers = new ArrayList();

    public static OrientationChangedNotify Instances() {
        return _self;
    }

    protected synchronized void FireOrientationChanged(int orientation) {
        int realOrientation = 90 * Math.round((orientation = orientation > 315 || orientation <= 45 ? 0 : (orientation > 45 && orientation <= 135 ? 90 : (orientation > 135 && orientation <= 225 ? 180 : 270))) / 90);
        if (realOrientation == 360) {
            realOrientation = 0;
        }
        if (this._lastOrientation != realOrientation) {
            for (IOrientationChangedObserver observer : this._observers) {
                observer.OnOrientationChanged(realOrientation);
            }
        }
        this._lastOrientation = realOrientation;
    }

    public synchronized void AddObserver(IOrientationChangedObserver observer) {
        if (observer == null) {
            return;
        }
        if (this._observers.contains(observer)) {
            return;
        }
        this._observers.add(observer);
        observer.OnOrientationChanged(this._lastOrientation);
    }

    public synchronized void RemoveObserver(IOrientationChangedObserver observer) {
        if (observer == null) {
            return;
        }
        if (this._observers.contains(observer)) {
            this._observers.remove(observer);
        }
    }

    public synchronized void Start(Context context) {
        if (this._OrientationEventListener == null) {
            this._OrientationEventListener = new OrientationEventListener(context, 3){

                public void onOrientationChanged(int orientation) {
                    OrientationChangedNotify.this.FireOrientationChanged(orientation);
                }
            };
        }
        if (this._OrientationEventListener.canDetectOrientation()) {
            this._OrientationEventListener.enable();
        }
    }

    public synchronized void Stop() {
        if (this._OrientationEventListener != null) {
            this._OrientationEventListener.disable();
        }
        this._observers.clear();
        this._OrientationEventListener = null;
    }
}

