/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine;

import android.content.Context;
import android.hardware.Camera;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.ultrapower.mcs.engine.AudioCodecInfo;
import com.ultrapower.mcs.engine.AudioCodecType;
import com.ultrapower.mcs.engine.ITransportCallback;
import com.ultrapower.mcs.engine.ITransportListener;
import com.ultrapower.mcs.engine.IVideoObserver;
import com.ultrapower.mcs.engine.NetworkState;
import com.ultrapower.mcs.engine.PhoneInfo;
import com.ultrapower.mcs.engine.TransportType;
import com.ultrapower.mcs.engine.UmcsConfig;
import com.ultrapower.mcs.engine.VideoCodecInfo;
import com.ultrapower.mcs.engine.VideoCodecLevel;
import com.ultrapower.mcs.engine.VideoCodecType;
import com.ultrapower.mcs.engine.video.IOrientationChangedObserver;
import com.ultrapower.mcs.engine.video.OrientationChangedNotify;
import com.ultrapower.mcs.engine.video.ViERenderer;
import com.ultrapower.mcs.engine.video.VideoCaptureDeviceInfoAndroid;
import java.io.File;
import java.util.ArrayList;

public class UMCS
implements IOrientationChangedObserver {
    private Context mContext;
    private static final int PARTTIMERMS = 10;
    private int currentCameraIndex = -1;
    ViewGroup localContainer = null;
    SurfaceView localSv = null;
    private IVideoObserver remoteVideoObserver = null;
    private IVideoObserver localVideoObserver = null;
    private ITransportListener transportListener = null;
    private ITransportCallback transportCallback = null;
    private int oldMode = 0;
    private TransportType transportType;
    boolean localOnTop = false;

    private VideoCodecLevel intToLevel(int level) {
        switch (level) {
            case 1: {
                return VideoCodecLevel.kCodecLevelLSD;
            }
            case 2: {
                return VideoCodecLevel.kCodecLevelSD;
            }
            case 3: {
                return VideoCodecLevel.kCodecLevelHD;
            }
        }
        return VideoCodecLevel.kCodecLevelLSD;
    }

    private NetworkState intToNetworkState(int state) {
        switch (state) {
            case 1: {
                return NetworkState.kNetworkStateLow;
            }
            case 2: {
                return NetworkState.kNetworkStateNormal;
            }
            case 3: {
                return NetworkState.kNetworkStateGood;
            }
        }
        return NetworkState.kNetworkStateLow;
    }

    private void OnLocalVideoLevelChanged(int level) {
        if (this.localVideoObserver == null) {
            return;
        }
        this.localVideoObserver.OnVideoLevelChanged(this.intToLevel(level));
    }

    private void OnLocalNetworkStateChanged(int state) {
        if (this.localVideoObserver == null) {
            return;
        }
        this.localVideoObserver.OnNetworkStateChanged(this.intToNetworkState(state));
    }

    private void OnRemoteVideoLevelChanged(int level) {
        if (this.localVideoObserver == null) {
            return;
        }
        this.remoteVideoObserver.OnVideoLevelChanged(this.intToLevel(level));
    }

    private void OnRemoteNetworkStateChanged(int state) {
        if (this.remoteVideoObserver == null) {
            return;
        }
        this.remoteVideoObserver.OnNetworkStateChanged(this.intToNetworkState(state));
    }

    private void OnDataNeedSend(boolean isAudio, boolean isRtcp, byte[] data) {
        if (this.transportCallback == null) {
            Log.e((String)"umcs", (String)"transport callback is null");
            return;
        }
        if (this.transportType == TransportType.kExternal) {
            this.transportCallback.SendData(data);
        } else if (this.transportType == TransportType.kExternalOriginal) {
            if (isAudio) {
                if (isRtcp) {
                    this.transportCallback.SendAudioRtcp(data);
                } else {
                    this.transportCallback.SendAudioRtp(data);
                }
            } else if (isRtcp) {
                this.transportCallback.SendVideoRtcp(data);
            } else {
                this.transportCallback.SendVideoRtp(data);
            }
        } else {
            Log.e((String)"umcs", (String)"transport type is not external");
        }
    }

    public UMCS(Context context) {
        this.mContext = context;
    }

    public int Init(UmcsConfig config) {
        File destDir;
        TransportType transportType = config.getTransportType();
        if ((transportType == TransportType.kExternal || transportType == TransportType.kExternalOriginal) && config.getTransportCallback() == null) {
            Log.e((String)"umcs", (String)"transport callback is null");
            return -1;
        }
        this.transportCallback = config.getTransportCallback();
        this.transportType = transportType;
        AudioManager _audioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.oldMode = _audioManager.getMode();
        int apiLevel = Integer.parseInt(Build.VERSION.SDK);
        if (apiLevel <= 10) {
            _audioManager.setMode(0);
        } else {
            _audioManager.setMode(3);
        }
        OrientationChangedNotify.Instances().Start(this.mContext);
        this.SetTraceFilePath("not supported", config.getTraceFilter());
        File exterFileDir = this.mContext.getExternalFilesDir(null);
        String strDir = null;
        if (exterFileDir != null && !(destDir = new File(strDir = exterFileDir.toString())).exists()) {
            destDir.mkdirs();
        }
        return this.Init(this.mContext, config.getTransportType().getValue(), config.isMultiMode() ? 1 : 0, strDir);
    }

    private native int Init(Context var1, int var2, int var3, String var4);

    private native int SetTraceFilePath(String var1, int var2);

    public int Terminate() {
        AudioManager _audioManager = (AudioManager)this.mContext.getSystemService("audio");
        _audioManager.setMode(this.oldMode);
        OrientationChangedNotify.Instances().Stop();
        int ret = this.Fini();
        this.localVideoObserver = null;
        this.remoteVideoObserver = null;
        this.transportListener = null;
        return ret;
    }

    private native int Fini();

    public int SetLoudSpeakerEnable(boolean enabled) {
        return this.SetLoudSpeakerEnable(enabled ? 1 : 0);
    }

    private native int SetLoudSpeakerEnable(int var1);

    public native int GetLoudSpeakerEnable();

    public AudioCodecInfo[] GetAudioCodecs() {
        AudioCodecInfo[] cai = new AudioCodecInfo[5];
        cai[0] = new AudioCodecInfo();
        cai[0].codecType = AudioCodecType.iSAC;
        cai[0].plType = 103;
        cai[0].name = "ISAC/16000/1";
        cai[1] = new AudioCodecInfo();
        cai[1].codecType = AudioCodecType.PCMU;
        cai[1].plType = 0;
        cai[1].name = "PCMU/8000/1";
        cai[2] = new AudioCodecInfo();
        cai[2].codecType = AudioCodecType.iLBC;
        cai[2].plType = 102;
        cai[2].name = "ILBC/8000/1";
        cai[3] = new AudioCodecInfo();
        cai[3].codecType = AudioCodecType.AMRWB;
        cai[3].plType = 114;
        cai[3].name = "AMR-WB/16000/1";
        cai[4] = new AudioCodecInfo();
        cai[4].codecType = AudioCodecType.SILK;
        cai[4].plType = 124;
        cai[4].name = "SILK/16000/1";
        return cai;
    }

    public native int GetCaptureDeviceNum();

    public VideoCodecInfo[] GetVideoCodecs() {
        if (this.mContext == null) {
            return null;
        }
        VideoCodecInfo[] vcis = new VideoCodecInfo[]{new VideoCodecInfo()};
        vcis[0].codecName = "VP8";
        vcis[0].codecType = VideoCodecType.VP8;
        vcis[0].pyTpye = 120;
        PhoneInfo pInfo = new PhoneInfo(this.mContext);
        long cpuMaxFrequency = pInfo.getCpuFrequence();
        int cpuNumber = pInfo.getNumCores();
        vcis[0].maxCodecLevel = cpuNumber >= 2 && cpuMaxFrequency > 1200000L ? VideoCodecLevel.kCodecLevelSD : VideoCodecLevel.kCodecLevelLSD;
        return vcis;
    }

    public native int CreateLocalAudio(int var1);

    public int CreateLocalVideo(int sessionId) {
        return this.CreateLocalVideo(sessionId, null);
    }

    private native int CreateLocalVideo(int var1, Object var2);

    public native int CreateRemoteAudio(int var1);

    public int CreateRemoteVideo(int sessionId, ViewGroup container, boolean onTop) {
        SurfaceView sView = ViERenderer.CreateRenderer(this.mContext, true);
        int ret = this.CreateRemoteVideo(sessionId, sView);
        if (ret != -1) {
            container.addView((View)sView);
            sView.setZOrderOnTop(onTop);
        }
        return ret;
    }

    private native int CreateRemoteVideo(int var1, Object var2);

    public native int DeleteLocalAudio(int var1);

    public native int DeleteLocalVideo(int var1);

    public native int DeleteRemoteAudio(int var1);

    public native int DeleteRemoteVideo(int var1);

    public native int StartSendLocalAudio(int var1);

    public native int StartSendLocalVideo(int var1);

    public native int StopSendLocalAudio(int var1);

    public native int StopSendLocalVideo(int var1);

    public native int StartRecvRemoteAudio(int var1);

    public native int StartRecvRemoteVideo(int var1);

    public native int StopRecvRemoteAudio(int var1);

    public native int StopRecvRemoteVideo(int var1);

    public int StopCamera() {
        if (this.currentCameraIndex == -1) {
            return -1;
        }
        this.localContainer.removeAllViews();
        OrientationChangedNotify.Instances().RemoveObserver(this);
        int ret = this.StopCamera(this.currentCameraIndex);
        if (ret == 0) {
            this.currentCameraIndex = -1;
        }
        return ret;
    }

    private native int StopCamera(int var1);

    public int StartCamera(int index, ViewGroup container, boolean onTop) {
        if (index < 0 || index > this.GetCaptureDeviceNum() - 1) {
            Log.e((String)"camera", (String)("camera index is error , index = " + index));
            return -1;
        }
        this.localContainer = container;
        this.localSv = ViERenderer.CreateLocalRenderer(this.mContext);
        int ret = this.StartCamera(index);
        if (ret == -1) {
            Log.e((String)"camera", (String)("start camera error,index = " + index));
            return ret;
        }
        this.currentCameraIndex = index;
        this.localSv.setZOrderOnTop(onTop);
        this.localOnTop = onTop;
        container.removeAllViews();
        container.addView((View)this.localSv);
        OrientationChangedNotify.Instances().RemoveObserver(this);
        OrientationChangedNotify.Instances().AddObserver(this);
        return ret;
    }

    public int CurrentCameraIndex() {
        return this.currentCameraIndex;
    }

    public int ChangeCamera(int index) {
        if (index < 0 || index > this.GetCaptureDeviceNum() - 1) {
            Log.e((String)"camera", (String)("camera index is error , index = " + index));
            return -1;
        }
        if (this.currentCameraIndex == -1) {
            Log.e((String)"camera", (String)"change camera error,camera is not started");
            return -1;
        }
        if (this.currentCameraIndex == index) {
            Log.e((String)"camera", (String)("change camera error,current = " + this.currentCameraIndex + " , change to = " + index));
            return -1;
        }
        int ret = this.StopCamera(this.currentCameraIndex);
        if (ret == -1) {
            Log.e((String)"camera", (String)("stop camera error,current = " + this.currentCameraIndex));
            return -1;
        }
        ret = this.StartCamera(index, this.localContainer, this.localOnTop);
        if (ret == -1) {
            Log.e((String)"camera", (String)("start camera error,index = " + index));
            return -1;
        }
        return 0;
    }

    private int StartCamera(int index) {
        ArrayList<VideoCaptureDeviceInfoAndroid.CameraSupportVideoSize> sizeList = VideoCaptureDeviceInfoAndroid.GetCameraSupportVideoSize();
        if (sizeList.size() > index) {
            VideoCaptureDeviceInfoAndroid.CameraSupportVideoSize csvs = sizeList.get(index);
            this.StartCamera(index, csvs.width, csvs.height);
            return 0;
        }
        return -1;
    }

    private native int StartCamera(int var1, int var2, int var3);

    private native int SetRotation(int var1, int var2);

    private void OnTransportFailed() {
        if (this.transportListener != null) {
            this.transportListener.OnTransportFailed();
        }
    }

    public int StartTransport(String local_ip, int local_port, String remote_ip, int remote_port, Object data, ITransportListener failListener) {
        if (this.transportType == TransportType.kExternal || this.transportType == TransportType.kExternalOriginal) {
            Log.e((String)"umcs", (String)"external transport does not support start transport");
            return -1;
        }
        this.transportListener = failListener;
        Log.i((String)"UMCS.java StartTransport ", (String)("localIp: " + local_ip + " ,remoteIp: " + remote_ip));
        return this.StartTransport(this.transportType.getValue(), local_ip, local_port, remote_ip, remote_port, data);
    }

    private native int StartTransport(int var1, String var2, int var3, String var4, int var5, Object var6);

    public native int StopTransport();

    public native int OnReceiveData(byte[] var1);

    public int OnReceiveAudioRtp(byte[] data) {
        return this.OnReceiveOriginalData(true, false, data);
    }

    public int OnReceiveVideoRtp(byte[] data) {
        return this.OnReceiveOriginalData(false, false, data);
    }

    public int OnReceiveAudioRtcp(byte[] data) {
        return this.OnReceiveOriginalData(true, true, data);
    }

    public int OnReceiveVideoRtcp(byte[] data) {
        return this.OnReceiveOriginalData(false, true, data);
    }

    private native int OnReceiveOriginalData(boolean var1, boolean var2, byte[] var3);

    public native int ChangeLocalRender(Object var1);

    public native int ChangeRemotelRender(Object var1);

    public int SetAudioSendCodec(AudioCodecType codecType) {
        return this.SetSendAudioCodec(codecType.getValue());
    }

    private native int SetSendAudioCodec(int var1);

    public int SetVideoSendCodec(VideoCodecType codecType, VideoCodecLevel level) {
        if (codecType == VideoCodecType.H264) {
            return -1;
        }
        return this.SetLocalVideoSendCodec(codecType.getValue(), level.getValue());
    }

    private native int SetLocalVideoSendCodec(int var1, int var2);

    public int SetLocalVideoObserver(int sessionId, IVideoObserver observer) {
        this.localVideoObserver = observer;
        return 0;
    }

    public int SetRemoteVideoObserver(int sessionId, IVideoObserver observer) {
        this.remoteVideoObserver = observer;
        return 0;
    }

    public native int SetLocalAudioMute(boolean var1);

    public void clear() {
        this.mContext = null;
    }

    public void SetRotation(int rotation) {
        int or = rotation;
        if (this.currentCameraIndex > 1 || this.currentCameraIndex < 0) {
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.currentCameraIndex, (Camera.CameraInfo)info);
        if (this.currentCameraIndex == 1) {
            rotation = (360 + (info.orientation - rotation)) % 360;
        } else if (this.currentCameraIndex == 0) {
            rotation = (360 + (info.orientation + rotation)) % 360;
        }
        Log.d((String)"rotation", (String)("rocation =" + or + "set send rotaion " + rotation));
        this.SetRotation(this.currentCameraIndex, rotation);
    }

    @Override
    public void OnOrientationChanged(int orientation) {
        this.SetRotation(orientation);
    }

    static {
        System.loadLibrary("umcs");
    }
}

