/*
 * Decompiled with CFR 0.152.
 */
package com.ultrapower.mcs.engine;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

class PhoneInfo {
    private static final String TAG = "PhoneInfo";
    private ActivityManager mActivityManager;
    private Context context = null;

    public PhoneInfo(Context context) {
        this.context = context;
    }

    public String[] getTotalMemory() {
        String[] result = new String[]{"", ""};
        this.mActivityManager = (ActivityManager)this.context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        this.mActivityManager.getMemoryInfo(mi);
        long mTotalMem = 0L;
        long mAvailMem = mi.availMem;
        String str1 = "/proc/meminfo";
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            mTotalMem = Integer.valueOf(arrayOfString[1]) * 1024;
            localBufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        result[0] = String.valueOf(mTotalMem);
        result[1] = String.valueOf(mAvailMem);
        return result;
    }

    public String[] getCpuInfo() {
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        String[] cpuInfo = new String[]{"", ""};
        try {
            FileReader fr = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
            str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            for (int i = 2; i < arrayOfString.length; ++i) {
                cpuInfo[0] = cpuInfo[0] + arrayOfString[i] + " ";
            }
            str2 = localBufferedReader.readLine();
            arrayOfString = str2.split("\\s+");
            cpuInfo[1] = cpuInfo[1] + arrayOfString[2];
            localBufferedReader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return cpuInfo;
    }

    public int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            Log.d((String)TAG, (String)("CPU Count: " + files.length));
            return files.length;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"CPU Count: Failed.");
            e.printStackTrace();
            return 1;
        }
    }

    public long getCpuFrequence() {
        try {
            String[] args = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            return Long.parseLong(line);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public long getMinCpuFreq() {
        String result = "";
        try {
            String[] args = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            InputStream in = process.getInputStream();
            byte[] re = new byte[24];
            while (in.read(re) != -1) {
                result = result + new String(re);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            result = "N/A";
        }
        return Long.parseLong(result.trim());
    }

    public long getCurCpuFreq() {
        String result = "N/A";
        try {
            FileReader fr = new FileReader("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            result = text.trim();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Long.parseLong(result);
    }

    public String getCpuName() {
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; ++i) {
            }
            return array[1];
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int[] getCameraInfo() {
        Camera.Size[] size = new Camera.Size[3];
        int height = 0;
        int width = 0;
        int numberCamera = Camera.getNumberOfCameras();
        Camera camera = null;
        for (int i = 0; i < numberCamera; ++i) {
            camera = Camera.open((int)i);
            Camera.Parameters parameters = camera.getParameters();
            size[i] = parameters.getPictureSize();
            camera.release();
            if (size[i].height <= height) continue;
            height = size[i].height;
            width = size[i].width;
        }
        return new int[]{height, width};
    }
}

