/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;

public class Utils {
    private static final String TAG = "Utils";
    private static final String DEBUG_TAG = "GalleryDebug";
    private static final long POLY64REV = -7661587058870466123L;
    private static final long INITIALCRC = -1L;
    private static long[] sCrcTable = new long[256];
    private static final boolean IS_DEBUG_BUILD = Build.TYPE.equals("eng") || Build.TYPE.equals("userdebug");
    private static final String MASK_STRING = "********************************";
    public static final Charset US_ASCII;
    public static final Charset UTF_8;

    public static void assertTrue(boolean cond) {
        if (!cond) {
            throw new AssertionError();
        }
    }

    public static void fail(String message, Object ... args) {
        throw new AssertionError((Object)(args.length == 0 ? message : String.format(message, args)));
    }

    public static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int nextPowerOf2(int n) {
        if (n <= 0 || n > 0x40000000) {
            throw new IllegalArgumentException("n is invalid: " + n);
        }
        --n;
        n |= n >> 16;
        n |= n >> 8;
        n |= n >> 4;
        n |= n >> 2;
        n |= n >> 1;
        return n + 1;
    }

    public static int prevPowerOf2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return Integer.highestOneBit(n);
    }

    public static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static float clamp(float x, float min, float max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static long clamp(long x, long min, long max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static boolean isOpaque(int color2) {
        return color2 >>> 24 == 255;
    }

    public static void swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    public static final long crc64Long(String in) {
        if (in == null || in.length() == 0) {
            return 0L;
        }
        return Utils.crc64Long(Utils.getBytes(in));
    }

    public static final long crc64Long(byte[] buffer) {
        long crc = -1L;
        int n = buffer.length;
        for (int k = 0; k < n; ++k) {
            crc = sCrcTable[((int)crc ^ buffer[k]) & 0xFF] ^ crc >> 8;
        }
        return crc;
    }

    public static byte[] getBytes(String in) {
        byte[] result = new byte[in.length() * 2];
        int output = 0;
        for (char ch : in.toCharArray()) {
            result[output++] = (byte)(ch & 0xFF);
            result[output++] = (byte)(ch >> 8);
        }
        return result;
    }

    public static byte[] intToBytes(int in) {
        byte[] b = new byte[]{(byte)(0xFF & in), (byte)((0xFF00 & in) >> 8), (byte)((0xFF0000 & in) >> 16), (byte)((0xFF000000 & in) >> 24)};
        return b;
    }

    public static byte[] longToBytes(long in) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(in >>> 56 - i * 8);
        }
        return b;
    }

    public static int bytesToInt(byte[] in) {
        if (in.length != 4) {
            return 0;
        }
        return in[0] << 24 & 0xFF000000 | in[1] << 16 & 0xFF0000 | in[2] << 8 & 0xFF00 | in[3] << 0 & 0xFF;
    }

    public static long bytesToLong(byte[] in) {
        if (in.length != 8) {
            return 0L;
        }
        long temp = 0L;
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res <<= 8;
            temp = in[i] & 0xFF;
            res |= temp;
        }
        return res;
    }

    public static String bytesToString(byte[] in) {
        if (in == null) {
            return null;
        }
        return new String(in);
    }

    public static byte[] stringToBytes(String in) {
        if (in == null) {
            return null;
        }
        return in.getBytes();
    }

    public static void closeSilently(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"close fail", (Throwable)t);
        }
    }

    public static int compare(long a, long b) {
        return a < b ? -1 : (a == b ? 0 : 1);
    }

    public static int ceilLog2(float value) {
        int i;
        for (i = 0; i < 31 && !((float)(1 << i) >= value); ++i) {
        }
        return i;
    }

    public static int floorLog2(float value) {
        int i;
        for (i = 0; i < 31 && !((float)(1 << i) > value); ++i) {
        }
        return i - 1;
    }

    public static void closeSilently(ParcelFileDescriptor fd) {
        try {
            if (fd != null) {
                fd.close();
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"fail to close", (Throwable)t);
        }
    }

    public static void closeSilently(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"fail to close", (Throwable)t);
        }
    }

    public static float interpolateAngle(float source, float target, float progress) {
        float result;
        float diff = target - source;
        if (diff < 0.0f) {
            diff += 360.0f;
        }
        if (diff > 180.0f) {
            diff -= 360.0f;
        }
        return (result = source + diff * progress) < 0.0f ? result + 360.0f : result;
    }

    public static float interpolateScale(float source, float target, float progress) {
        return source + progress * (target - source);
    }

    public static String ensureNotNull(String value) {
        return value == null ? "" : value;
    }

    public static float parseFloatSafely(String content, float defaultValue) {
        if (content == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(content);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int parseIntSafely(String content, int defaultValue) {
        if (content == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isNullOrEmpty(String exifMake) {
        return TextUtils.isEmpty((CharSequence)exifMake);
    }

    public static void waitWithoutInterrupt(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException e) {
            Log.w((String)TAG, (String)("unexpected interrupt: " + object));
        }
    }

    public static boolean handleInterrruptedException(Throwable e) {
        if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static String escapeXml(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getUserAgent(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("getPackageInfo failed");
        }
        return String.format("%s/%s; %s/%s/%s/%s; %s/%s/%s", packageInfo.packageName, packageInfo.versionName, Build.BRAND, Build.DEVICE, Build.MODEL, Build.ID, Build.VERSION.SDK_INT, Build.VERSION.RELEASE, Build.VERSION.INCREMENTAL);
    }

    public static String[] copyOf(String[] source, int newSize) {
        String[] result = new String[newSize];
        newSize = Math.min(source.length, newSize);
        System.arraycopy(source, 0, result, 0, newSize);
        return result;
    }

    public static String maskDebugInfo(Object info) {
        if (info == null) {
            return null;
        }
        String s = info.toString();
        int length = Math.min(s.length(), MASK_STRING.length());
        return IS_DEBUG_BUILD ? s : MASK_STRING.substring(0, length);
    }

    public static void debug(String message, Object ... args) {
        Log.v((String)DEBUG_TAG, (String)String.format(message, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        try {
            int count;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string2 = writer.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("not a readable directory: " + dir);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Utils.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete file: " + file);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long part = i;
            for (int j = 0; j < 8; ++j) {
                long x = ((int)part & 1) != 0 ? -7661587058870466123L : 0L;
                part = part >> 1 ^ x;
            }
            Utils.sCrcTable[i] = part;
        }
        US_ASCII = Charset.forName("US-ASCII");
        UTF_8 = Charset.forName("UTF-8");
    }
}

