/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IoUtils {
    public static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static long copy(File in, OutputStream out) throws IOException {
        return IoUtils.copy((InputStream)new FileInputStream(in), out);
    }

    public static long copy(InputStream in, File out) throws IOException {
        return IoUtils.copy(in, (OutputStream)new FileOutputStream(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream input, OutputStream output) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            output.flush();
            long l = count;
            return l;
        }
        finally {
            IoUtils.closeStream(input);
            IoUtils.closeStream(output);
        }
    }
}

