/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.os.Build;
import android.util.FloatMath;
import android.util.Log;
import com.sea_monster.core.resource.model.ImageInfo;
import com.sea_monster.core.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class ImageUtils {
    private static final String TAG = "BitmapUtils";
    private static final int DEFAULT_JPEG_QUALITY = 90;
    public static final int UNCONSTRAINED = -1;

    public static int getOrientation(String path) {
        int orientation = -1;
        try {
            ExifInterface EXIF = new ExifInterface(path);
            orientation = EXIF.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return orientation;
    }

    public static int getOrientation(File file) {
        int orientation = -1;
        try {
            ExifInterface EXIF = new ExifInterface(file.getPath());
            orientation = EXIF.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return orientation;
    }

    public static void repairOrientation(File file) {
        int orientation = 0;
        try {
            ExifInterface EXIF = new ExifInterface(file.getPath());
            orientation = EXIF.getAttributeInt("Orientation", 0);
            if (orientation == 0) {
                EXIF.setAttribute("Orientation", "1");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void repairOrientation(String path) {
        int orientation = 0;
        try {
            ExifInterface EXIF = new ExifInterface(path);
            orientation = EXIF.getAttributeInt("Orientation", 0);
            if (orientation == 0) {
                EXIF.setAttribute("Orientation", "1");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap rotateToPortrait(Bitmap bitmap, int ori) {
        Matrix matrix = new Matrix();
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (ori == 6 || ori == 8 || ori == 5 || ori == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (ori) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            default: {
                return bitmap;
            }
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Matrix getRotateMatrix(Bitmap bitmap, int ori) {
        Matrix matrix = new Matrix();
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (ori == 6 || ori == 8 || ori == 5 || ori == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (ori) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        return matrix;
    }

    public static int computeSampleSize(int width, int height, int minSideLength, int maxNumOfPixels) {
        int initialSize = ImageUtils.computeInitialSampleSize(width, height, minSideLength, maxNumOfPixels);
        return initialSize <= 8 ? Utils.nextPowerOf2(initialSize) : (initialSize + 7) / 8 * 8;
    }

    private static int computeInitialSampleSize(int w, int h, int minSideLength, int maxNumOfPixels) {
        int lowerBound;
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        int n = lowerBound = maxNumOfPixels == -1 ? 1 : (int)FloatMath.ceil((float)FloatMath.sqrt((float)((float)(w * h) / (float)maxNumOfPixels)));
        if (minSideLength == -1) {
            return lowerBound;
        }
        int sampleSize = Math.min(w / minSideLength, h / minSideLength);
        return Math.max(sampleSize, lowerBound);
    }

    public static int computeSampleSizeLarger(int w, int h, int minSideLength) {
        int initialSize = Math.max(w / minSideLength, h / minSideLength);
        if (initialSize <= 1) {
            return 1;
        }
        return initialSize <= 8 ? Utils.prevPowerOf2(initialSize) : initialSize / 8 * 8;
    }

    public static int computeSampleSizeLarger(float scale) {
        int initialSize = (int)FloatMath.floor((float)(1.0f / scale));
        if (initialSize <= 1) {
            return 1;
        }
        return initialSize <= 8 ? Utils.prevPowerOf2(initialSize) : initialSize / 8 * 8;
    }

    public static int computeSampleSize(float scale) {
        Utils.assertTrue(scale > 0.0f);
        int initialSize = Math.max(1, (int)FloatMath.ceil((float)(1.0f / scale)));
        return initialSize <= 8 ? Utils.nextPowerOf2(initialSize) : (initialSize + 7) / 8 * 8;
    }

    public static Bitmap resizeBitmapByScale(Bitmap bitmap, float scale, boolean recycle) {
        int width = Math.round((float)bitmap.getWidth() * scale);
        int height = Math.round((float)bitmap.getHeight() * scale);
        if (width == bitmap.getWidth() && height == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)ImageUtils.getConfig(bitmap));
        Canvas canvas = new Canvas(target);
        canvas.scale(scale, scale);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        if (recycle) {
            bitmap.recycle();
        }
        return target;
    }

    private static Bitmap.Config getConfig(Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        return config;
    }

    public static Bitmap resizeDownBySideLength(Bitmap bitmap, int maxLength, boolean recycle) {
        int srcHeight;
        int srcWidth = bitmap.getWidth();
        float scale = Math.min((float)maxLength / (float)srcWidth, (float)maxLength / (float)(srcHeight = bitmap.getHeight()));
        if (scale >= 1.0f) {
            return bitmap;
        }
        return ImageUtils.resizeBitmapByScale(bitmap, scale, recycle);
    }

    public static Bitmap resizeAndCropCenter(Bitmap bitmap, int size, boolean recycle) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (w == size && h == size) {
            return bitmap;
        }
        float scale = (float)size / (float)Math.min(w, h);
        Bitmap target = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)ImageUtils.getConfig(bitmap));
        int width = Math.round(scale * (float)bitmap.getWidth());
        int height = Math.round(scale * (float)bitmap.getHeight());
        Canvas canvas = new Canvas(target);
        canvas.translate((float)(size - width) / 2.0f, (float)(size - height) / 2.0f);
        canvas.scale(scale, scale);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        if (recycle) {
            bitmap.recycle();
        }
        return target;
    }

    public static ImageInfo getImageInfo(String path) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setOrientation(ImageUtils.getOrientation(path));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        imageInfo.setHeight(options.outHeight);
        imageInfo.setWidth(options.outWidth);
        return imageInfo;
    }

    public static ImageInfo getImageInfo(File file) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setOrientation(ImageUtils.getOrientation(file));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        imageInfo.setHeight(options.outHeight);
        imageInfo.setWidth(options.outWidth);
        return imageInfo;
    }

    public static void recycleSilently(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        try {
            bitmap.recycle();
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"unable recycle bitmap", (Throwable)t);
        }
    }

    public static Bitmap rotateBitmap(Bitmap source, int rotation, boolean recycle) {
        if (rotation == 0) {
            return source;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        Matrix m = new Matrix();
        m.postRotate((float)rotation);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        if (recycle) {
            source.recycle();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap createVideoThumbnail(String filePath) {
        Class<?> clazz = null;
        Object instance = null;
        try {
            Bitmap bitmap;
            clazz = Class.forName("android.media.MediaMetadataRetriever");
            instance = clazz.newInstance();
            Method method = clazz.getMethod("setDataSource", String.class);
            method.invoke(instance, filePath);
            if (Build.VERSION.SDK_INT <= 9) {
                Bitmap bitmap2 = (Bitmap)clazz.getMethod("captureFrame", new Class[0]).invoke(instance, new Object[0]);
                return bitmap2;
            }
            byte[] data = (byte[])clazz.getMethod("getEmbeddedPicture", new Class[0]).invoke(instance, new Object[0]);
            if (data != null && (bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length)) != null) {
                Bitmap bitmap3 = bitmap;
                return bitmap3;
            }
            Bitmap bitmap4 = (Bitmap)clazz.getMethod("getFrameAtTime", new Class[0]).invoke(instance, new Object[0]);
            return bitmap4;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            return null;
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        finally {
            try {
                if (instance != null) {
                    clazz.getMethod("release", new Class[0]).invoke(instance, new Object[0]);
                }
            }
            catch (Exception ignored) {}
        }
    }

    public static byte[] compressToBytes(Bitmap bitmap) {
        return ImageUtils.compressToBytes(bitmap, 90);
    }

    public static byte[] compressToBytes(Bitmap bitmap, int quality) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static boolean isSupportedByRegionDecoder(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return (mimeType = mimeType.toLowerCase(Locale.getDefault())).startsWith("image/") && !mimeType.equals("image/gif") && !mimeType.endsWith("bmp");
    }

    public static boolean isRotationSupported(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        mimeType = mimeType.toLowerCase(Locale.getDefault());
        return mimeType.equals("image/jpeg");
    }
}

