/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.utils;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileUtils {
    static final String TAG = "file_sys";
    public static final String NOMEDIA = ".nomedia";

    public static String getExtendFileNameNoPoint(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int pointStart = path.lastIndexOf(".");
        if (pointStart != -1) {
            return path.substring(pointStart + 1);
        }
        return "";
    }

    public static String getFileNameWithoutExtName(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int pointStart = path.lastIndexOf(".");
        if (pointStart != -1) {
            return path.substring(0, pointStart);
        }
        return path;
    }

    public static final void createDirectory(File storageDirectory, boolean nomedia) {
        if (!storageDirectory.exists()) {
            Log.d((String)TAG, (String)("Trying to create storageDirectory: " + String.valueOf(storageDirectory.mkdirs())));
            Log.d((String)TAG, (String)("Exists: " + storageDirectory + " " + String.valueOf(storageDirectory.exists())));
            Log.d((String)TAG, (String)("State: " + Environment.getExternalStorageState()));
            Log.d((String)TAG, (String)("Isdir: " + storageDirectory + " " + String.valueOf(storageDirectory.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + storageDirectory + " " + String.valueOf(storageDirectory.canRead())));
            Log.d((String)TAG, (String)("Writable: " + storageDirectory + " " + String.valueOf(storageDirectory.canWrite())));
            File tmp = storageDirectory.getParentFile();
            Log.d((String)TAG, (String)("Exists: " + tmp + " " + String.valueOf(tmp.exists())));
            Log.d((String)TAG, (String)("Isdir: " + tmp + " " + String.valueOf(tmp.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + tmp + " " + String.valueOf(tmp.canRead())));
            Log.d((String)TAG, (String)("Writable: " + tmp + " " + String.valueOf(tmp.canWrite())));
            tmp = tmp.getParentFile();
            Log.d((String)TAG, (String)("Exists: " + tmp + " " + String.valueOf(tmp.exists())));
            Log.d((String)TAG, (String)("Isdir: " + tmp + " " + String.valueOf(tmp.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + tmp + " " + String.valueOf(tmp.canRead())));
            Log.d((String)TAG, (String)("Writable: " + tmp + " " + String.valueOf(tmp.canWrite())));
        }
        if (nomedia) {
            File nomediaFile = new File(storageDirectory, NOMEDIA);
            if (!nomediaFile.exists()) {
                try {
                    Log.d((String)TAG, (String)("Created file: " + nomediaFile + " " + String.valueOf(nomediaFile.createNewFile())));
                }
                catch (IOException e) {
                    Log.d((String)TAG, (String)"Unable to create .nomedia file for some reason.", (Throwable)e);
                }
            }
            if (!storageDirectory.isDirectory() || !nomediaFile.exists()) {
                Log.d((String)TAG, (String)"Unable to create .nomedia file for some reason.");
            }
        }
    }

    public static void Channel(File f1, File f2) throws Exception {
        int length = 524288;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        FileChannel inC = in.getChannel();
        FileChannel outC = out.getChannel();
        ByteBuffer b = null;
        while (true) {
            if (inC.position() == inC.size()) {
                inC.close();
                outC.close();
                return;
            }
            length = inC.size() - inC.position() < (long)length ? (int)(inC.size() - inC.position()) : 524288;
            b = ByteBuffer.allocateDirect(length);
            inC.read(b);
            b.flip();
            outC.write(b);
            outC.force(false);
        }
    }
}

