/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.model;

import android.net.Uri;
import android.os.Parcel;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.StoreStatusCallback;
import com.sea_monster.core.resource.model.Resource;
import com.sea_monster.core.resource.model.StoreStatus;
import java.io.File;
import java.lang.ref.WeakReference;

public class RequestResource
extends Resource
implements StoreStatusCallback {
    private StoreStatus mStoreStatus;
    WeakReference<StoreStatusCallback> mListener;

    public RequestResource(String uriPath) {
        super(uriPath);
    }

    public RequestResource(Uri uri) {
        super(uri);
    }

    public RequestResource(Parcel in) {
        super(in);
    }

    public void registeredStatusChangeListener(StoreStatusCallback listener) {
        this.mListener = new WeakReference<StoreStatusCallback>(listener);
    }

    public void unRegisteredStatusChangeListener() {
        this.mListener = null;
    }

    public StoreStatus getStoreStatus() {
        return this.mStoreStatus;
    }

    @Override
    public void onComplete(AbstractHttpRequest<File> request, File obj) {
        if (this.mListener != null && this.mListener.get() != null) {
            ((StoreStatusCallback)this.mListener.get()).onComplete(request, obj);
        }
    }

    @Override
    public void onFailure(AbstractHttpRequest<File> request, BaseException e) {
        if (this.mListener != null && this.mListener.get() != null) {
            ((StoreStatusCallback)this.mListener.get()).onFailure(request, e);
        }
    }

    @Override
    public void statusCallback(StoreStatus obj) {
        if (this.mStoreStatus != obj) {
            this.mStoreStatus = obj;
        }
        if (this.mListener != null && this.mListener.get() != null) {
            ((StoreStatusCallback)this.mListener.get()).statusCallback(obj);
        }
    }
}

