/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.sea_monster.core.resource.model.Resource;
import com.sea_monster.core.utils.ParcelUtils;

public class CompressedResource
extends Resource {
    private int height;
    private int width;
    private boolean isCrop;
    Resource mResource;
    Uri mCompressUri;
    public static final Parcelable.Creator<CompressedResource> CREATOR = new Parcelable.Creator<CompressedResource>(){

        public CompressedResource createFromParcel(Parcel in) {
            return new CompressedResource(in);
        }

        public CompressedResource[] newArray(int size) {
            return new CompressedResource[size];
        }
    };

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public CompressedResource(Resource res, int width, int height, boolean isCrop) {
        this.mResource = res;
        this.height = height;
        this.width = width;
        this.isCrop = isCrop;
        this.mCompressUri = res.getUri().buildUpon().appendQueryParameter("thum", width + "x" + height).appendQueryParameter("crop", String.valueOf(isCrop)).build();
    }

    public CompressedResource(Resource res, int width, int height) {
        this(res, width, height, true);
    }

    public CompressedResource(Resource res) {
        this.mResource = res;
    }

    @Override
    public Uri getUri() {
        return this.mCompressUri;
    }

    public Resource getOriResource() {
        return this.mResource;
    }

    @Override
    public int hashCode() {
        return this.getUri().hashCode();
    }

    public boolean isCrop() {
        return this.isCrop;
    }

    public void setCrop(boolean crop) {
        this.isCrop = crop;
    }

    public CompressedResource(Parcel in) {
        this.mResource = ParcelUtils.readFromParcel(in, Resource.class);
        this.height = ParcelUtils.readIntFromParcel(in);
        this.width = ParcelUtils.readIntFromParcel(in);
        this.isCrop = ParcelUtils.readIntFromParcel(in) == 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.mResource);
        ParcelUtils.writeToParcel(dest, this.height);
        ParcelUtils.writeToParcel(dest, this.width);
        ParcelUtils.writeToParcel(dest, this.isCrop ? 1 : 0);
    }
}

