/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.io;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.exception.InternalException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.HttpHandler;
import com.sea_monster.core.network.ResRequest;
import com.sea_monster.core.network.StoreStatusCallback;
import com.sea_monster.core.resource.io.IFileSysHandler;
import com.sea_monster.core.resource.model.LocalResource;
import com.sea_monster.core.resource.model.RequestResource;
import com.sea_monster.core.resource.model.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceRemoteWrapper
extends Observable {
    private static final String TAG = "RemoteResourceManager";
    private final boolean DEBUG = false;
    private IFileSysHandler fileSysHandler;
    private HttpHandler httpHandler;
    private Map<Resource, AbstractHttpRequest> onRequestMapping;
    private Context context;

    public ResourceRemoteWrapper(Context context, IFileSysHandler fileHandler, HttpHandler httpHandler) {
        this.context = context;
        this.fileSysHandler = fileHandler;
        this.httpHandler = httpHandler;
        this.onRequestMapping = new ConcurrentHashMap<Resource, AbstractHttpRequest>();
    }

    public boolean exists(Resource resource) {
        if (this.onRequestMapping.containsKey(resource)) {
            return false;
        }
        if (resource instanceof LocalResource) {
            return true;
        }
        return this.fileSysHandler.exists(resource.getUri());
    }

    public Uri getFileUri(Resource res) {
        return Uri.fromFile((File)this.getFile(res));
    }

    public boolean exists(Uri uri) {
        return this.fileSysHandler.exists(uri);
    }

    public File getFile(Uri uri) {
        return this.fileSysHandler.getFile(uri);
    }

    public File getFile(Resource res) {
        return this.fileSysHandler.getFile(res.getUri());
    }

    public InputStream getInputStream(Resource res) {
        InputStream resultStream = null;
        resultStream = this.getInputStream(res.getUri());
        return resultStream;
    }

    public InputStream getInputStream(Uri uri) {
        try {
            return this.fileSysHandler.getInputStream(uri);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
    }

    public void put(Resource res, InputStream stream) {
        try {
            this.fileSysHandler.store(res.getUri(), stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Bitmap getBitmap(Resource res) throws BaseException {
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)this.getInputStream(res));
        }
        catch (OutOfMemoryError e1) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inPreferredConfig = Bitmap.Config.RGB_565;
                options.inSampleSize = 2;
                bitmap = BitmapFactory.decodeStream((InputStream)this.getInputStream(res), null, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError e) {
                throw new InternalException(2004, (Throwable)e);
            }
        }
        return bitmap;
    }

    public AbstractHttpRequest<File> request(final Resource img) throws URISyntaxException {
        if (img instanceof RequestResource) {
            return this.request((RequestResource)img);
        }
        if (this.onRequestMapping.containsKey(img)) {
            return this.onRequestMapping.get(img);
        }
        String scheme = img.getUri().getScheme().toLowerCase();
        if (scheme.equals("http") || scheme.equals("https")) {
            ResRequest resRequest = new ResRequest(img, this.fileSysHandler){

                @Override
                public void onComplete(AbstractHttpRequest<File> request, File obj) {
                    ResourceRemoteWrapper.this.setChanged();
                    ResourceRemoteWrapper.this.onRequestMapping.remove(img);
                    ResourceRemoteWrapper.this.notifyObservers(img);
                }

                @Override
                public void onFailure(AbstractHttpRequest<File> request, BaseException e) {
                    ResourceRemoteWrapper.this.onRequestMapping.remove(img);
                    ResourceRemoteWrapper.this.fileSysHandler.delFile(img.getUri());
                    ResourceRemoteWrapper.this.setChanged();
                    e.printStackTrace();
                }
            };
            AbstractHttpRequest<File> httpRequest = resRequest.obtainRequest();
            this.onRequestMapping.put(img, httpRequest);
            this.httpHandler.executeRequest(httpRequest);
            return httpRequest;
        }
        throw new RuntimeException("request only support http");
    }

    public AbstractHttpRequest<File> request(RequestResource img) throws URISyntaxException {
        return this.request(img, img);
    }

    public AbstractHttpRequest<File> request(final Resource img, final StoreStatusCallback callback) throws URISyntaxException {
        if (this.onRequestMapping.containsKey(img)) {
            return this.onRequestMapping.get(img);
        }
        ResRequest resRequest = new ResRequest(img, this.fileSysHandler, callback){

            @Override
            public void onComplete(AbstractHttpRequest<File> request, File obj) {
                Log.d((String)"AbstractHttpRequest", (String)"onComplete");
                ResourceRemoteWrapper.this.setChanged();
                ResourceRemoteWrapper.this.onRequestMapping.remove(img);
                callback.onComplete(request, obj);
                ResourceRemoteWrapper.this.notifyObservers(img);
            }

            @Override
            public void onFailure(AbstractHttpRequest<File> request, BaseException e) {
                Log.d((String)"AbstractHttpRequest", (String)"onFailure");
                ResourceRemoteWrapper.this.onRequestMapping.remove(img);
                ResourceRemoteWrapper.this.fileSysHandler.delFile(img.getUri());
                ResourceRemoteWrapper.this.setChanged();
                callback.onFailure(request, e);
                e.printStackTrace();
            }
        };
        AbstractHttpRequest<File> httpRequest = resRequest.obtainRequest();
        this.onRequestMapping.put(img, httpRequest);
        this.httpHandler.executeRequest(httpRequest);
        return httpRequest;
    }

    public void invalidate(URI uri) {
        this.fileSysHandler.invalidate(Uri.parse((String)uri.toString()));
    }

    public void shutdown() {
        this.fileSysHandler.cleanup();
    }

    public void cancel(Resource resource) {
        if (this.onRequestMapping.containsKey(resource)) {
            this.httpHandler.cancelRequest(this.onRequestMapping.get(resource));
        }
    }

    public void remove(Uri uri) {
        this.fileSysHandler.delFile(uri);
    }

    public void remove(Resource res) {
        this.fileSysHandler.delFile(res.getUri());
    }
}

