/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.io;

import android.net.Uri;
import android.util.Log;
import com.sea_monster.core.network.StoreStatusCallback;
import com.sea_monster.core.resource.io.IFileSysHandler;
import com.sea_monster.core.resource.model.StoreStatus;
import com.sea_monster.core.utils.FileUtils;
import com.sea_monster.core.utils.Md5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ThreadPoolExecutor;

public class FileSysHandler
implements IFileSysHandler {
    private static final String TAG = "FileSysHandler";
    public static final String SETTING = "settting";
    private static final int MIN_FILE_SIZE_IN_BYTES = 100;
    private File mStorageDirectory;
    ThreadPoolExecutor executor;
    private File baseDirectory;

    public FileSysHandler(ThreadPoolExecutor executor, File environmentPath, String dirPath, String name) {
        this.executor = executor;
        this.baseDirectory = new File(environmentPath, dirPath);
        File storageDirectory = new File(this.baseDirectory, name);
        FileUtils.createDirectory(storageDirectory, true);
        this.mStorageDirectory = storageDirectory;
        this.cleanupSimple();
    }

    @Override
    public boolean exists(Uri uri) {
        return this.getFile(uri).exists();
    }

    @Override
    public File getFile(Uri uri) {
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return new File(uri.getPath());
        }
        return new File(this.mStorageDirectory.toString() + File.separator + Md5.encode(uri.toString()));
    }

    public File getTempFile(Uri uri) {
        return new File(this.mStorageDirectory.toString() + File.separator + Md5.encode(uri.toString()) + ".tmp");
    }

    @Override
    public String getPath(Uri uri) {
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return uri.getPath();
        }
        return this.mStorageDirectory.toString() + File.separator + Md5.encode(uri.toString());
    }

    @Override
    public InputStream getInputStream(Uri uri) throws IOException {
        return new FileInputStream(this.getFile(uri));
    }

    @Override
    public File store(Uri uri, InputStream is) throws IOException {
        is = new BufferedInputStream(is);
        File result = this.getTempFile(uri);
        try {
            int count;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(result));
            byte[] b = new byte[2048];
            while ((count = is.read(b)) > 0) {
                ((OutputStream)os).write(b, 0, count);
            }
            ((OutputStream)os).close();
            File f = this.getFile(uri);
            result.renameTo(f);
            result = f;
        }
        catch (IOException e) {
            this.delFile(result);
            throw e;
        }
        return result;
    }

    @Override
    public File store(Uri uri, InputStream is, long contentLength, StoreStatusCallback statusCallback) throws IOException {
        is = new BufferedInputStream(is);
        File result = this.getTempFile(uri);
        try {
            int count;
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(result));
            StoreStatus status = new StoreStatus((int)contentLength);
            byte[] b = new byte[2048];
            while ((count = is.read(b)) > 0) {
                ((OutputStream)os).write(b, 0, count);
                status.addReceivedSize(count);
                statusCallback.statusCallback(status);
            }
            ((OutputStream)os).close();
            File f = this.getFile(uri);
            result.renameTo(f);
            result = f;
        }
        catch (IOException e) {
            this.delFile(result);
            throw e;
        }
        return result;
    }

    @Override
    public void invalidate(Uri uri) {
        this.getFile(uri).delete();
    }

    @Override
    public void cleanup() {
        String[] children = this.mStorageDirectory.list();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(this.mStorageDirectory, children[i]);
                if (child.equals(new File(this.mStorageDirectory, ".nomedia")) || child.length() > 100L) continue;
                child.delete();
            }
        }
    }

    public void cleanupSimple() {
        int maxNumFiles = 1000;
        int numFilesToDelete = 50;
        String[] children = this.mStorageDirectory.list();
        if (children != null && children.length > 1000) {
            int i;
            int m = i - 50;
            for (i = children.length - 1; i > m; --i) {
                File child = new File(this.mStorageDirectory, children[i]);
                child.delete();
            }
        }
    }

    @Override
    public void clear() {
        this.delFile(this.mStorageDirectory);
    }

    @Override
    public void clear(byte type) {
        String dirName = null;
        switch (type) {
            case 0: {
                dirName = "img";
                break;
            }
            case 1: {
                dirName = "cache";
            }
        }
        if (dirName == null) {
            return;
        }
        File delDir = new File(this.mStorageDirectory, dirName);
        this.delFileOfDir(delDir);
    }

    private void delFile(File path) {
        if (path.isFile()) {
            Log.d((String)TAG, (String)("Deleting: " + path.getName()));
            path.delete();
        } else if (path.isDirectory()) {
            String[] children;
            for (String string2 : children = path.list()) {
                File child = new File(path, string2);
                this.delFile(child);
            }
            path.delete();
        }
    }

    @Override
    public void delFile(Uri uri) {
        File checkFile = this.getFile(uri);
        if (checkFile.exists()) {
            this.delFile(checkFile);
        }
    }

    private void delFileOfDir(File path) {
        if (path.isDirectory()) {
            String[] children;
            for (String string2 : children = path.list()) {
                File child = new File(path, string2);
                this.delFile(child);
            }
        }
    }

    @Override
    public String saveTo(File file, String name) {
        File newFile = new File(this.mStorageDirectory, name);
        file.renameTo(newFile);
        return newFile.getPath();
    }

    @Override
    public File getWorldWideFile() throws IOException {
        File file = new File(this.baseDirectory.toString() + File.separator + System.currentTimeMillis() + ".jpg");
        file.createNewFile();
        return file;
    }

    @Override
    public void create(Uri uri) throws IOException {
        File newFile = new File(this.mStorageDirectory, Md5.encode(uri.toString()));
        if (!newFile.exists()) {
            newFile.createNewFile();
        }
    }
}

