/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.compress;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.provider.MediaStore;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.resource.compress.AbstractCompressRequest;
import com.sea_monster.core.resource.compress.IResourceCompressHandler;
import com.sea_monster.core.resource.io.IFileSysHandler;
import com.sea_monster.core.resource.model.LocalResource;
import java.io.InputStream;

public class ResourceCompressHandler
implements IResourceCompressHandler {
    private Context context;
    private IFileSysHandler fileSysHandler;

    public ResourceCompressHandler(Context context, IFileSysHandler fileSysHandler) {
        this.context = context;
        this.fileSysHandler = fileSysHandler;
    }

    @Override
    @TargetApi(value=10)
    public Bitmap compressResourceWithCrop(AbstractCompressRequest request) {
        Bitmap result = null;
        if (request.getResource() instanceof LocalResource) {
            int width;
            int height;
            int tmp;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            Bitmap bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)this.context.getContentResolver(), (long)((LocalResource)request.getResource()).getImageId(), (int)1, (BitmapFactory.Options)options);
            Matrix matrix = new Matrix();
            int w = bitmap.getWidth();
            int h = bitmap.getHeight();
            if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
                tmp = w;
                w = h;
                h = tmp;
            }
            switch (request.getOptions().getOrientation()) {
                case 6: {
                    matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                    break;
                }
                case 3: {
                    matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                    break;
                }
                case 8: {
                    matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                    break;
                }
                case 2: {
                    matrix.preScale(-1.0f, 1.0f);
                    break;
                }
                case 4: {
                    matrix.preScale(1.0f, -1.0f);
                    break;
                }
                case 5: {
                    matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                    matrix.preScale(1.0f, -1.0f);
                    break;
                }
                case 7: {
                    matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                    matrix.preScale(1.0f, -1.0f);
                }
            }
            if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
                tmp = request.getOptions().getThumbWidth();
                request.getOptions().setThumbWidth(request.getOptions().getThumbHeight());
                request.getOptions().setThumbHeight(tmp);
            }
            int x = 0;
            int y = 0;
            if (request.getOptions().getThumbWidth() > bitmap.getWidth() && request.getOptions().getThumbHeight() > bitmap.getHeight()) {
                height = bitmap.getHeight();
                width = bitmap.getWidth();
            } else if (request.getOptions().getThumbWidth() > bitmap.getWidth()) {
                height = bitmap.getWidth() * request.getOptions().getThumbHeight() / request.getOptions().getThumbWidth();
                width = bitmap.getWidth();
                x = 0;
                y = bitmap.getHeight() - request.getOptions().getThumbHeight();
                y >>= 1;
            } else if (request.getOptions().getThumbHeight() > bitmap.getHeight()) {
                width = bitmap.getHeight() * request.getOptions().getThumbWidth() / request.getOptions().getThumbHeight();
                height = bitmap.getHeight();
                y = 0;
                x = bitmap.getWidth() - request.getOptions().getThumbWidth();
                x >>= 1;
            } else {
                int heightMix;
                int widthMix = request.getOptions().getThumbWidth() * bitmap.getHeight();
                if (widthMix == (heightMix = request.getOptions().getThumbHeight() * bitmap.getWidth())) {
                    width = request.getOptions().getThumbWidth();
                    height = request.getOptions().getThumbHeight();
                } else if (widthMix > heightMix) {
                    height = heightMix / request.getOptions().getThumbWidth();
                    width = request.getOptions().getThumbWidth();
                    y = bitmap.getHeight() - height;
                    y >>= 1;
                } else {
                    width = widthMix / request.getOptions().getThumbHeight();
                    height = request.getOptions().getThumbHeight();
                    x = bitmap.getWidth() - width;
                    x >>= 1;
                }
            }
            float scale = 0.0f;
            scale = width > height ? (float)width / (float)bitmap.getWidth() : (float)height / (float)bitmap.getHeight();
            matrix.postScale(scale, scale);
            result = request.getOptions().isCrop() ? Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)(bitmap.getWidth() - (x << 1)), (int)(bitmap.getHeight() - (y << 1)), (Matrix)matrix, (boolean)true) : Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        } else {
            int sampleSize;
            if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
                int tmp = request.getOptions().getThumbWidth();
                request.getOptions().setThumbWidth(request.getOptions().getThumbHeight());
                request.getOptions().setThumbHeight(tmp);
            }
            int width = request.getOptions().getSrcWidth();
            int height = request.getOptions().getSrcHeight();
            int sampleW = 1;
            int sampleH = 1;
            while (width / 2 > request.getOptions().getThumbWidth()) {
                width /= 2;
                sampleW <<= 1;
            }
            while (height / 2 > request.getOptions().getThumbHeight()) {
                height /= 2;
                sampleH <<= 1;
            }
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inSampleSize = sampleSize = Math.min(sampleW, sampleH);
            try {
                Bitmap bitmap = null;
                bitmap = BitmapFactory.decodeStream((InputStream)request.getStream(), null, (BitmapFactory.Options)options);
                Matrix matrix = new Matrix();
                int w = bitmap.getWidth();
                int h = bitmap.getHeight();
                if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
                    int tmp = w;
                    w = h;
                    h = tmp;
                }
                switch (request.getOptions().getOrientation()) {
                    case 6: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 3: {
                        matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 8: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 2: {
                        matrix.preScale(-1.0f, 1.0f);
                        break;
                    }
                    case 4: {
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 5: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 7: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                    }
                }
                int x = 0;
                int y = 0;
                if (request.getOptions().getThumbWidth() > bitmap.getWidth() && request.getOptions().getThumbHeight() > bitmap.getHeight()) {
                    height = bitmap.getHeight();
                    width = bitmap.getWidth();
                } else if (request.getOptions().getThumbWidth() > bitmap.getWidth()) {
                    height = bitmap.getWidth() * request.getOptions().getThumbHeight() / request.getOptions().getThumbWidth();
                    width = bitmap.getWidth();
                    x = 0;
                    y = bitmap.getHeight() - request.getOptions().getThumbHeight();
                    y >>= 1;
                } else if (request.getOptions().getThumbHeight() > bitmap.getHeight()) {
                    width = bitmap.getHeight() * request.getOptions().getThumbWidth() / request.getOptions().getThumbHeight();
                    height = bitmap.getHeight();
                    y = 0;
                    x = bitmap.getWidth() - request.getOptions().getThumbWidth();
                    x >>= 1;
                } else {
                    int heightMix;
                    int widthMix = request.getOptions().getThumbWidth() * bitmap.getHeight();
                    if (widthMix == (heightMix = request.getOptions().getThumbHeight() * bitmap.getWidth())) {
                        width = request.getOptions().getThumbWidth();
                        height = request.getOptions().getThumbHeight();
                    } else if (widthMix > heightMix) {
                        height = heightMix / request.getOptions().getThumbWidth();
                        width = request.getOptions().getThumbWidth();
                        y = bitmap.getHeight() - height;
                        y >>= 1;
                    } else {
                        width = widthMix / request.getOptions().getThumbHeight();
                        height = request.getOptions().getThumbHeight();
                        x = bitmap.getWidth() - width;
                        x >>= 1;
                    }
                }
                float scale = 0.0f;
                scale = width > height ? (float)width / (float)bitmap.getWidth() : (float)height / (float)bitmap.getHeight();
                matrix.postScale(scale, scale);
                result = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)(bitmap.getWidth() - (x << 1)), (int)(bitmap.getHeight() - (y << 1)), (Matrix)matrix, (boolean)true);
            }
            catch (Exception e) {
                request.onFailure(new BaseException(e));
            }
        }
        request.onComplete(result);
        return result;
    }

    @Override
    public Bitmap compressResource(AbstractCompressRequest request) {
        Bitmap bitmap;
        Bitmap result = null;
        if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
            int tmp = request.getOptions().getThumbWidth();
            request.getOptions().setThumbWidth(request.getOptions().getThumbHeight());
            request.getOptions().setThumbHeight(tmp);
        }
        int width = request.getOptions().getSrcWidth();
        int height = request.getOptions().getSrcHeight();
        int sampleW = 1;
        int sampleH = 1;
        while (width / 2 > request.getOptions().getThumbWidth()) {
            width /= 2;
            sampleW <<= 1;
        }
        while (height / 2 > request.getOptions().getThumbHeight()) {
            height /= 2;
            sampleH <<= 1;
        }
        int sampleSize = 1;
        BitmapFactory.Options options = new BitmapFactory.Options();
        sampleSize = request.getOptions().getThumbHeight() == Integer.MAX_VALUE || request.getOptions().getThumbWidth() == Integer.MAX_VALUE ? Math.max(sampleW, sampleH) : Math.max(sampleW, sampleH);
        options.inSampleSize = sampleSize;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)request.getStream(), null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            options.inSampleSize <<= 1;
            bitmap = BitmapFactory.decodeStream((InputStream)request.getStream(), null, (BitmapFactory.Options)options);
        }
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return bitmap;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (request.getOptions().getOrientation() == 6 || request.getOptions().getOrientation() == 8 || request.getOptions().getOrientation() == 5 || request.getOptions().getOrientation() == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (request.getOptions().getOrientation()) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        float xS = (float)request.getOptions().getThumbWidth() / (float)bitmap.getWidth();
        float yS = (float)request.getOptions().getThumbHeight() / (float)bitmap.getHeight();
        matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            Log.e((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + xS + " " + yS));
            return null;
        }
        request.onComplete(result);
        return result;
    }
}

